package work.labradors.cos;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

/**
 * @author 姜陶
 * @date 2022/1/18 11:24
 * @describe 腾讯云COS配置
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(prefix = "ses")
public class SesProperties implements Serializable {
    // 秘钥ID
    private String secretId;
    // 秘钥key
    private String secretKey;
    // 发信地址
    private String from;
}
