/*
 * Decompiled with CFR 0.152.
 */
package work.labradors.cos;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.ses.v20201002.SesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import work.labradors.cos.SesProperties;
import work.labradors.cos.SesService;

@Configuration
@EnableConfigurationProperties(value={SesProperties.class})
@ConditionalOnClass(value={SesService.class})
@ConditionalOnProperty(prefix="ses", value={"enabled"}, matchIfMissing=true)
public class SesAutoConfiguration {
    @Autowired
    SesProperties properties;

    SesClient client() {
        Credential credential = new Credential(this.properties.getSecretId(), this.properties.getSecretKey());
        return new SesClient(credential, null);
    }

    @Bean
    @ConditionalOnMissingBean(value={SesService.class})
    public SesService cosService() {
        return new SesService(this.client(), this.properties);
    }
}

