/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.EmptyIterator;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidator;

public final class TextBuffer {
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    private final int mInitialBufSize;
    private char[] mInputBuffer;
    private int mInputStart;
    private int mInputLen;
    private ArrayList mSegments;
    private int mSegmentSize;
    private char[] mCurrentSegment;
    private int mCurrentSize;
    private String mResultString;
    private char[] mResultArray;

    private TextBuffer(int initialSize) {
        this.mInitialBufSize = initialSize;
    }

    public static TextBuffer createRecyclableBuffer() {
        return new TextBuffer(500);
    }

    public static TextBuffer createTemporaryBuffer(int initialSize) {
        return new TextBuffer(initialSize);
    }

    public void clear() {
        this.mResultString = null;
        this.mResultArray = null;
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mSegments = null;
        this.mSegmentSize = 0;
        this.mCurrentSegment = null;
        this.mCurrentSize = 0;
    }

    public void resetWithEmpty() {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
            this.mSegmentSize = 0;
        }
        this.mCurrentSize = 0;
    }

    public void resetWithShared(char[] buf, int start, int len) {
        this.mInputBuffer = buf;
        this.mInputStart = start;
        this.mInputLen = len;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
            this.mSegmentSize = 0;
            this.mCurrentSize = 0;
        }
    }

    public void resetWithCopy(char[] buf, int start, int len) {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
        } else if (this.mCurrentSegment == null) {
            this.mCurrentSegment = new char[this.mInitialBufSize];
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
        this.append(buf, start, len);
    }

    public void resetInitialized() {
        this.resetWithEmpty();
        if (this.mCurrentSegment == null) {
            this.mCurrentSegment = new char[this.mInitialBufSize];
        }
    }

    public int size() {
        if (this.mInputStart >= 0) {
            return this.mInputLen;
        }
        return this.mSegmentSize + this.mCurrentSize;
    }

    public int getTextStart() {
        return this.mInputStart >= 0 ? this.mInputStart : 0;
    }

    public char[] getTextBuffer() {
        if (this.mInputStart >= 0) {
            return this.mInputBuffer;
        }
        if (this.mSegments == null || this.mSegments.size() == 0) {
            return this.mCurrentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this.mResultString == null) {
            if (this.mResultArray != null) {
                this.mResultString = new String(this.mResultArray);
            } else if (this.mInputStart >= 0) {
                if (this.mInputLen < 1) {
                    this.mResultString = "";
                    return "";
                }
                this.mResultString = new String(this.mInputBuffer, this.mInputStart, this.mInputLen);
            } else {
                int size = this.size();
                if (size < 1) {
                    this.mResultString = "";
                    return "";
                }
                StringBuffer sb = new StringBuffer(size);
                if (this.mSegments != null) {
                    int len = this.mSegments.size();
                    for (int i = 0; i < len; ++i) {
                        char[] curr = (char[])this.mSegments.get(i);
                        sb.append(curr, 0, curr.length);
                    }
                }
                sb.append(this.mCurrentSegment, 0, this.mCurrentSize);
                this.mResultString = sb.toString();
            }
        }
        return this.mResultString;
    }

    public char[] contentsAsArray() {
        char[] result = this.mResultArray;
        if (result == null) {
            this.mResultArray = result = this.buildResultArray();
        }
        return result;
    }

    public int contentsToArray(int srcStart, char[] dst, int dstStart, int len) {
        if (this.mInputStart >= 0) {
            int amount = this.mInputLen - srcStart;
            if (amount > len) {
                amount = len;
            } else if (amount < 0) {
                amount = 0;
            }
            if (amount > 0) {
                System.arraycopy(this.mInputBuffer, this.mInputStart + srcStart, dst, dstStart, amount);
            }
            return amount;
        }
        int totalAmount = 0;
        if (this.mSegments != null) {
            int segc = this.mSegments.size();
            for (int i = 0; i < segc; ++i) {
                char[] segment = (char[])this.mSegments.get(i);
                int segLen = segment.length;
                int amount = segLen - srcStart;
                if (amount < 1) {
                    srcStart -= segLen;
                    continue;
                }
                if (amount >= len) {
                    System.arraycopy(segment, srcStart, dst, dstStart, len);
                    return totalAmount + len;
                }
                System.arraycopy(segment, srcStart, dst, dstStart, amount);
                totalAmount += amount;
                dstStart += amount;
                len -= amount;
                srcStart = 0;
            }
        }
        if (len > 0) {
            int maxAmount = this.mCurrentSize - srcStart;
            if (len > maxAmount) {
                len = maxAmount;
            }
            if (len > 0) {
                System.arraycopy(this.mCurrentSegment, srcStart, dst, dstStart, len);
                totalAmount += len;
            }
        }
        return totalAmount;
    }

    public int rawContentsTo(Writer w) throws IOException {
        if (this.mResultArray != null) {
            w.write(this.mResultArray);
            return this.mResultArray.length;
        }
        if (this.mResultString != null) {
            w.write(this.mResultString);
            return this.mResultString.length();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                w.write(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return this.mInputLen;
        }
        int rlen = 0;
        if (this.mSegments != null) {
            int len = this.mSegments.size();
            for (int i = 0; i < len; ++i) {
                char[] ch = (char[])this.mSegments.get(i);
                w.write(ch);
                rlen += ch.length;
            }
        }
        if (this.mCurrentSize > 0) {
            w.write(this.mCurrentSegment, 0, this.mCurrentSize);
            rlen += this.mCurrentSize;
        }
        return rlen;
    }

    public Reader rawContentsViaReader() throws IOException {
        if (this.mResultArray != null) {
            return new CharArrayReader(this.mResultArray);
        }
        if (this.mResultString != null) {
            return new StringReader(this.mResultString);
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                return new CharArrayReader(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return new StringReader("");
        }
        if (this.mSegments == null || this.mSegments.size() == 0) {
            return new CharArrayReader(this.mCurrentSegment, 0, this.mCurrentSize);
        }
        return new BufferReader(this.mSegments, this.mCurrentSegment, this.mCurrentSize);
    }

    public boolean isAllWhitespace() {
        if (this.mInputStart >= 0) {
            int i;
            char[] buf = this.mInputBuffer;
            int last = i + this.mInputLen;
            for (i = this.mInputStart; i < last; ++i) {
                if (buf[i] <= ' ') continue;
                return false;
            }
            return true;
        }
        if (this.mSegments != null) {
            int len = this.mSegments.size();
            for (int i = 0; i < len; ++i) {
                char[] buf = (char[])this.mSegments.get(i);
                int len2 = buf.length;
                for (int j = 0; j < len2; ++j) {
                    if (buf[j] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] buf = this.mCurrentSegment;
        int len = this.mCurrentSize;
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String str) {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
        int segIndex = this.mSegments == null ? 0 : this.mSegments.size();
        int inIndex = str.length() - 1;
        char[] buf = this.mCurrentSegment;
        int bufIndex = this.mCurrentSize - 1;
        while (inIndex >= 0) {
            if (str.charAt(inIndex) != buf[bufIndex]) {
                return false;
            }
            if (--inIndex == 0) break;
            if (--bufIndex >= 0) continue;
            if (--segIndex < 0) {
                return false;
            }
            buf = (char[])this.mSegments.get(segIndex);
            bufIndex = buf.length - 1;
        }
        return true;
    }

    public boolean equalsString(String str) {
        int expLen = str.length();
        if (this.mInputStart >= 0) {
            if (this.mInputLen != expLen) {
                return false;
            }
            for (int i = 0; i < expLen; ++i) {
                if (str.charAt(i) == this.mInputBuffer[this.mInputStart + i]) continue;
                return false;
            }
            return true;
        }
        if (expLen != this.size()) {
            return false;
        }
        char[] seg = this.mSegments == null || this.mSegments.size() == 0 ? this.mCurrentSegment : this.contentsAsArray();
        for (int i = 0; i < expLen; ++i) {
            if (seg[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public void validateText(XMLValidator vld, boolean lastSegment) throws XMLValidationException {
        if (this.mInputStart >= 0) {
            vld.validateText(this.mInputBuffer, this.mInputStart, this.mInputStart + this.mInputLen, lastSegment);
        } else {
            vld.validateText(this.contentsAsString(), lastSegment);
        }
    }

    public void ensureNotShared() {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
    }

    public void append(char c) {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        if (this.mCurrentSize >= curr.length) {
            this.expand(1);
        }
        curr[this.mCurrentSize++] = c;
    }

    public void append(char[] c, int start, int len) {
        if (this.mInputStart >= 0) {
            this.unshare(len);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        int max = curr.length - this.mCurrentSize;
        if (max >= len) {
            System.arraycopy(c, start, curr, this.mCurrentSize, len);
            this.mCurrentSize += len;
        } else {
            if (max > 0) {
                System.arraycopy(c, start, curr, this.mCurrentSize, max);
                start += max;
                len -= max;
            }
            this.expand(len);
            System.arraycopy(c, start, this.mCurrentSegment, 0, len);
            this.mCurrentSize = len;
        }
    }

    public void append(String str) {
        int len = str.length();
        if (this.mInputStart >= 0) {
            this.unshare(len);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        int max = curr.length - this.mCurrentSize;
        if (max >= len) {
            str.getChars(0, len, curr, this.mCurrentSize);
            this.mCurrentSize += len;
        } else {
            if (max > 0) {
                str.getChars(0, max, curr, this.mCurrentSize);
                len -= max;
            }
            this.expand(len);
            str.getChars(max, len, this.mCurrentSegment, 0);
            this.mCurrentSize = len;
        }
    }

    public char[] getCurrentSegment() {
        if (this.mInputStart >= 0) {
            this.unshare(1);
        } else {
            char[] curr = this.mCurrentSegment;
            if (curr == null) {
                this.mCurrentSegment = new char[this.mInitialBufSize];
            } else if (this.mCurrentSize >= curr.length) {
                this.expand(1);
            }
        }
        return this.mCurrentSegment;
    }

    public int getCurrentSegmentSize() {
        return this.mCurrentSize;
    }

    public void setCurrentLength(int len) {
        this.mCurrentSize = len;
    }

    public char[] finishCurrentSegment() {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        this.mSegments.add(this.mCurrentSegment);
        int oldLen = this.mCurrentSegment.length;
        this.mSegmentSize += oldLen;
        char[] curr = new char[oldLen + (oldLen >> 1)];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
        return curr;
    }

    public String toString() {
        return this.contentsAsString();
    }

    public void unshare(int needExtra) {
        int len = this.mInputLen;
        this.mInputLen = 0;
        char[] inputBuf = this.mInputBuffer;
        this.mInputBuffer = null;
        int start = this.mInputStart;
        this.mInputStart = -1;
        int needed = len + needExtra;
        if (this.mCurrentSegment == null || needed > this.mCurrentSegment.length) {
            this.mCurrentSegment = needed > this.mInitialBufSize ? new char[needed] : new char[this.mInitialBufSize];
        }
        if (len > 0) {
            System.arraycopy(inputBuf, start, this.mCurrentSegment, 0, len);
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = len;
    }

    private void expand(int minNewSegmentSize) {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        char[] curr = this.mCurrentSegment;
        this.mSegments.add(curr);
        this.mSegmentSize += curr.length;
        int oldLen = curr.length;
        int sizeAddition = oldLen >> 1;
        if (sizeAddition < minNewSegmentSize) {
            sizeAddition = minNewSegmentSize;
        }
        curr = new char[oldLen + sizeAddition];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
    }

    private char[] buildResultArray() {
        char[] result;
        if (this.mResultString != null) {
            return this.mResultString.toCharArray();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen < 1) {
                return EmptyIterator.getEmptyCharArray();
            }
            result = new char[this.mInputLen];
            System.arraycopy(this.mInputBuffer, this.mInputStart, result, 0, this.mInputLen);
        } else {
            int size = this.size();
            if (size < 1) {
                return EmptyIterator.getEmptyCharArray();
            }
            int offset = 0;
            result = new char[size];
            if (this.mSegments != null) {
                int len = this.mSegments.size();
                for (int i = 0; i < len; ++i) {
                    char[] curr = (char[])this.mSegments.get(i);
                    int currLen = curr.length;
                    System.arraycopy(curr, 0, result, offset, currLen);
                    offset += currLen;
                }
            }
            System.arraycopy(this.mCurrentSegment, 0, result, offset, this.mCurrentSize);
        }
        return result;
    }

    private static final class BufferReader
    extends Reader {
        ArrayList mSegments;
        char[] mCurrentSegment;
        final int mCurrentLength;
        int mSegmentIndex;
        int mSegmentOffset;
        int mCurrentOffset;

        public BufferReader(ArrayList segs, char[] currSeg, int currSegLen) {
            this.mSegments = segs;
            this.mCurrentSegment = currSeg;
            this.mCurrentLength = currSegLen;
            this.mSegmentIndex = 0;
            this.mCurrentOffset = 0;
            this.mSegmentOffset = 0;
        }

        public void close() {
            this.mSegments = null;
            this.mCurrentSegment = null;
        }

        public void mark(int x) throws IOException {
            throw new IOException("mark() not supported");
        }

        public boolean markSupported() {
            return false;
        }

        public int read(char[] cbuf, int offset, int len) {
            if (len < 1) {
                return 0;
            }
            int origOffset = offset;
            while (this.mSegments != null) {
                char[] curr = (char[])this.mSegments.get(this.mSegmentIndex);
                int max = curr.length - this.mSegmentOffset;
                if (len <= max) {
                    System.arraycopy(curr, this.mSegmentOffset, cbuf, offset, len);
                    this.mSegmentOffset += len;
                    return (offset += len) - origOffset;
                }
                if (max > 0) {
                    System.arraycopy(curr, this.mSegmentOffset, cbuf, offset, max);
                    offset += max;
                }
                if (++this.mSegmentIndex >= this.mSegments.size()) {
                    this.mSegments = null;
                    continue;
                }
                this.mSegmentOffset = 0;
            }
            if (len > 0 && this.mCurrentSegment != null) {
                int max = this.mCurrentLength - this.mCurrentOffset;
                if (len >= max) {
                    len = max;
                    System.arraycopy(this.mCurrentSegment, this.mCurrentOffset, cbuf, offset, len);
                    this.mCurrentSegment = null;
                } else {
                    System.arraycopy(this.mCurrentSegment, this.mCurrentOffset, cbuf, offset, len);
                    this.mCurrentOffset += len;
                }
                offset += len;
            }
            return origOffset == offset ? -1 : offset - origOffset;
        }

        public boolean ready() {
            return true;
        }

        public void reset() throws IOException {
            throw new IOException("reset() not supported");
        }

        public long skip(long amount) {
            if (amount < 0L) {
                return 0L;
            }
            long origAmount = amount;
            while (this.mSegments != null) {
                char[] curr = (char[])this.mSegments.get(this.mSegmentIndex);
                int max = curr.length - this.mSegmentOffset;
                if ((long)max >= amount) {
                    this.mSegmentOffset += (int)amount;
                    return origAmount;
                }
                amount -= (long)max;
                if (++this.mSegmentIndex >= this.mSegments.size()) {
                    this.mSegments = null;
                    continue;
                }
                this.mSegmentOffset = 0;
            }
            if (amount > 0L && this.mCurrentSegment != null) {
                int max = this.mCurrentLength - this.mCurrentOffset;
                if (amount >= (long)max) {
                    amount -= (long)max;
                    this.mCurrentSegment = null;
                } else {
                    amount = 0L;
                    this.mCurrentOffset += (int)amount;
                }
            }
            return amount == origAmount ? -1L : origAmount - amount;
        }
    }
}

