/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.SimpleOutputElement;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseNsStreamWriter
extends BaseStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final boolean mAutomaticNS;
    protected SimpleOutputElement mCurrElem = SimpleOutputElement.createRoot();
    protected NamespaceContext mRootNsContext = null;

    public BaseNsStreamWriter(Writer w, String enc, WriterConfig cfg, boolean repairing) {
        super(w, enc, cfg);
        this.mAutomaticNS = repairing;
    }

    public NamespaceContext getNamespaceContext() {
        return this.mCurrElem;
    }

    public String getPrefix(String uri) {
        return this.mCurrElem.getPrefix(uri);
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        if (this.mState != 1) {
            BaseNsStreamWriter.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = ctxt;
        this.mCurrElem.setRootNsContext(ctxt);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (prefix.equals(sPrefixXml)) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix.equals(sPrefixXmlns)) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
        }
        if (!this.mXml11 && uri.length() == 0) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this.doSetPrefix(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen && this.mCheckStructure) {
            BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(localName, null, null, value);
    }

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(localName, "", NO_PREFIX);
        }
        this.mEmptyElement = true;
        this.mCurrElem = this.mCurrElem.createChild(localName);
        this.doWriteStartTag(NO_PREFIX, localName);
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, this.mCfgAutomaticEmptyElems);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(localName, "", NO_PREFIX);
        }
        this.mEmptyElement = false;
        this.mCurrElem = this.mCurrElem.createChild(localName);
        this.doWriteStartTag(NO_PREFIX, localName);
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, false);
    }

    public QName getCurrentElementName() {
        return this.mCurrElem.getName();
    }

    public String getNamespaceURI(String prefix) {
        return this.mCurrElem.getNamespaceURI(prefix);
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndTag(this.mCheckStructure ? name : null, this.mCfgAutomaticEmptyElems);
    }

    protected void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementAndAttributes();
        }
        if (emptyElem) {
            SimpleOutputElement curr = this.mCurrElem;
            this.mCurrElem = curr.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementEnd(curr.getLocalName(), curr.getNamespaceURI(), curr.getPrefix());
            }
        }
    }

    protected String getTopElementDesc() {
        return this.mCurrElem.getNameDesc();
    }

    protected void checkStartElement(String localName, String prefix) throws XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mState == 1) {
            this.verifyRootElement(localName, prefix);
        } else if (this.mState == 3) {
            if (this.mCheckStructure) {
                String name = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
                BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, name);
            }
            this.mState = 2;
        }
    }

    protected void doWriteAttr(String localName, String nsURI, String prefix, String value) throws XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, true);
        }
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(nsURI, localName, value);
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(localName, nsURI, prefix, value);
        }
        try {
            if (this.mAttrValueWriter == null) {
                this.mAttrValueWriter = this.constructAttributeValueWriter();
            }
            this.mWriter.write(32);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            this.mAttrValueWriter.write(value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteNamespace(String prefix, String nsURI) throws XMLStreamException {
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(58);
                this.mWriter.write(prefix);
            }
            this.mWriter.write("=\"");
            if (nsURI != null && nsURI.length() > 0) {
                this.mWriter.write(nsURI);
            }
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteStartTag(String prefix, String localName) throws XMLStreamException {
        if (this.mCheckNames) {
            if (prefix != null && prefix.length() > 0) {
                this.verifyNameValidity(prefix, true);
            }
            this.verifyNameValidity(localName, true);
        }
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            this.mWriter.write(60);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteEndTag(QName expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            BaseNsStreamWriter.reportNwfStructure("No open start element, when trying to write end element");
        }
        SimpleOutputElement thisElem = this.mCurrElem;
        String prefix = thisElem.getPrefix();
        String localName = thisElem.getLocalName();
        this.mCurrElem = thisElem.getParent();
        if (this.mCheckStructure && expName != null && !localName.equals(expName.getLocalPart())) {
            BaseNsStreamWriter.reportNwfStructure("Mismatching close element local name, '" + localName + "'; expected '" + expName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementAndAttributes();
            }
            this.mStartElementOpen = false;
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    if (this.mValidator != null) {
                        this.mVldContent = this.mValidator.validateElementEnd(localName, thisElem.getNamespaceURI(), prefix);
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementEnd(localName, thisElem.getNamespaceURI(), prefix);
        }
    }

    public abstract void doSetPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2, String var3) throws XMLStreamException;
}

