/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import org.codehaus.stax2.validation.XMLValidationException;

public final class DTDNmTokensAttr
extends DTDAttribute {
    public DTDNmTokensAttr(NameKey name, DefaultAttrValue defValue, int specIndex) {
        super(name, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDNmTokensAttr(this.mName, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 9;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start, int end, boolean normalize) throws XMLValidationException {
        int origStart = start;
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v, "Empty NMTOKENS value");
        }
        if (!normalize) {
            while (start < end) {
                char c = cbuf[start];
                if (!WstxInputData.isSpaceChar(c) && !WstxInputData.is11NameChar(c)) {
                    return this.reportInvalidChar(v, c, "not valid as NMTOKENS character");
                }
                ++start;
            }
            return null;
        }
        boolean trimmed = origStart != start;
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
            trimmed = true;
        }
        StringBuffer sb = null;
        while (start <= end) {
            char c;
            int i;
            for (i = start; i <= end && !WstxInputData.isSpaceChar(c = cbuf[i]); ++i) {
                if (WstxInputData.is11NameChar(c)) continue;
                return this.reportInvalidChar(v, c, "not valid as an NMTOKENS character");
            }
            if (sb == null) {
                sb = new StringBuffer(end - start + 1);
            } else {
                sb.append(' ');
            }
            sb.append(cbuf, start, i - start);
            for (start = i + 1; start <= end && WstxInputData.isSpaceChar(cbuf[start]); ++start) {
            }
        }
        return sb.toString();
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String defValue = this.mDefValue.getValue();
        int len = defValue.length();
        StringBuffer sb = null;
        int count = 0;
        int start = 0;
        block0: while (start < len) {
            char c = defValue.charAt(start);
            while (WstxInputData.isSpaceChar(c)) {
                if (++start >= len) break block0;
                c = defValue.charAt(start);
            }
            int i = start + 1;
            do {
                if (WstxInputData.is11NameChar(c)) continue;
                this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + WstxInputData.getCharDesc(c) + ") not a valid NMTOKENS character");
                return;
            } while (++i < len && !WstxInputData.isSpaceChar(c = defValue.charAt(i)));
            ++count;
            if (normalize) {
                if (sb == null) {
                    sb = new StringBuffer(i - start + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(defValue.substring(start, i));
            }
            start = i + 1;
        }
        if (count == 0) {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKENS value");
            return;
        }
        if (normalize) {
            this.mDefValue.setValue(sb.toString());
        }
    }
}

