/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.dtd.MinimalDTDReader;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import java.util.StringTokenizer;
import org.codehaus.stax2.validation.XMLValidationException;

public final class DTDEntitiesAttr
extends DTDAttribute {
    public DTDEntitiesAttr(NameKey name, DefaultAttrValue defValue, int specIndex) {
        super(name, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDEntitiesAttr(this.mName, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 6;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start, int end, boolean normalize) throws XMLValidationException {
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v, "Empty ENTITIES value");
        }
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
        }
        String idStr = null;
        StringBuffer sb = null;
        while (start <= end) {
            int i;
            int c = cbuf[start];
            if (!WstxInputData.is11NameStartChar((char)c) && c != 58) {
                return this.reportInvalidChar(v, (char)c, "not valid as the first ENTITIES character");
            }
            int hash = c;
            for (i = start + 1; i <= end && !WstxInputData.isSpaceChar((char)(c = cbuf[i])); ++i) {
                if (!WstxInputData.is11NameChar((char)c)) {
                    return this.reportInvalidChar(v, (char)c, "not valid as an ENTITIES character");
                }
                hash = hash * 31 + c;
            }
            EntityDecl ent = this.findEntityDecl(v, cbuf, start, i - start, hash);
            start = i + 1;
            if (normalize) {
                if (idStr == null) {
                    idStr = ent.getName();
                } else {
                    if (sb == null) {
                        sb = new StringBuffer(idStr);
                    }
                    idStr = ent.getName();
                    sb.append(' ');
                    sb.append(idStr);
                }
            }
            while (start <= end && WstxInputData.isSpaceChar(cbuf[start])) {
                ++start;
            }
        }
        if (normalize) {
            if (sb != null) {
                idStr = sb.toString();
            }
            return idStr;
        }
        return null;
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String normStr = this.validateDefaultNames(rep, true);
        if (normalize) {
            this.mDefValue.setValue(normStr);
        }
        StringTokenizer st = new StringTokenizer(normStr);
        MinimalDTDReader dtdr = (MinimalDTDReader)rep;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            EntityDecl ent = dtdr.findEntity(str);
            this.checkEntity(rep, normStr, ent);
        }
    }
}

