/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.exc.WstxParsingException;
import com.ctc.wstx.io.WstxInputLocation;
import com.ctc.wstx.util.TextAccumulator;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class DOMWrappingReader
implements XMLStreamReader2,
DTDInfo,
LocationInfo,
XMLStreamConstants {
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    protected final ReaderConfig mConfig;
    protected final String mSystemId;
    protected final Node mRootNode;
    protected int mCurrEvent = 7;

    private DOMWrappingReader(ReaderConfig cfg, Node treeRoot, String sysId) throws XMLStreamException {
        this.mConfig = cfg;
        this.mSystemId = sysId;
        if (!(treeRoot instanceof Document || treeRoot instanceof Document || treeRoot instanceof DocumentFragment)) {
            if (treeRoot == null) {
                throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamReader");
            }
            throw new XMLStreamException("Can not create an XMLStreamReader for a DOM node of type " + treeRoot.getClass());
        }
        this.mRootNode = treeRoot;
    }

    public static DOMWrappingReader createFrom(ReaderConfig cfg, DOMSource src) throws XMLStreamException {
        Node rootNode = src.getNode();
        String systemId = src.getSystemId();
        return new DOMWrappingReader(cfg, rootNode, systemId);
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public int getAttributeCount() {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return 0;
    }

    public String getAttributeLocalName(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public QName getAttributeName(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getAttributeNamespace(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getAttributeType(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getAttributeValue(String nsURI, String localName) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public String getElementText() throws XMLStreamException {
        int type;
        if (this.mCurrEvent != 1) {
            this.throwParseError(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        TextAccumulator acc = new TextAccumulator();
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                this.throwParseError("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type) + ".");
            }
            acc.addText(this.getText());
        }
        return acc.getAndClear();
    }

    public int getEventType() {
        return this.mCurrEvent;
    }

    public String getLocalName() {
        if (this.mCurrEvent == 1 || this.mCurrEvent == 2) {
            return null;
        }
        if (this.mCurrEvent == 9) {
            return null;
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    public QName getName() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return null;
    }

    public int getNamespaceCount() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return 0;
    }

    public String getNamespacePrefix(int index) {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public String getNamespaceURI() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public String getNamespaceURI(int index) {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public String getPIData() {
        if (this.mCurrEvent != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return null;
    }

    public String getPITarget() {
        if (this.mCurrEvent != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return null;
    }

    public String getPrefix() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return null;
    }

    public String getText() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return null;
    }

    public char[] getTextCharacters() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return null;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int len) {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return -1;
    }

    public int getTextLength() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return 0;
    }

    public int getTextStart() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return 0;
    }

    public boolean hasName() {
        return this.mCurrEvent == 1 || this.mCurrEvent == 2;
    }

    public boolean hasNext() {
        return this.mCurrEvent != 8;
    }

    public boolean hasText() {
        return (1 << this.mCurrEvent & 0x1A70) != 0;
    }

    public boolean isAttributeSpecified(int index) {
        return true;
    }

    public boolean isCharacters() {
        return this.mCurrEvent == 4;
    }

    public boolean isEndElement() {
        return this.mCurrEvent == 2;
    }

    public boolean isStartElement() {
        return this.mCurrEvent == 1;
    }

    public boolean isWhiteSpace() {
        if (this.mCurrEvent == 4 || this.mCurrEvent == 12) {
            return false;
        }
        return this.mCurrEvent == 6;
    }

    public void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this.mCurrEvent;
        if (curr != type) {
            if (curr == 12) {
                curr = 4;
            } else if (curr == 6) {
                curr = 4;
            }
        }
        if (type != curr) {
            this.throwParseError("Expected type " + ErrorConsts.tokenTypeDesc(type) + ", current type " + ErrorConsts.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwParseError("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ")");
            }
            if ((n = this.getLocalName()) != localName && !n.equals(localName)) {
                this.throwParseError("Expected local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null && curr != 1 && curr != 2) {
            this.throwParseError("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(curr) + ")");
        }
    }

    public int next() throws XMLStreamException {
        return this.mCurrEvent;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwParseError("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public void close() throws XMLStreamException {
    }

    public Object getFeature(String name) {
        throw new IllegalArgumentException(MessageFormat.format(ErrorConsts.ERR_UNKNOWN_FEATURE, name));
    }

    public void setFeature(String name, Object value) {
        throw new IllegalArgumentException(MessageFormat.format(ErrorConsts.ERR_UNKNOWN_FEATURE, name));
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value) {
        return this.mConfig.setProperty(name, value);
    }

    public void skipElement() throws XMLStreamException {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this.mCurrEvent != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws IOException, XMLStreamException {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return -1;
    }

    public int getDepth() {
        return -1;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        return false;
    }

    public NamespaceContext getNonTransientNamespaceContext() {
        return null;
    }

    public String getPrefixedName() {
        switch (this.mCurrEvent) {
            case 1: 
            case 2: {
                String prefix = this.getPrefix();
                String ln = this.getLocalName();
                if (prefix == null) {
                    return ln;
                }
                StringBuffer sb = new StringBuffer(ln.length() + 1 + prefix.length());
                sb.append(prefix);
                sb.append(':');
                sb.append(ln);
                return sb.toString();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        return null;
    }

    public String getDTDPublicId() {
        return null;
    }

    public String getDTDSystemId() {
        return null;
    }

    public String getDTDInternalSubset() {
        return null;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return 0L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public final Location getLocation() {
        return this.getStartLocation();
    }

    public XMLStreamLocation2 getStartLocation() {
        return null;
    }

    public XMLStreamLocation2 getCurrentLocation() {
        return null;
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return null;
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    protected WstxInputLocation getLastCharLocation() {
        return null;
    }

    private void throwNotTextual(int type) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ")");
    }

    public void throwParseError(String msg) throws WstxParsingException {
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    public void throwParseError(String format, Object arg) throws WstxParsingException {
        String msg = MessageFormat.format(format, arg);
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }
}

