/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.util.EmptyNamespaceContext;
import com.ctc.wstx.util.StringVector;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class NonNsStreamWriter
extends BaseStreamWriter {
    final StringVector mElements = new StringVector(32);
    TreeMap mAttrNames;

    public NonNsStreamWriter(Writer w, String enc, WriterConfig cfg) {
        super(w, enc, cfg);
    }

    public NamespaceContext getNamespaceContext() {
        return EmptyNamespaceContext.getInstance();
    }

    public String getPrefix(String uri) {
        return null;
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set default namespace for non-namespace writer.");
    }

    public void setNamespaceContext(NamespaceContext context) {
        throw new IllegalArgumentException("Can not set NamespaceContext for non-namespace writer.");
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set namespace prefix for non-namespace writer.");
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (this.mCheckNames) {
            NonNsStreamWriter.verifyNameValidity(localName, false);
        }
        if (this.mCheckAttrs) {
            if (this.mAttrNames == null) {
                this.mAttrNames = new TreeMap();
                this.mAttrNames.put(localName, value);
            } else {
                String old = this.mAttrNames.put(localName, value);
                if (old != null) {
                    throw new IllegalArgumentException("Trying to write attribute '" + localName + "' twice (first value '" + old + "'; second '" + value + "').");
                }
            }
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(localName, "", NO_PREFIX, value);
        }
        try {
            if (this.mAttrValueWriter == null) {
                this.mAttrValueWriter = this.constructAttributeValueWriter();
            }
            this.mWriter.write(32);
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            this.mAttrValueWriter.write(value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(localName, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(localName, value);
    }

    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set write namespaces with non-namespace writer.");
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.doWriteStartElement(localName);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(localName);
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeEmptyElement(localName);
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, this.mCfgAutomaticEmptyElems);
    }

    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set write namespaces with non-namespace writer.");
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.doWriteStartElement(localName);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, false);
    }

    public QName getCurrentElementName() {
        if (this.mElements.isEmpty()) {
            return null;
        }
        return new QName(this.mElements.getLastString());
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public void writeStartElement(StartElement elem) throws XMLStreamException {
        QName name = elem.getName();
        this.writeStartElement(name.getLocalPart());
        Iterator<Attribute> it = elem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            name = attr.getName();
            this.writeAttribute(name.getLocalPart(), attr.getValue());
        }
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndElement(this.mCheckStructure ? name.getLocalPart() : null, this.mCfgAutomaticEmptyElems);
    }

    protected void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        if (this.mAttrNames != null) {
            this.mAttrNames.clear();
        }
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementAndAttributes();
        }
        if (emptyElem) {
            String localName = this.mElements.removeLast();
            if (this.mElements.isEmpty()) {
                this.mState = 3;
            }
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementEnd(localName, "", NO_PREFIX);
            }
        }
    }

    public void copyStartElement(InputElementStack elemStack, AttributeCollector attrCollector) throws IOException, XMLStreamException {
        int attrCount;
        int nsCount;
        String prefix;
        String ln = elemStack.getLocalName();
        boolean nsAware = elemStack.isNamespaceAware();
        if (nsAware && (prefix = elemStack.getPrefix()) != null && prefix.length() > 0) {
            ln = prefix + ":" + ln;
        }
        this.writeStartElement(ln);
        if (nsAware && (nsCount = elemStack.getCurrentNsCount()) > 0) {
            for (int i = 0; i < nsCount; ++i) {
                String prefix2 = elemStack.getLocalNsPrefix(i);
                prefix2 = prefix2 == null || prefix2.length() == 0 ? "xml" : "xmlns:" + prefix2;
                this.writeAttribute(prefix2, elemStack.getLocalNsURI(i));
            }
        }
        int n = attrCount = this.mCfgCopyDefaultAttrs ? attrCollector.getCount() : attrCollector.getSpecifiedCount();
        if (attrCount > 0) {
            Writer aw = this.mAttrValueWriter;
            if (aw == null) {
                this.mAttrValueWriter = aw = this.constructAttributeValueWriter();
            }
            for (int i = 0; i < attrCount; ++i) {
                this.mWriter.write(32);
                attrCollector.writeAttribute(i, '\"', this.mWriter, aw);
            }
        }
    }

    protected String getTopElementDesc() {
        return this.mElements.isEmpty() ? "#root" : this.mElements.getLastString();
    }

    private void doWriteStartElement(String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckNames) {
            NonNsStreamWriter.verifyNameValidity(localName, false);
        }
        if (this.mState == 1) {
            this.verifyRootElement(localName, null);
        } else if (this.mCheckStructure && this.mState == 3) {
            throw new IllegalStateException("Trying to output second root ('" + localName + "').");
        }
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(localName, "", NO_PREFIX);
        }
        this.mStartElementOpen = true;
        this.mElements.addString(localName);
        try {
            this.mWriter.write(60);
            this.mWriter.write(localName);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private void doWriteEndElement(String expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            NonNsStreamWriter.throwOutputError("No open start element, when trying to write end element");
        }
        String localName = this.mElements.removeLast();
        if (expName != null && !localName.equals(expName)) {
            throw new IllegalArgumentException("Mismatching close element name, '" + localName + "'; expected '" + expName + "'.");
        }
        if (this.mStartElementOpen) {
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementAndAttributes();
            }
            this.mStartElementOpen = false;
            if (this.mAttrNames != null) {
                this.mAttrNames.clear();
            }
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mElements.isEmpty()) {
                        this.mState = 3;
                    }
                    if (this.mValidator != null) {
                        this.mVldContent = this.mValidator.validateElementEnd(localName, "", NO_PREFIX);
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mElements.isEmpty()) {
            this.mState = 3;
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementEnd(localName, "", NO_PREFIX);
        }
    }
}

