/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.DTDValidator;
import com.ctc.wstx.dtd.FullDTDReader;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.DefaultInputResolver;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.sr.BasicStreamReader;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.util.URLUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class ValidatingStreamReader
extends BasicStreamReader {
    static final String STAX_PROP_ENTITIES = "javax.xml.stream.entities";
    static final String STAX_PROP_NOTATIONS = "javax.xml.stream.notations";
    DTDValidationSchema mDTD = null;
    boolean mDTDOverridden = false;

    private ValidatingStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputElementStack elemStack, boolean forER) throws IOException, XMLStreamException {
        super(input, owner, cfg, elemStack, forER);
    }

    public static ValidatingStreamReader createValidatingStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputBootstrapper bs, boolean forER) throws IOException, XMLStreamException {
        InputElementStack elemStack = BasicStreamReader.createElementStack(cfg);
        ValidatingStreamReader sr = new ValidatingStreamReader(input, owner, cfg, elemStack, forER);
        sr.initProlog(bs);
        return sr;
    }

    public Object getProperty(String name) {
        if (name.equals(STAX_PROP_ENTITIES)) {
            this.safeEnsureFinishToken();
            if (this.mDTD == null || !(this.mDTD instanceof DTDSubset)) {
                return null;
            }
            return ((DTDSubset)this.mDTD).getGeneralEntityList();
        }
        if (name.equals(STAX_PROP_NOTATIONS)) {
            this.safeEnsureFinishToken();
            if (this.mDTD == null || !(this.mDTD instanceof DTDSubset)) {
                return null;
            }
            return ((DTDSubset)this.mDTD).getNotationList();
        }
        return super.getProperty(name);
    }

    public void setFeature(String name, Object value) {
        if (name.equals("org.codehaus.stax2.propDtdOverride")) {
            this.mDTDOverridden = true;
            if (value != null && !(value instanceof XMLValidationSchema)) {
                throw new IllegalArgumentException("Value to set for feature " + name + " not of type XMLValidationSchema");
            }
            this.mDTD = (DTDValidationSchema)value;
        } else {
            super.setFeature(name, value);
        }
    }

    public Object getProcessedDTD() {
        return this.mDTD;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return this.mDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishDTD(boolean copyContents) throws IOException, XMLStreamException {
        if (!this.hasConfigFlags(16)) {
            super.finishDTD(copyContents);
            return;
        }
        char c = this.getNextChar(" in DOCTYPE declaration");
        DTDSubset intSubset = null;
        if (c == '[') {
            if (copyContents) {
                ((BranchingReaderSource)this.mInput).startBranch(this.mTextBuffer, this.mInputPtr, this.mCfgNormalizeLFs);
            }
            try {
                intSubset = FullDTDReader.readInternalSubset(this, this.mInput, this.mConfig, this.hasConfigFlags(32));
                Object var5_4 = null;
                if (copyContents) {
                    ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (copyContents) {
                    ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr - 1);
                }
                throw throwable;
            }
            c = this.getNextCharAfterWS(" in internal DTD subset");
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, "; expected '>' to finish DOCTYPE declaration.");
        }
        if (!this.mDTDOverridden) {
            DTDSubset extSubset;
            DTDSubset dTDSubset = extSubset = this.mDtdPublicId != null || this.mDtdSystemId != null ? this.findDtdExtSubset(this.mDtdPublicId, this.mDtdSystemId, intSubset) : null;
            this.mDTD = intSubset == null ? extSubset : (extSubset == null ? intSubset : intSubset.combineWithExternalSubset(this, extSubset));
        }
        if (this.mDTD == null) {
            this.mGeneralEntities = null;
        } else {
            if (this.mDTD instanceof DTDSubset) {
                this.mGeneralEntities = ((DTDSubset)this.mDTD).getGeneralEntityMap();
            } else {
                this.doReportProblem(this.mConfig.getXMLReporter(), ErrorConsts.WT_DT_DECL, "Value to set for feature org.codehaus.stax2.propDtdOverride not a native Woodstox DTD implementation (but " + this.mDTD.getClass() + "): can not access full entity or notation information", null);
            }
            if (this.hasConfigFlags(32)) {
                XMLValidator vld = this.mDTD.createValidator(this.mElementStack);
                if (vld instanceof DTDValidator) {
                    ((DTDValidator)vld).setAttrValueNormalization(this.mCfgNormalizeAttrs);
                }
                this.mElementStack.setValidator(vld);
            }
        }
    }

    protected void initValidation() throws XMLStreamException {
        if (this.hasConfigFlags(32) && !this.mElementStack.hasDTDValidator()) {
            this.reportProblem(ErrorConsts.WT_DT_DECL, ErrorConsts.W_MISSING_DTD);
        }
    }

    private DTDSubset findDtdExtSubset(String pubId, String sysId, DTDSubset intSubset) throws IOException, XMLStreamException {
        DTDSubset extSubset;
        boolean cache = this.hasConfigFlags(65536);
        DTDId dtdId = this.constructDtdId(pubId, sysId);
        if (cache && (extSubset = this.findCachedSubset(dtdId, intSubset)) != null) {
            return extSubset;
        }
        URL sysRef = dtdId.getSystemId();
        if (sysId == null) {
            this.throwParseError("Can not resolve DTD with public id '" + this.mDtdPublicId + "'; missing system identifier.");
        }
        if (sysRef == null) {
            sysRef = this.resolveExtSubsetPath(sysId);
        }
        WstxInputSource src = null;
        try {
            src = DefaultInputResolver.resolveEntity(this.mInput, null, pubId, sysId, this.mConfig.getDtdResolver(), this.mConfig.getXMLReporter());
        }
        catch (FileNotFoundException fex) {
            this.throwParseError("(was " + fex.getClass().getName() + ") " + fex.getMessage());
        }
        DTDSubset extSubset2 = FullDTDReader.readExternalSubset(src, this.mConfig, intSubset, this.hasConfigFlags(32));
        if (cache && extSubset2.isCachable()) {
            this.mOwner.addCachedDTD(dtdId, extSubset2);
        }
        return extSubset2;
    }

    private DTDSubset findCachedSubset(DTDId id, DTDSubset intSubset) throws XMLStreamException {
        DTDSubset extSubset = this.mOwner.findCachedDTD(id);
        if (extSubset != null && (intSubset == null || extSubset.isReusableWith(intSubset))) {
            return extSubset;
        }
        return null;
    }

    private URL resolveExtSubsetPath(String systemId) throws IOException {
        URL ctxt;
        URL uRL = ctxt = this.mInput == null ? null : this.mInput.getSource();
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(systemId);
        }
        return URLUtil.urlFromSystemId(systemId, ctxt);
    }

    protected DTDId constructDtdId(String pubId, String sysId) throws IOException {
        URL sysRef;
        int significantFlags = this.mConfigFlags & 0x46021;
        URL uRL = sysRef = sysId == null || sysId.length() == 0 ? null : this.resolveExtSubsetPath(sysId);
        if (pubId != null && pubId.length() > 0) {
            return DTDId.construct(pubId, sysRef, significantFlags);
        }
        if (sysRef == null) {
            return null;
        }
        return DTDId.constructFromSystemId(sysRef, significantFlags);
    }

    protected DTDId constructDtdId(URL sysId) throws IOException {
        int significantFlags = this.mConfigFlags & 0x46021;
        return DTDId.constructFromSystemId(sysId, significantFlags);
    }

    protected void reportInvalidContent(int evtType) throws XMLStreamException {
        switch (this.mVldContent) {
            case 0: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_EMPTY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            case 1: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_NON_MIXED, (Object)this.mElementStack.getTopElementDesc());
                break;
            }
            case 2: 
            case 3: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_ANY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            default: {
                this.throwParseError("Internal error: trying to report invalid content for " + evtType);
            }
        }
    }
}

