/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.api;

import com.ctc.wstx.api.WstxInputProperties;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.ent.IntEntity;
import com.ctc.wstx.util.ArgUtil;
import com.ctc.wstx.util.EmptyIterator;
import com.ctc.wstx.util.SymbolTable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;

public final class ReaderConfig
implements InputConfigFlags {
    public static final int PROP_COALESCE_TEXT = 1;
    public static final int PROP_NAMESPACE_AWARE = 2;
    public static final int PROP_REPLACE_ENTITY_REFS = 3;
    public static final int PROP_SUPPORT_EXTERNAL_ENTITIES = 4;
    public static final int PROP_VALIDATE_AGAINST_DTD = 5;
    public static final int PROP_SUPPORT_DTD = 6;
    public static final int PROP_EVENT_ALLOCATOR = 7;
    public static final int PROP_WARNING_REPORTER = 8;
    public static final int PROP_XML_RESOLVER = 9;
    public static final int PROP_INTERN_NS_URIS = 20;
    public static final int PROP_INTERN_NAMES = 21;
    public static final int PROP_REPORT_ALL_TEXT_AS_CHARACTERS = 22;
    public static final int PROP_REPORT_PROLOG_WS = 23;
    public static final int PROP_PRESERVE_LOCATION = 24;
    public static final int PROP_AUTO_CLOSE_INPUT = 25;
    public static final int PROP_NORMALIZE_LFS = 40;
    public static final int PROP_NORMALIZE_ATTR_VALUES = 41;
    public static final int PROP_CACHE_DTDS = 42;
    public static final int PROP_LAZY_PARSING = 43;
    public static final int PROP_SUPPORT_DTDPP = 44;
    public static final int PROP_INPUT_BUFFER_LENGTH = 50;
    public static final int PROP_TEXT_BUFFER_LENGTH = 51;
    public static final int PROP_MIN_TEXT_SEGMENT = 52;
    public static final int PROP_CUSTOM_INTERNAL_ENTITIES = 53;
    public static final int PROP_DTD_RESOLVER = 54;
    public static final int PROP_ENTITY_RESOLVER = 55;
    public static final int PROP_UNDECLARED_ENTITY_RESOLVER = 56;
    public static final int PROP_BASE_URL = 57;
    public static final int PROP_INPUT_PARSING_MODE = 58;
    static final int MIN_INPUT_BUFFER_LENGTH = 8;
    static final int MIN_TEXT_BUFFER_LENGTH = 32;
    static final int DTD_CACHE_SIZE_J2SE = 30;
    static final int DTD_CACHE_SIZE_J2ME = 10;
    public static final int DEFAULT_SHORTEST_TEXT_SEGMENT = 64;
    static final int DEFAULT_FLAGS_FULL = 486687;
    static final int DEFAULT_FLAGS_J2ME = 486687;
    static final HashMap sProperties = new HashMap(64);
    final boolean mIsJ2MESubset;
    final SymbolTable mSymbols;
    int mConfigFlags;
    int mInputBufferLen;
    int mTextBufferLen;
    int mMinTextSegmentLen;
    Map mCustomEntities;
    XMLReporter mReporter;
    XMLResolver mDtdResolver = null;
    XMLResolver mEntityResolver = null;
    XMLResolver mUndeclaredEntityResolver = null;
    URL mBaseURL = null;
    WstxInputProperties.ParsingMode mParsingMode = WstxInputProperties.PARSING_MODE_DOCUMENT;

    private ReaderConfig(boolean j2meSubset, SymbolTable symbols, int configFlags, int inputBufLen, int textBufLen, int minTextSegmentLen) {
        this.mIsJ2MESubset = j2meSubset;
        this.mSymbols = symbols;
        this.mConfigFlags = configFlags;
        this.mInputBufferLen = inputBufLen;
        this.mTextBufferLen = textBufLen;
        this.mMinTextSegmentLen = minTextSegmentLen;
    }

    public static ReaderConfig createJ2MEDefaults() {
        ReaderConfig rc = new ReaderConfig(true, null, 486687, 2000, 1000, 64);
        return rc;
    }

    public static ReaderConfig createFullDefaults() {
        ReaderConfig rc = new ReaderConfig(false, null, 486687, 4000, 2000, 64);
        return rc;
    }

    public ReaderConfig createNonShared(SymbolTable sym) {
        if (sym == null) {
            // empty if block
        }
        ReaderConfig rc = new ReaderConfig(this.mIsJ2MESubset, sym, this.mConfigFlags, this.mInputBufferLen, this.mTextBufferLen, this.mMinTextSegmentLen);
        rc.mCustomEntities = this.mCustomEntities;
        rc.mReporter = this.mReporter;
        rc.mDtdResolver = this.mDtdResolver;
        rc.mEntityResolver = this.mEntityResolver;
        rc.mUndeclaredEntityResolver = this.mUndeclaredEntityResolver;
        rc.mBaseURL = this.mBaseURL;
        rc.mParsingMode = this.mParsingMode;
        return rc;
    }

    public Object getProperty(String propName) {
        return this.getProperty(this.getPropertyId(propName));
    }

    public boolean isPropertySupported(String name) {
        boolean b = sProperties.containsKey(name);
        return b;
    }

    public boolean setProperty(String propName, Object value) {
        return this.setProperty(propName, this.getPropertyId(propName), value);
    }

    public SymbolTable getSymbols() {
        return this.mSymbols;
    }

    public int getDtdCacheSize() {
        return this.mIsJ2MESubset ? 10 : 30;
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean hasConfigFlags(int flags) {
        return (this.mConfigFlags & flags) == flags;
    }

    public boolean willCoalesceText() {
        return this.hasConfigFlags(2);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlags(1);
    }

    public boolean willReplaceEntityRefs() {
        return this.hasConfigFlags(4);
    }

    public boolean willSupportExternalEntities() {
        return this.hasConfigFlags(8);
    }

    public boolean willSupportDTDs() {
        return this.hasConfigFlags(16);
    }

    public boolean willValidateWithDTD() {
        return this.hasConfigFlags(32);
    }

    public boolean willNormalizeLFs() {
        return this.hasConfigFlags(8192);
    }

    public boolean willNormalizeAttrValues() {
        return this.hasConfigFlags(16384);
    }

    public boolean willInternNames() {
        return true;
    }

    public boolean willInternNsURIs() {
        return this.hasConfigFlags(1024);
    }

    public boolean willReportAllTextAsCharacters() {
        return this.hasConfigFlags(512);
    }

    public boolean willReportPrologWhitespace() {
        return this.hasConfigFlags(256);
    }

    public boolean willCacheDTDs() {
        return this.hasConfigFlags(65536);
    }

    public boolean willParseLazily() {
        return this.hasConfigFlags(131072);
    }

    public boolean willPreserveLocation() {
        return this.hasConfigFlags(2048);
    }

    public boolean willAutoCloseInput() {
        return this.hasConfigFlags(4096);
    }

    public boolean willSupportDTDPP() {
        return this.hasConfigFlags(262144);
    }

    public int getInputBufferLength() {
        return this.mInputBufferLen;
    }

    public int getTextBufferLength() {
        return this.mTextBufferLen;
    }

    public int getShortestReportedTextSegment() {
        return this.mMinTextSegmentLen;
    }

    public Map getCustomInternalEntities() {
        if (this.mCustomEntities == null) {
            return JdkFeatures.getInstance().getEmptyMap();
        }
        int len = this.mCustomEntities.size();
        HashMap m = new HashMap(len + (len >> 2), 0.81f);
        Iterator it = this.mCustomEntities.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            m.put(me.getKey(), (EntityDecl)me.getValue());
        }
        return m;
    }

    public XMLReporter getXMLReporter() {
        return this.mReporter;
    }

    public XMLResolver getXMLResolver() {
        return this.mEntityResolver;
    }

    public XMLResolver getDtdResolver() {
        return this.mDtdResolver;
    }

    public XMLResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    public XMLResolver getUndeclaredEntityResolver() {
        return this.mUndeclaredEntityResolver;
    }

    public URL getBaseURL() {
        return this.mBaseURL;
    }

    public WstxInputProperties.ParsingMode getInputParsingMode() {
        return this.mParsingMode;
    }

    public boolean inputParsingModeDocuments() {
        return this.mParsingMode == WstxInputProperties.PARSING_MODE_DOCUMENTS;
    }

    public boolean inputParsingModeFragment() {
        return this.mParsingMode == WstxInputProperties.PARSING_MODE_FRAGMENT;
    }

    public void setConfigFlags(int flags) {
        this.mConfigFlags = flags;
    }

    public void setConfigFlag(int flag) {
        this.mConfigFlags |= flag;
    }

    public void clearConfigFlag(int flag) {
        this.mConfigFlags &= ~flag;
    }

    public void doCoalesceText(boolean state) {
        this.setConfigFlag(2, state);
    }

    public void doSupportNamespaces(boolean state) {
        this.setConfigFlag(1, state);
    }

    public void doReplaceEntityRefs(boolean state) {
        this.setConfigFlag(4, state);
    }

    public void doSupportExternalEntities(boolean state) {
        this.setConfigFlag(8, state);
    }

    public void doSupportDTDs(boolean state) {
        this.setConfigFlag(16, state);
    }

    public void doValidateWithDTD(boolean state) {
        this.setConfigFlag(32, state);
    }

    public void doNormalizeLFs(boolean state) {
        this.setConfigFlag(8192, state);
    }

    public void doNormalizeAttrValues(boolean state) {
        this.setConfigFlag(16384, state);
    }

    public void doInternNames(boolean state) {
    }

    public void doInternNsURIs(boolean state) {
        this.setConfigFlag(1024, state);
    }

    public void doReportPrologWhitespace(boolean state) {
        this.setConfigFlag(256, state);
    }

    public void doReportAllTextAsCharacters(boolean state) {
        this.setConfigFlag(512, state);
    }

    public void doCacheDTDs(boolean state) {
        this.setConfigFlag(65536, state);
    }

    public void doParseLazily(boolean state) {
        this.setConfigFlag(131072, state);
    }

    public void doPreserveLocation(boolean state) {
        this.setConfigFlag(2048, state);
    }

    public void doAutoCloseInput(boolean state) {
        this.setConfigFlag(4096, state);
    }

    public void doSupportDTDPP(boolean state) {
        this.setConfigFlag(262144, state);
    }

    public void setInputBufferLength(int value) {
        if (value < 8) {
            value = 8;
        }
        this.mInputBufferLen = value;
    }

    public void setTextBufferLength(int value) {
        if (value < 32) {
            value = 32;
        }
        this.mTextBufferLen = value;
    }

    public void setShortestReportedTextSegment(int value) {
        this.mMinTextSegmentLen = value;
    }

    public void setCustomInternalEntities(Map m) {
        HashMap<String, IntEntity> entMap;
        if (m == null || m.size() < 1) {
            entMap = JdkFeatures.getInstance().getEmptyMap();
        } else {
            int len = m.size();
            entMap = new HashMap<String, IntEntity>(len + (len >> 1), 0.75f);
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                char[] ch;
                Map.Entry me = it.next();
                Object val = me.getValue();
                if (val == null) {
                    ch = EmptyIterator.getEmptyCharArray();
                } else if (val instanceof char[]) {
                    ch = (char[])val;
                } else {
                    String str = val.toString();
                    ch = str.toCharArray();
                }
                String name = (String)me.getKey();
                entMap.put(name, IntEntity.create(name, ch));
            }
        }
        this.mCustomEntities = entMap;
    }

    public void setXMLReporter(XMLReporter r) {
        this.mReporter = r;
    }

    public void setXMLResolver(XMLResolver r) {
        this.mEntityResolver = r;
        this.mDtdResolver = r;
    }

    public void setDtdResolver(XMLResolver r) {
        this.mDtdResolver = r;
    }

    public void setEntityResolver(XMLResolver r) {
        this.mEntityResolver = r;
    }

    public void setUndeclaredEntityResolver(XMLResolver r) {
        this.mUndeclaredEntityResolver = r;
    }

    public void setBaseURL(URL baseURL) {
        this.mBaseURL = baseURL;
    }

    public void setInputParsingMode(WstxInputProperties.ParsingMode mode) {
        this.mParsingMode = mode;
    }

    public void configureForXmlConformance() {
        this.doSupportNamespaces(true);
        this.doSupportDTDs(true);
        this.doSupportExternalEntities(true);
        this.doReplaceEntityRefs(true);
        this.doNormalizeLFs(true);
        this.doNormalizeAttrValues(true);
    }

    public void configureForConvenience() {
        this.doCoalesceText(true);
        this.doReplaceEntityRefs(true);
        this.doReportAllTextAsCharacters(true);
        this.doReportPrologWhitespace(false);
        this.doPreserveLocation(true);
        this.doParseLazily(false);
    }

    public void configureForSpeed() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
        this.doReportPrologWhitespace(false);
        this.doInternNsURIs(true);
        this.doNormalizeLFs(false);
        this.doNormalizeAttrValues(false);
        this.doCacheDTDs(true);
        this.doParseLazily(true);
        this.setShortestReportedTextSegment(16);
        this.setInputBufferLength(8000);
        this.setTextBufferLength(4000);
    }

    public void configureForLowMemUsage() {
        this.doCoalesceText(false);
        this.doPreserveLocation(false);
        this.doCacheDTDs(false);
        this.doParseLazily(true);
        this.setShortestReportedTextSegment(64);
        this.setInputBufferLength(512);
        this.setTextBufferLength(512);
    }

    public void configureForRoundTripping() {
        this.doCoalesceText(false);
        this.doReplaceEntityRefs(false);
        this.doReportAllTextAsCharacters(false);
        this.doReportPrologWhitespace(true);
        this.doNormalizeLFs(false);
        this.doNormalizeAttrValues(false);
        this.setShortestReportedTextSegment(Integer.MAX_VALUE);
    }

    private void setConfigFlag(int flag, boolean state) {
        this.mConfigFlags = state ? (this.mConfigFlags |= flag) : (this.mConfigFlags &= ~flag);
    }

    public int getPropertyId(String id) {
        Integer I = (Integer)sProperties.get(id);
        if (I == null) {
            throw new IllegalArgumentException("Unrecognized property '" + id + "'");
        }
        return I;
    }

    public Object getProperty(int id) {
        switch (id) {
            case 1: {
                return this.willCoalesceText() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willReplaceEntityRefs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.willSupportExternalEntities() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.willValidateWithDTD() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.willSupportDTDs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getXMLReporter();
            }
            case 9: {
                return this.getXMLResolver();
            }
            case 40: {
                return this.willNormalizeLFs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: {
                return this.willNormalizeAttrValues() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.willInternNames() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 20: {
                return this.willInternNsURIs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return this.willReportAllTextAsCharacters() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                return this.willReportPrologWhitespace() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return this.willCacheDTDs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return this.willParseLazily() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 24: {
                return this.willPreserveLocation() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 25: {
                return this.willAutoCloseInput() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 50: {
                return new Integer(this.getInputBufferLength());
            }
            case 51: {
                return new Integer(this.getTextBufferLength());
            }
            case 52: {
                return new Integer(this.getShortestReportedTextSegment());
            }
            case 53: {
                return this.getCustomInternalEntities();
            }
            case 54: {
                return this.getDtdResolver();
            }
            case 55: {
                return this.getEntityResolver();
            }
            case 56: {
                return this.getUndeclaredEntityResolver();
            }
            case 57: {
                return this.getBaseURL();
            }
            case 58: {
                return this.getInputParsingMode();
            }
        }
        throw new Error("Internal error: no handler for property with internal id " + id + ".");
    }

    public boolean setProperty(String propName, int id, Object value) {
        switch (id) {
            case 1: {
                this.doCoalesceText(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 2: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 3: {
                this.doReplaceEntityRefs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 4: {
                this.doSupportExternalEntities(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 6: {
                this.doSupportDTDs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 5: {
                this.doValidateWithDTD(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 8: {
                this.setXMLReporter((XMLReporter)value);
                break;
            }
            case 9: {
                this.setXMLResolver((XMLResolver)value);
                break;
            }
            case 40: {
                this.doNormalizeLFs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 41: {
                this.doNormalizeAttrValues(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 21: {
                this.doInternNames(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 20: {
                this.doInternNsURIs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 23: {
                this.doReportPrologWhitespace(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 42: {
                this.doCacheDTDs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 43: {
                this.doParseLazily(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 24: {
                this.doPreserveLocation(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 25: {
                this.doAutoCloseInput(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 22: {
                this.doReportAllTextAsCharacters(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 50: {
                this.setInputBufferLength(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 51: {
                this.setTextBufferLength(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 52: {
                this.setShortestReportedTextSegment(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 53: {
                this.setCustomInternalEntities((Map)value);
                break;
            }
            case 54: {
                this.setDtdResolver((XMLResolver)value);
                break;
            }
            case 55: {
                this.setEntityResolver((XMLResolver)value);
                break;
            }
            case 56: {
                this.setUndeclaredEntityResolver((XMLResolver)value);
                break;
            }
            case 57: {
                this.setBaseURL((URL)value);
                break;
            }
            case 58: {
                this.setInputParsingMode((WstxInputProperties.ParsingMode)value);
                break;
            }
            default: {
                throw new Error("Internal error: no handler for property with internal id " + id + ".");
            }
        }
        return true;
    }

    static {
        sProperties.put("javax.xml.stream.isCoalescing", new Integer(1));
        sProperties.put("javax.xml.stream.isNamespaceAware", new Integer(2));
        sProperties.put("javax.xml.stream.isReplacingEntityReferences", new Integer(3));
        sProperties.put("javax.xml.stream.isSupportingExternalEntities", new Integer(4));
        sProperties.put("javax.xml.stream.isValidating", new Integer(5));
        sProperties.put("javax.xml.stream.supportDTD", new Integer(6));
        sProperties.put("javax.xml.stream.allocator", new Integer(7));
        sProperties.put("javax.xml.stream.reporter", new Integer(8));
        sProperties.put("javax.xml.stream.resolver", new Integer(9));
        sProperties.put("org.codehaus.stax2.internNames", new Integer(21));
        sProperties.put("org.codehaus.stax2.internNsUris", new Integer(20));
        sProperties.put("org.codehaus.stax2.reportAllTextAsCharacters", new Integer(22));
        sProperties.put("org.codehaus.stax2.reportPrologWhitespace", new Integer(23));
        sProperties.put("org.codehaus.stax2.preserveLocation", new Integer(24));
        sProperties.put("org.codehaus.stax2.closeInputSource", new Integer(25));
        sProperties.put("com.ctc.wstx.normalizeLFs", new Integer(40));
        sProperties.put("com.ctc.wstx.normalizeAttrValues", new Integer(41));
        sProperties.put("com.ctc.wstx.cacheDTDs", new Integer(42));
        sProperties.put("com.ctc.wstx.lazyParsing", new Integer(43));
        sProperties.put("com.ctc.wstx.supportDTDPP", new Integer(44));
        sProperties.put("com.ctc.wstx.inputBufferLength", new Integer(50));
        sProperties.put("com.ctc.wstx.textBufferLength", new Integer(51));
        sProperties.put("com.ctc.wstx.minTextSegment", new Integer(52));
        sProperties.put("com.ctc.wstx.customInternalEntities", new Integer(53));
        sProperties.put("com.ctc.wstx.dtdResolver", new Integer(54));
        sProperties.put("com.ctc.wstx.entityResolver", new Integer(55));
        sProperties.put("com.ctc.wstx.undeclaredEntityResolver", new Integer(56));
        sProperties.put("com.ctc.wstx.baseURL", new Integer(57));
        sProperties.put("com.ctc.wstx.fragmentMode", new Integer(58));
    }
}

