/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.TextBuilder;

public final class DTDNmTokensAttr
extends DTDAttribute {
    public DTDNmTokensAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDNmTokensAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 9;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int origStart = start = tb.getOffset(index);
        int last = tb.getOffset(index + 1) - 1;
        while (start <= last && WstxInputData.isSpaceChar(ch[start])) {
            ++start;
        }
        if (start > last) {
            this.reportParseError(v, "Empty NMTOKENS value");
        }
        if (!normalize) {
            while (start <= last) {
                char c = ch[start];
                if (!WstxInputData.isSpaceChar(c) && !WstxInputData.is11NameChar(c)) {
                    this.reportInvalidChar(v, c, "not valid as NMTOKENS character");
                }
                ++start;
            }
            return;
        }
        boolean trimmed = origStart != start;
        origStart = start;
        while (last > start && WstxInputData.isSpaceChar(ch[last])) {
            --last;
            trimmed = true;
        }
        StringBuffer sb = null;
        while (start <= last) {
            char c;
            int i;
            for (i = start; i <= last && !WstxInputData.isSpaceChar(c = ch[i]); ++i) {
                if (WstxInputData.is11NameChar(c)) continue;
                this.reportInvalidChar(v, c, "not valid as an NMTOKENS character");
            }
            if (sb == null) {
                sb = new StringBuffer(last - start + 1);
            } else {
                sb.append(' ');
            }
            sb.append(ch, start, i - start);
            for (start = i + 1; start <= last && WstxInputData.isSpaceChar(ch[start]); ++start) {
            }
        }
        ac.setNormalizedValue(index, sb.toString());
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        String defValue = this.mDefValue;
        int len = defValue.length();
        StringBuffer sb = null;
        int count = 0;
        int start = 0;
        block0: while (start < len) {
            char c = defValue.charAt(start);
            while (WstxInputData.isSpaceChar(c)) {
                if (++start >= len) break block0;
                c = defValue.charAt(start);
            }
            int i = start + 1;
            do {
                if (WstxInputData.is11NameChar(c)) continue;
                this.reportParseError(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + WstxInputData.getCharDesc(c) + ") not a valid NMTOKENS character");
            } while (++i < len && !WstxInputData.isSpaceChar(c = defValue.charAt(i)));
            ++count;
            if (normalize) {
                if (sb == null) {
                    sb = new StringBuffer(i - start + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(defValue.substring(start, i));
            }
            start = i + 1;
        }
        if (count == 0) {
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKENS value");
        }
        if (normalize) {
            this.mDefValue = sb.toString();
        }
    }
}

