/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.io.IOException;
import java.io.Writer;

public class LineSuppressWriter
extends Writer {
    static final char CHAR_LAST_WS = ' ';
    protected final Writer mWriter;
    protected int mMaxEmptyLines = 0;
    protected boolean mTrimLeading = false;
    protected boolean mTrimTrailing = false;
    protected int mCurrEmptyLines = 0;
    protected char[] mCurrLine = new char[160];
    protected int mCurrPtr = 0;
    protected boolean mCurrIsEmpty = true;
    protected char[] mSingleCharBuf = null;

    public LineSuppressWriter(Writer sink) {
        this.mWriter = sink;
        this.mCurrIsEmpty = true;
    }

    public void setMaxConsequtiveEmptyLines(int max) {
        this.mMaxEmptyLines = max;
    }

    public void setTrim(boolean lead, boolean trail) {
        this.mTrimLeading = lead;
        this.mTrimTrailing = trail;
    }

    public void setTrimLeading(boolean state) {
        this.mTrimLeading = state;
    }

    public void setTrimTrailing(boolean state) {
        this.mTrimTrailing = state;
    }

    public void close() throws IOException {
        if (this.mCurrPtr > 0) {
            this.flushLine();
        }
        this.mWriter.close();
    }

    public void flush() throws IOException {
        this.mWriter.flush();
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(int c) throws IOException {
        if (this.mSingleCharBuf == null) {
            this.mSingleCharBuf = new char[1];
        }
        this.mSingleCharBuf[0] = (char)c;
        this.write(this.mSingleCharBuf, 0, 1);
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        int i = off;
        if (this.mCurrPtr > 0 && this.mCurrLine[this.mCurrPtr - 1] == '\r') {
            if (str.charAt(i) == '\n') {
                this.appendChar('\n');
                ++i;
            }
            this.flushLine();
        }
        int last = off + len;
        block0: while (i < last) {
            char c;
            if (this.mCurrIsEmpty) {
                while (i < last) {
                    c = str.charAt(i++);
                    if (this.mCurrPtr >= this.mCurrLine.length) {
                        this.resize();
                    }
                    this.mCurrLine[this.mCurrPtr++] = c;
                    if (c > ' ') {
                        this.mCurrIsEmpty = false;
                        break;
                    }
                    if (c != '\n') {
                        if (c != '\r') continue;
                        if (i >= last) {
                            return;
                        }
                        if (str.charAt(i) == '\n') {
                            ++i;
                            this.appendChar('\n');
                        }
                    }
                    this.flushLine();
                    continue block0;
                }
            }
            while (i < last) {
                c = str.charAt(i++);
                if (this.mCurrPtr >= this.mCurrLine.length) {
                    this.resize();
                }
                this.mCurrLine[this.mCurrPtr++] = c;
                if (c != '\n') {
                    if (c != '\r') continue;
                    if (i >= last) {
                        return;
                    }
                    if (str.charAt(i) == '\n') {
                        ++i;
                        this.appendChar('\n');
                    }
                }
                this.flushLine();
                continue block0;
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        if (this.mCurrPtr > 0 && this.mCurrLine[this.mCurrPtr - 1] == '\r') {
            if (cbuf[i] == '\n') {
                this.appendChar('\n');
                ++i;
            }
            this.flushLine();
        }
        int last = off + len;
        block0: while (i < last) {
            char c;
            if (this.mCurrIsEmpty) {
                while (i < last) {
                    c = cbuf[i++];
                    if (this.mCurrPtr >= this.mCurrLine.length) {
                        this.resize();
                    }
                    this.mCurrLine[this.mCurrPtr++] = c;
                    if (c > ' ') {
                        this.mCurrIsEmpty = false;
                        break;
                    }
                    if (c != '\n') {
                        if (c != '\r') continue;
                        if (i >= last) {
                            return;
                        }
                        if (cbuf[i] == '\n') {
                            ++i;
                            this.appendChar('\n');
                        }
                    }
                    this.flushLine();
                    continue block0;
                }
            }
            while (i < last) {
                c = cbuf[i++];
                if (this.mCurrPtr >= this.mCurrLine.length) {
                    this.resize();
                }
                this.mCurrLine[this.mCurrPtr++] = c;
                if (c != '\n') {
                    if (c != '\r') continue;
                    if (i >= last) {
                        return;
                    }
                    if (cbuf[i] == '\n') {
                        ++i;
                        this.appendChar('\n');
                    }
                }
                this.flushLine();
                continue block0;
            }
        }
    }

    private void resize() {
        this.mCurrLine = this.resize(this.mCurrLine);
    }

    private char[] resize(char[] old) {
        int oldLen = old.length;
        char[] newBuf = new char[oldLen + oldLen];
        System.arraycopy(old, 0, newBuf, 0, oldLen);
        return newBuf;
    }

    private void appendChar(char c) {
        if (this.mCurrPtr >= this.mCurrLine.length) {
            this.resize();
        }
        this.mCurrLine[this.mCurrPtr] = c;
        ++this.mCurrPtr;
    }

    private void flushLine() throws IOException {
        block14: {
            block13: {
                block12: {
                    if (!this.mCurrIsEmpty) break block12;
                    if (++this.mCurrEmptyLines <= this.mMaxEmptyLines) break block13;
                    break block14;
                }
                this.mCurrEmptyLines = 0;
            }
            if (!this.mTrimLeading && !this.mTrimTrailing) {
                this.mWriter.write(this.mCurrLine, 0, this.mCurrPtr);
            } else {
                int start;
                int end;
                int lfStart = this.mCurrPtr;
                if (lfStart > 0) {
                    char c = this.mCurrLine[lfStart - 1];
                    if (c == '\r') {
                        --lfStart;
                    } else if (c == '\n' && --lfStart > 0 && this.mCurrLine[lfStart - 1] == '\r') {
                        --lfStart;
                    }
                }
                if (this.mTrimTrailing) {
                    for (end = lfStart; end > 0 && this.mCurrLine[end - 1] <= ' '; --end) {
                    }
                }
                if (this.mTrimLeading) {
                    for (start = 0; start < end && this.mCurrLine[start] <= ' '; ++start) {
                    }
                }
                if (end == lfStart) {
                    this.mWriter.write(this.mCurrLine, start, this.mCurrPtr - start);
                } else {
                    this.mWriter.write(this.mCurrLine, start, end - start);
                    this.mWriter.write(this.mCurrLine, lfStart, this.mCurrPtr - lfStart);
                }
            }
        }
        this.mCurrPtr = 0;
        this.mCurrIsEmpty = true;
    }
}

