/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.exc.WstxEOFException;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.AsciiReader;
import com.ctc.wstx.io.ISOLatinReader;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.MergedStream;
import com.ctc.wstx.io.UTF8Reader;
import com.ctc.wstx.io.WstxInputLocation;
import com.ctc.wstx.util.StringUtil;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class StreamBootstrapper
extends InputBootstrapper {
    static final int MIN_BUF_SIZE = 128;
    final InputStream mIn;
    final byte[] mByteBuffer;
    private int mInputPtr;
    private int mInputLen;
    boolean mBigEndian = true;
    boolean mHadBOM = false;
    boolean mByteSizeFound = false;
    int mBytesPerChar;
    String mInputEncoding = null;

    private StreamBootstrapper(InputStream in, String pubId, String sysId, int bufSize) {
        super(pubId, sysId);
        this.mIn = in;
        if (bufSize < 128) {
            bufSize = 128;
        }
        this.mByteBuffer = new byte[bufSize];
        this.mInputLen = 0;
        this.mInputPtr = 0;
    }

    public static StreamBootstrapper getInstance(InputStream in, String pubId, String sysId, int bufSize) {
        return new StreamBootstrapper(in, pubId, sysId, bufSize);
    }

    public Reader bootstrapInput(boolean mainDoc, XMLReporter rep) throws IOException, XMLStreamException {
        this.resolveStreamEncoding();
        if (this.hasXmlDecl()) {
            this.readXmlDecl(mainDoc);
            if (this.mFoundEncoding != null) {
                this.mFoundEncoding = this.verifyXmlEncoding(this.mFoundEncoding);
            }
        }
        this.mInputEncoding = this.mFoundEncoding;
        if (this.mInputEncoding == null) {
            this.mInputEncoding = this.mBytesPerChar == 2 ? (this.mBigEndian ? "UTF-16BE" : "UTF-16LE") : (this.mBytesPerChar == 4 ? (this.mBigEndian ? "UTF-32BE" : "UTF-32LE") : "UTF-8");
        }
        Reader r = null;
        int c = this.mInputEncoding.length() > 0 ? (int)this.mInputEncoding.charAt(0) : 32;
        switch (c) {
            case 85: 
            case 117: {
                if (StringUtil.equalEncodings(this.mInputEncoding, "UTF-8")) {
                    r = new UTF8Reader(this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputLen);
                    this.mInputEncoding = "UTF-8";
                    break;
                }
                if (StringUtil.equalEncodings(this.mInputEncoding, "US-ASCII")) {
                    r = new AsciiReader(this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputLen);
                    this.mInputEncoding = "US-ASCII";
                    break;
                }
                if (StringUtil.equalEncodings(this.mInputEncoding, "UTF-16BE")) {
                    this.mInputEncoding = "UTF-16BE";
                    break;
                }
                if (StringUtil.equalEncodings(this.mInputEncoding, "UTF-16LE")) {
                    this.mInputEncoding = "UTF-16LE";
                    break;
                }
                if (!StringUtil.equalEncodings(this.mInputEncoding, "UTF")) break;
                this.mInputEncoding = "UTF";
                break;
            }
            case 73: 
            case 105: {
                if (!StringUtil.equalEncodings(this.mInputEncoding, "ISO-8859-1")) break;
                r = new ISOLatinReader(this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputLen);
                this.mInputEncoding = "ISO-8859-1";
                break;
            }
            case 74: 
            case 106: {
                if (!StringUtil.equalEncodings(this.mInputEncoding, "JIS_Encoding")) break;
                this.mInputEncoding = "Shift_JIS";
                break;
            }
            case 83: 
            case 115: {
                if (!StringUtil.equalEncodings(this.mInputEncoding, "Shift_JIS")) break;
                this.mInputEncoding = "Shift_JIS";
            }
        }
        if (r == null) {
            InputStream in = this.mIn;
            if (this.mInputPtr < this.mInputLen) {
                in = new MergedStream(in, this.mByteBuffer, this.mInputPtr, this.mInputLen);
            }
            if (StringUtil.equalEncodings(this.mInputEncoding, "UTF-16")) {
                this.mInputEncoding = this.mBigEndian ? "UTF-16BE" : "UTF-16LE";
            }
            r = new InputStreamReader(in, this.mInputEncoding);
        }
        return r;
    }

    public String getInputEncoding() {
        return this.mInputEncoding;
    }

    public int getInputTotal() {
        int total = this.mInputProcessed + this.mInputPtr;
        return this.mBytesPerChar > 1 ? total / this.mBytesPerChar : total;
    }

    public int getInputColumn() {
        int col = this.mInputPtr - this.mInputRowStart;
        return this.mBytesPerChar > 1 ? col / this.mBytesPerChar : col;
    }

    protected void resolveStreamEncoding() throws IOException, WstxException {
        this.mBytesPerChar = 0;
        this.mBigEndian = true;
        if (this.ensureLoaded(4)) {
            int quartet = this.mByteBuffer[0] << 24 | (this.mByteBuffer[1] & 0xFF) << 16 | (this.mByteBuffer[2] & 0xFF) << 8 | this.mByteBuffer[3] & 0xFF;
            block0 : switch (quartet) {
                case 65279: {
                    this.mBigEndian = true;
                    this.mBytesPerChar = 4;
                    this.mInputPtr = 4;
                    break;
                }
                case -131072: {
                    this.mBytesPerChar = 4;
                    this.mInputPtr = 4;
                    this.mBigEndian = false;
                    break;
                }
                case 65534: {
                    this.reportWeirdUCS4("2143");
                    break;
                }
                case -16842752: {
                    this.reportWeirdUCS4("3412");
                    break;
                }
                default: {
                    int msw = quartet >>> 16;
                    if (msw == 65279) {
                        this.mBytesPerChar = 2;
                        this.mInputPtr = 2;
                        this.mBigEndian = true;
                        break;
                    }
                    if (msw == 65534) {
                        this.mBytesPerChar = 2;
                        this.mInputPtr = 2;
                        this.mBigEndian = false;
                        break;
                    }
                    if (quartet >>> 8 == 0xEFBBBF) {
                        this.mInputPtr = 3;
                        this.mBytesPerChar = 1;
                        this.mBigEndian = true;
                        break;
                    }
                    switch (quartet) {
                        case 60: {
                            this.mBigEndian = true;
                            this.mBytesPerChar = 4;
                            break block0;
                        }
                        case 0x3C000000: {
                            this.mBytesPerChar = 4;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 15360: {
                            this.reportWeirdUCS4("2143");
                            break block0;
                        }
                        case 0x3C0000: {
                            this.reportWeirdUCS4("3412");
                            break block0;
                        }
                        case 3932223: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1006649088: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 1010792557: {
                            this.mBytesPerChar = 1;
                            this.mBigEndian = true;
                            break block0;
                        }
                    }
                }
            }
            this.mHadBOM = this.mInputPtr > 0;
            this.mInputProcessed = -this.mInputPtr;
            this.mInputRowStart = this.mInputPtr;
        }
        boolean bl = this.mByteSizeFound = this.mBytesPerChar > 0;
        if (!this.mByteSizeFound) {
            this.mBytesPerChar = 1;
            this.mBigEndian = true;
        }
    }

    protected String verifyXmlEncoding(String enc) throws WstxException {
        if (enc.startsWith("UTF")) {
            String s;
            String string = s = enc.charAt(3) == '-' ? enc.substring(4) : enc.substring(3);
            if (s.equals("8")) {
                this.verifyEncoding(enc, 1);
                enc = "UTF-8";
            } else if (s.startsWith("16")) {
                if (s.length() == 2) {
                    this.verifyEncoding(enc, 2);
                    enc = "UTF-16";
                } else if (s.equals("16BE")) {
                    this.verifyEncoding(enc, 2, true);
                    enc = "UTF-16BE";
                } else if (s.equals("16LE")) {
                    this.verifyEncoding(enc, 2, false);
                    enc = "UTF-16LE";
                }
            }
        } else if (enc.startsWith("ISO")) {
            String s;
            String string = s = enc.charAt(3) == '-' ? enc.substring(4) : enc.substring(3);
            if (s.startsWith("8859")) {
                this.verifyEncoding(enc, 1);
            } else if (s.startsWith("10646")) {
                if (s.equals("10646-UCS-2")) {
                    if (!this.mHadBOM) {
                        this.reportMissingBOM(enc);
                    }
                    this.verifyEncoding(enc, 2);
                    enc = "UTF-16";
                } else if (s.equals("10646-UCS-4")) {
                    if (!this.mHadBOM) {
                        this.reportMissingBOM(enc);
                    }
                    this.verifyEncoding(enc, 4);
                    enc = "UTF-32";
                }
            } else if (s.equals("646-US")) {
                enc = "US-ASCII";
                this.verifyEncoding(enc, 1);
            }
        } else if (enc.endsWith("ASCII")) {
            enc = "US-ASCII";
            this.verifyEncoding(enc, 1);
        }
        return enc;
    }

    protected boolean ensureLoaded(int minimum) throws IOException {
        int count;
        for (int gotten = this.mInputLen - this.mInputPtr; gotten < minimum; gotten += count) {
            count = this.mIn.read(this.mByteBuffer, this.mInputLen, this.mByteBuffer.length - this.mInputLen);
            if (count < 1) {
                return false;
            }
            this.mInputLen += count;
        }
        return true;
    }

    protected void loadMore() throws IOException, WstxException {
        this.mInputProcessed += this.mInputLen;
        this.mInputRowStart -= this.mInputLen;
        this.mInputPtr = 0;
        this.mInputLen = this.mIn.read(this.mByteBuffer, 0, this.mByteBuffer.length);
        if (this.mInputLen < 1) {
            throw new WstxEOFException(" in xml declaration", this.getLocation());
        }
    }

    protected void pushback() {
        this.mInputPtr -= this.mBytesPerChar;
    }

    protected int getNext() throws IOException, WstxException {
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        return b & 0xFF;
    }

    protected int getNextAfterWs(boolean reqWs) throws IOException, WstxException {
        int count = this.mBytesPerChar > 1 ? this.skipMbWs() : this.skipSbWs();
        if (reqWs && count == 0) {
            this.reportUnexpectedChar(this.getNext(), "; expected a white space");
        }
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        return b & 0xFF;
    }

    protected int checkKeyword(String exp) throws IOException, WstxException {
        if (this.mBytesPerChar > 1) {
            return this.checkMbKeyword(exp);
        }
        return this.checkSbKeyword(exp);
    }

    protected int readQuotedValue(char[] kw, int quoteChar) throws IOException, WstxException {
        boolean mb;
        int i = 0;
        int len = kw.length;
        boolean bl = mb = this.mBytesPerChar > 1;
        while (i < len) {
            int c;
            if (mb) {
                c = this.nextMultiByte();
                if (c == 13 || c == 10) {
                    this.skipMbLF(c);
                    c = 10;
                }
            } else {
                int b;
                int n = b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
                if (b == 0) {
                    this.reportNull();
                }
                if (b == 13 || b == 10) {
                    this.skipSbLF((byte)b);
                    b = 10;
                }
                c = b & 0xFF;
            }
            if (c == quoteChar) {
                return i < len ? i : -1;
            }
            if (i >= len) continue;
            kw[i++] = (char)c;
        }
        return -1;
    }

    protected boolean hasXmlDecl() throws IOException, WstxException {
        if (this.mBytesPerChar == 1) {
            if (this.ensureLoaded(6) && this.mByteBuffer[this.mInputPtr] == 60 && this.mByteBuffer[this.mInputPtr + 1] == 63 && this.mByteBuffer[this.mInputPtr + 2] == 120 && this.mByteBuffer[this.mInputPtr + 3] == 109 && this.mByteBuffer[this.mInputPtr + 4] == 108 && (this.mByteBuffer[this.mInputPtr + 5] & 0xFF) <= 32) {
                this.mInputPtr += 6;
                return true;
            }
        } else if (this.ensureLoaded(6 * this.mBytesPerChar)) {
            int start = this.mInputPtr;
            if (this.nextMultiByte() == 60 && this.nextMultiByte() == 63 && this.nextMultiByte() == 120 && this.nextMultiByte() == 109 && this.nextMultiByte() == 108 && this.nextMultiByte() <= 32) {
                return true;
            }
            this.mInputPtr = start;
        }
        return false;
    }

    protected Location getLocation() {
        int total = this.mInputProcessed + this.mInputPtr;
        int col = this.mInputPtr - this.mInputRowStart;
        if (this.mBytesPerChar > 1) {
            total /= this.mBytesPerChar;
            col /= this.mBytesPerChar;
        }
        return new WstxInputLocation(null, this.mPublicId, this.mSystemId, total - 1, this.mInputRow, col);
    }

    protected byte nextByte() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore();
        }
        return this.mByteBuffer[this.mInputPtr++];
    }

    protected int skipSbWs() throws IOException, WstxException {
        int count = 0;
        while (true) {
            byte b;
            byte by = b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if ((b & 0xFF) > 32) {
                --this.mInputPtr;
                break;
            }
            if (b == 13 || b == 10) {
                this.skipSbLF(b);
            } else if (b == 0) {
                this.reportNull();
            }
            ++count;
        }
        return count;
    }

    protected void skipSbLF(byte lfByte) throws IOException, WstxException {
        if (lfByte == 13) {
            byte b;
            byte by = b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if (b != 10) {
                --this.mInputPtr;
            }
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }

    protected int checkSbKeyword(String expected) throws IOException, WstxException {
        int len = expected.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            byte b;
            byte by = b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if (b == 0) {
                this.reportNull();
            }
            if ((b & 0xFF) == expected.charAt(ptr)) continue;
            return b & 0xFF;
        }
        return 0;
    }

    protected int nextMultiByte() throws IOException, WstxException {
        int c;
        byte b2;
        byte b = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        byte by = b2 = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        if (this.mBytesPerChar == 2) {
            c = this.mBigEndian ? (b & 0xFF) << 8 | b2 & 0xFF : b & 0xFF | (b2 & 0xFF) << 8;
        } else {
            byte b3 = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            byte b4 = this.mInputPtr < this.mInputLen ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            c = this.mBigEndian ? b << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF : b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b & 0xFF;
        }
        if (c == 0) {
            this.reportNull();
        }
        return c;
    }

    protected int skipMbWs() throws IOException, WstxException {
        int count = 0;
        while (true) {
            int c;
            if ((c = this.nextMultiByte()) > 32) {
                this.mInputPtr -= this.mBytesPerChar;
                break;
            }
            if (c == 13 || c == 10) {
                this.skipMbLF(c);
            } else if (c == 0) {
                this.reportNull();
            }
            ++count;
        }
        return count;
    }

    protected void skipMbLF(int lf) throws IOException, WstxException {
        int c;
        if (lf == 13 && (c = this.nextMultiByte()) != 10) {
            this.mInputPtr -= this.mBytesPerChar;
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }

    protected int checkMbKeyword(String expected) throws IOException, WstxException {
        int len = expected.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            int c = this.nextMultiByte();
            if (c == 0) {
                this.reportNull();
            }
            if (c == expected.charAt(ptr)) continue;
            return c;
        }
        return 0;
    }

    private void verifyEncoding(String id, int bpc) throws WstxException {
        if (this.mByteSizeFound && bpc != this.mBytesPerChar) {
            this.reportXmlProblem("Declared encoding '" + id + "' uses " + bpc + " bytes per character; but physical encoding appeared to use " + this.mBytesPerChar + "; cannot decode");
        }
    }

    private void verifyEncoding(String id, int bpc, boolean bigEndian) throws WstxException {
        if (this.mByteSizeFound) {
            this.verifyEncoding(id, bpc);
            if (bigEndian != this.mBigEndian) {
                String bigStr = bigEndian ? "big" : "little";
                this.reportXmlProblem("Declared encoding '" + id + "' has different endianness (" + bigStr + " endian) than what physical ordering appeared to be; cannot decode");
            }
        }
    }

    private void reportWeirdUCS4(String type) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + type + ") detected");
    }

    private void reportEBCDIC() throws IOException {
        throw new CharConversionException("Unsupported encoding (EBCDIC)");
    }

    private void reportMissingBOM(String enc) throws WstxException {
        throw new WstxException("Missing BOM for encoding '" + enc + "'; can not be omitted", this.getLocation());
    }
}

