/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDCdataAttr;
import com.ctc.wstx.dtd.DTDEntitiesAttr;
import com.ctc.wstx.dtd.DTDEntityAttr;
import com.ctc.wstx.dtd.DTDEnumAttr;
import com.ctc.wstx.dtd.DTDIdAttr;
import com.ctc.wstx.dtd.DTDIdRefAttr;
import com.ctc.wstx.dtd.DTDIdRefsAttr;
import com.ctc.wstx.dtd.DTDNmTokenAttr;
import com.ctc.wstx.dtd.DTDNmTokensAttr;
import com.ctc.wstx.dtd.DTDNotationAttr;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.StructValidator;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.ExceptionUtil;
import com.ctc.wstx.util.WordResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;

public final class DTDElement {
    final NameKey mName;
    final Location mLocation;
    StructValidator mValidator;
    int mAllowedContent;
    HashMap mAttrMap = null;
    ArrayList mSpecAttrList = null;
    boolean mAnyFixed = false;
    boolean mAnyDefaults = false;
    boolean mValidateAttrs = false;
    DTDAttribute mIdAttr;
    DTDAttribute mNotationAttr;

    private DTDElement(Location loc, NameKey name, StructValidator val, int allowedContent) {
        this.mName = name;
        this.mLocation = loc;
        this.mValidator = val;
        this.mAllowedContent = allowedContent;
    }

    public static DTDElement createDefined(Location loc, NameKey name, StructValidator val, int allowedContent) {
        if (allowedContent == 4) {
            ExceptionUtil.throwInternal("trying to use XMLValidator.CONTENT_ALLOW_UNDEFINED via createDefined()");
        }
        return new DTDElement(loc, name, val, allowedContent);
    }

    public static DTDElement createPlaceholder(Location loc, NameKey name) {
        return new DTDElement(loc, name, null, 4);
    }

    public DTDElement define(Location loc, StructValidator val, int allowedContent) {
        this.verifyUndefined();
        if (allowedContent == 4) {
            ExceptionUtil.throwInternal("trying to use CONTENT_ALLOW_UNDEFINED via define()");
        }
        DTDElement elem = new DTDElement(loc, this.mName, val, allowedContent);
        elem.mAttrMap = this.mAttrMap;
        elem.mSpecAttrList = this.mSpecAttrList;
        elem.mAnyFixed = this.mAnyFixed;
        elem.mValidateAttrs = this.mValidateAttrs;
        elem.mAnyDefaults = this.mAnyDefaults;
        elem.mIdAttr = this.mIdAttr;
        elem.mNotationAttr = this.mNotationAttr;
        return elem;
    }

    public void defineFrom(InputProblemReporter rep, DTDElement definedElem) throws WstxException {
        this.verifyUndefined();
        this.mValidator = definedElem.mValidator;
        this.mAllowedContent = definedElem.mAllowedContent;
        this.mergeMissingAttributesFrom(rep, definedElem);
    }

    private void verifyUndefined() {
        if (this.mAllowedContent != 4) {
            ExceptionUtil.throwInternal("redefining defined element spec");
        }
    }

    public DTDAttribute addAttribute(InputProblemReporter rep, NameKey attrName, int valueType, int defValueType, String defValue, WordResolver enumValues) throws WstxException {
        DTDAttribute attr;
        HashMap m = this.mAttrMap;
        if (m == null) {
            this.mAttrMap = m = new HashMap();
        }
        List specList = DTDAttribute.isSpecial(defValueType) ? this.getSpecialList() : null;
        int specIndex = specList == null ? -1 : specList.size();
        switch (valueType) {
            case 0: {
                attr = new DTDCdataAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 1: {
                attr = new DTDEnumAttr(attrName, defValueType, defValue, specIndex, enumValues);
                break;
            }
            case 2: {
                attr = new DTDIdAttr(attrName, defValueType, specIndex);
                break;
            }
            case 3: {
                attr = new DTDIdRefAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 4: {
                attr = new DTDIdRefsAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 5: {
                attr = new DTDEntityAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 6: {
                attr = new DTDEntitiesAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 7: {
                attr = new DTDNotationAttr(attrName, defValueType, defValue, specIndex, enumValues);
                break;
            }
            case 8: {
                attr = new DTDNmTokenAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            case 9: {
                attr = new DTDNmTokensAttr(attrName, defValueType, defValue, specIndex);
                break;
            }
            default: {
                ExceptionUtil.throwGenericInternal();
                attr = null;
            }
        }
        this.doAddAttribute(m, rep, attr, specList);
        return attr;
    }

    public void mergeMissingAttributesFrom(InputProblemReporter rep, DTDElement other) throws WstxException {
        HashMap otherMap = other.getAttributes();
        HashMap m = this.mAttrMap;
        if (m == null) {
            this.mAttrMap = m = new HashMap();
        }
        boolean anyAdded = false;
        if (otherMap != null && otherMap.size() > 0) {
            Iterator it = otherMap.entrySet().iterator();
            while (it.hasNext()) {
                List specList;
                Map.Entry me = it.next();
                Object key = me.getKey();
                if (m.containsKey(key)) continue;
                DTDAttribute newAttr = (DTDAttribute)me.getValue();
                if (newAttr.isSpecial()) {
                    specList = this.getSpecialList();
                    newAttr = newAttr.cloneWith(specList.size());
                } else {
                    specList = null;
                }
                this.doAddAttribute(m, rep, newAttr, specList);
            }
        }
    }

    private void doAddAttribute(Map attrMap, InputProblemReporter rep, DTDAttribute attr, List specList) throws WstxException {
        NameKey attrName = attr.getName();
        if (attrMap.containsKey(attrName)) {
            rep.reportProblem(ErrorConsts.WT_ATTR_DECL, ErrorConsts.W_DTD_DUP_ATTR, attrName, this.mName);
            return;
        }
        switch (attr.getValueType()) {
            case 2: {
                if (this.mIdAttr != null) {
                    rep.throwParseError("Invalid id attribute '" + attrName + "' for element <" + this.mName + ">: already had id attribute '" + this.mIdAttr.getName() + "'");
                }
                this.mIdAttr = attr;
                break;
            }
            case 7: {
                if (this.mNotationAttr != null) {
                    rep.throwParseError("Invalid notation attribute '" + attrName + "' for element <" + this.mName + ">: already had notation attribute '" + this.mNotationAttr.getName() + "'");
                }
                this.mNotationAttr = attr;
            }
        }
        attrMap.put(attrName, attr);
        if (specList != null) {
            specList.add(attr);
        }
        if (!this.mAnyFixed) {
            this.mAnyFixed = attr.isFixed();
        }
        if (!this.mValidateAttrs) {
            this.mValidateAttrs = attr.needsValidation();
        }
        if (!this.mAnyDefaults) {
            this.mAnyDefaults = attr.hasDefaultValue();
        }
    }

    public NameKey getName() {
        return this.mName;
    }

    public String toString() {
        return this.mName.toString();
    }

    public String getDisplayName() {
        return this.mName.toString();
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public boolean isDefined() {
        return this.mAllowedContent != 4;
    }

    public int getAllowedContent() {
        return this.mAllowedContent;
    }

    public HashMap getAttributes() {
        return this.mAttrMap;
    }

    public int getSpecialCount() {
        return this.mSpecAttrList == null ? 0 : this.mSpecAttrList.size();
    }

    public List getSpecialAttrs() {
        return this.mSpecAttrList;
    }

    public boolean attrsNeedValidation() {
        return this.mValidateAttrs;
    }

    public boolean hasFixedAttrs() {
        return this.mAnyFixed;
    }

    public boolean hasAttrDefaultValues() {
        return this.mAnyDefaults;
    }

    public DTDAttribute getIdAttribute() {
        return this.mIdAttr;
    }

    public DTDAttribute getNotationAttribute() {
        return this.mNotationAttr;
    }

    public StructValidator getValidator() {
        return this.mValidator == null ? null : this.mValidator.newInstance();
    }

    private List getSpecialList() {
        ArrayList l = this.mSpecAttrList;
        if (l == null) {
            this.mSpecAttrList = l = new ArrayList();
        }
        return l;
    }
}

