/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.api;

import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.util.ArgUtil;
import java.util.HashMap;
import javax.xml.stream.XMLReporter;
import org.codehaus.stax2.EscapingWriterFactory;

public final class WriterConfig
implements OutputConfigFlags {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "wstxns";
    static final int PROP_AUTOMATIC_NS = 1;
    static final int PROP_AUTOMATIC_EMPTY_ELEMS = 2;
    static final int PROP_ENABLE_NS = 3;
    static final int PROP_AUTOMATIC_NS_PREFIX = 4;
    static final int PROP_TEXT_ESCAPER = 5;
    static final int PROP_ATTR_VALUE_ESCAPER = 6;
    static final int PROP_PROBLEM_REPORTER = 7;
    static final int PROP_OUTPUT_CDATA_AS_TEXT = 11;
    static final int PROP_COPY_DEFAULT_ATTRS = 12;
    static final int PROP_VALIDATE_STRUCTURE = 15;
    static final int PROP_VALIDATE_CONTENT = 16;
    static final int PROP_VALIDATE_ATTR = 17;
    static final int PROP_VALIDATE_NAMES = 18;
    static final int PROP_FIX_CONTENT = 19;
    static final boolean DEFAULT_ENABLE_NS = true;
    static final boolean DEFAULT_AUTOMATIC_EMPTY_ELEMS = true;
    static final boolean DEFAULT_OUTPUT_CDATA_AS_TEXT = false;
    static final boolean DEFAULT_COPY_DEFAULT_ATTRS = false;
    static final boolean DEFAULT_VALIDATE_STRUCTURE = true;
    static final boolean DEFAULT_VALIDATE_CONTENT = false;
    static final boolean DEFAULT_VALIDATE_ATTR = false;
    static final boolean DEFAULT_VALIDATE_NAMES = false;
    static final boolean DEFAULT_FIX_CONTENT = true;
    static final int DEFAULT_FLAGS_J2ME = 549;
    static final int DEFAULT_FLAGS_FULL = 549;
    static final HashMap sProperties = new HashMap(8);
    final boolean mIsJ2MESubset;
    protected int mConfigFlags;
    protected String mAutoNsPrefix;
    protected EscapingWriterFactory mTextEscaperFactory = null;
    protected EscapingWriterFactory mAttrValueEscaperFactory = null;
    protected XMLReporter mProblemReporter = null;

    private WriterConfig(boolean j2meSubset, int flags, String autoNsPrefix, EscapingWriterFactory textEscaperF, EscapingWriterFactory attrValueEscaperF, XMLReporter problemReporter) {
        this.mIsJ2MESubset = j2meSubset;
        this.mConfigFlags = flags;
        this.mAutoNsPrefix = autoNsPrefix;
        this.mTextEscaperFactory = textEscaperF;
        this.mAttrValueEscaperFactory = attrValueEscaperF;
        this.mProblemReporter = problemReporter;
    }

    public static WriterConfig createJ2MEDefaults() {
        WriterConfig rc = new WriterConfig(true, 549, DEFAULT_AUTOMATIC_NS_PREFIX, null, null, null);
        return rc;
    }

    public static WriterConfig createFullDefaults() {
        WriterConfig rc = new WriterConfig(true, 549, DEFAULT_AUTOMATIC_NS_PREFIX, null, null, null);
        return rc;
    }

    public WriterConfig createNonShared() {
        WriterConfig rc = new WriterConfig(this.mIsJ2MESubset, this.mConfigFlags, this.mAutoNsPrefix, this.mTextEscaperFactory, this.mAttrValueEscaperFactory, this.mProblemReporter);
        return rc;
    }

    public boolean isPropertySupported(String name) {
        return sProperties.containsKey(name);
    }

    public Object getProperty(String name) {
        int id = this.getPropertyId(name);
        switch (id) {
            case 1: {
                return this.automaticNamespacesEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.automaticEmptyElementsEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.willOutputCDataAsText() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.willCopyDefaultAttrs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.willValidateStructure() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.willValidateContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.willValidateAttributes() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.willValidateNames() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return this.willFixContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getAutomaticNsPrefix();
            }
            case 5: {
                return this.getTextEscaperFactory();
            }
            case 6: {
                return this.getAttrValueEscaperFactory();
            }
            case 7: {
                return this.getProblemReporter();
            }
        }
        throw new Error("Internal error: no handler for property with internal id " + id + ".");
    }

    public boolean setProperty(String name, Object value) {
        int id = this.getPropertyId(name);
        switch (id) {
            case 1: {
                this.enableAutomaticNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 3: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 2: {
                this.enableAutomaticEmptyElements(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 11: {
                this.doOutputCDataAsText(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 12: {
                this.doCopyDefaultAttrs(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 15: {
                this.doValidateStructure(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 16: {
                this.doValidateContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 17: {
                this.doValidateAttributes(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 18: {
                this.doValidateNames(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 19: {
                this.doFixContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 4: {
                this.setAutomaticNsPrefix(value.toString());
                break;
            }
            case 5: {
                this.setTextEscaperFactory((EscapingWriterFactory)value);
                break;
            }
            case 6: {
                this.setAttrValueEscaperFactory((EscapingWriterFactory)value);
                break;
            }
            case 7: {
                this.setProblemReporter((XMLReporter)value);
                break;
            }
            default: {
                throw new Error("Internal error: no handler for property with internal id " + id + ".");
            }
        }
        return true;
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean automaticNamespacesEnabled() {
        return this.hasConfigFlag(2);
    }

    public boolean automaticEmptyElementsEnabled() {
        return this.hasConfigFlag(4);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlag(1);
    }

    public boolean willOutputCDataAsText() {
        return this.hasConfigFlag(8);
    }

    public boolean willCopyDefaultAttrs() {
        return this.hasConfigFlag(16);
    }

    public boolean willValidateStructure() {
        return this.hasConfigFlag(32);
    }

    public boolean willValidateContent() {
        return this.hasConfigFlag(64);
    }

    public boolean willValidateAttributes() {
        return this.hasConfigFlag(256);
    }

    public boolean willValidateNames() {
        return this.hasConfigFlag(128);
    }

    public boolean willFixContent() {
        return this.hasConfigFlag(512);
    }

    public String getAutomaticNsPrefix() {
        return this.mAutoNsPrefix;
    }

    public EscapingWriterFactory getTextEscaperFactory() {
        return this.mTextEscaperFactory;
    }

    public EscapingWriterFactory getAttrValueEscaperFactory() {
        return this.mAttrValueEscaperFactory;
    }

    public XMLReporter getProblemReporter() {
        return this.mProblemReporter;
    }

    public void enableAutomaticNamespaces(boolean state) {
        this.setConfigFlag(2, state);
    }

    public void enableAutomaticEmptyElements(boolean state) {
        this.setConfigFlag(4, state);
    }

    public void doSupportNamespaces(boolean state) {
        this.setConfigFlag(1, state);
    }

    public void doOutputCDataAsText(boolean state) {
        this.setConfigFlag(8, state);
    }

    public void doCopyDefaultAttrs(boolean state) {
        this.setConfigFlag(16, state);
    }

    public void doValidateStructure(boolean state) {
        this.setConfigFlag(32, state);
    }

    public void doValidateContent(boolean state) {
        this.setConfigFlag(64, state);
    }

    public void doValidateAttributes(boolean state) {
        this.setConfigFlag(256, state);
    }

    public void doValidateNames(boolean state) {
        this.setConfigFlag(128, state);
    }

    public void doFixContent(boolean state) {
        this.setConfigFlag(512, state);
    }

    public void setAutomaticNsPrefix(String prefix) {
        this.mAutoNsPrefix = prefix;
    }

    public void setTextEscaperFactory(EscapingWriterFactory f) {
        this.mTextEscaperFactory = f;
    }

    public void setAttrValueEscaperFactory(EscapingWriterFactory f) {
        this.mAttrValueEscaperFactory = f;
    }

    public void setProblemReporter(XMLReporter rep) {
        this.mProblemReporter = rep;
    }

    public void configureForXmlConformance() {
        this.doValidateAttributes(true);
        this.doValidateContent(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
    }

    public void configureForRobustness() {
        this.doValidateAttributes(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
        this.doValidateContent(true);
        this.doFixContent(true);
    }

    public void configureForSpeed() {
        this.doValidateAttributes(false);
        this.doValidateContent(false);
        this.doValidateNames(false);
    }

    private void setConfigFlag(int flag, boolean state) {
        this.mConfigFlags = state ? (this.mConfigFlags |= flag) : (this.mConfigFlags &= ~flag);
    }

    private boolean hasConfigFlag(int flag) {
        return (this.mConfigFlags & flag) == flag;
    }

    private int getPropertyId(String id) {
        Integer I = (Integer)sProperties.get(id);
        if (I == null) {
            throw new IllegalArgumentException("Property '" + id + "' not supported.");
        }
        return I;
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", new Integer(1));
        sProperties.put("org.codehaus.stax2.namespaceAware", new Integer(3));
        sProperties.put("org.codehaus.stax2.automaticEmptyElements", new Integer(2));
        sProperties.put("org.codehaus.stax2.automaticNsPrefix", new Integer(4));
        sProperties.put("org.codehaus.stax2.textEscaper", new Integer(5));
        sProperties.put("org.codehaus.stax2.attrValueEscaper", new Integer(6));
        sProperties.put("org.codehaus.stax2.reporter", new Integer(7));
        sProperties.put("com.ctc.wstx.outputCDataAsText", new Integer(11));
        sProperties.put("com.ctc.wstx.copyDefaultAttrs", new Integer(12));
        sProperties.put("com.ctc.wstx.outputValidateStructure", new Integer(15));
        sProperties.put("com.ctc.wstx.outputValidateContent", new Integer(16));
        sProperties.put("com.ctc.wstx.outputValidateAttr", new Integer(17));
        sProperties.put("com.ctc.wstx.outputValidateNames", new Integer(18));
        sProperties.put("com.ctc.wstx.outputFixContent", new Integer(19));
    }
}

