/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.exc.WstxValidationException;
import com.ctc.wstx.io.TextEscaper;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.StreamReaderImpl;
import com.ctc.wstx.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.EscapingWriterFactory;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationProblem;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.codehaus.stax2.validation.XMLValidatorPair;

public abstract class BaseStreamWriter
implements XMLStreamWriter2,
ValidationContext,
XMLStreamConstants,
OutputConfigFlags {
    protected static final int STATE_PROLOG = 1;
    protected static final int STATE_TREE = 2;
    protected static final int STATE_EPILOG = 3;
    protected static final char CHAR_SPACE = ' ';
    protected static final char DEFAULT_QUOTE_CHAR = '\"';
    protected static final String NO_NS_URI = "";
    protected static final String NO_PREFIX = null;
    protected final Writer mWriter;
    protected Writer mTextWriter;
    protected Writer mAttrValueWriter;
    protected final WriterConfig mConfig;
    protected final boolean mNsAware;
    protected final boolean mCfgAutomaticEmptyElems;
    protected final boolean mCfgCDataAsText;
    protected final boolean mCfgCopyDefaultAttrs;
    protected boolean mCheckStructure;
    protected boolean mCheckAttrs;
    protected final boolean mCheckContent;
    protected final boolean mCheckNames;
    protected final boolean mFixContent;
    protected String mEncoding;
    protected XMLValidator mValidator = null;
    protected boolean mXml11 = false;
    protected int mState = 1;
    protected boolean mAnyOutput = false;
    protected boolean mStartElementOpen = false;
    protected boolean mEmptyElement = false;
    protected int mVldContent = 3;
    protected String mDtdRootElem = null;
    protected XMLStreamReader2 mLastReader = null;
    protected StreamReaderImpl mLastReaderImpl = null;
    protected AttributeCollector mAttrCollector = null;
    protected InputElementStack mInputElemStack = null;

    protected BaseStreamWriter(Writer w, String enc, WriterConfig cfg) {
        this.mWriter = w;
        this.mEncoding = enc;
        this.mConfig = cfg;
        int flags = cfg.getConfigFlags();
        this.mNsAware = (flags & 1) != 0;
        this.mCheckStructure = (flags & 0x20) != 0;
        this.mCheckAttrs = (flags & 0x100) != 0;
        this.mCheckContent = (flags & 0x40) != 0;
        this.mCheckNames = (flags & 0x80) != 0;
        this.mFixContent = (flags & 0x200) != 0;
        this.mCfgAutomaticEmptyElems = (flags & 4) != 0;
        this.mCfgCDataAsText = (flags & 8) != 0;
        this.mCfgCopyDefaultAttrs = (flags & 0x10) != 0;
    }

    protected Writer constructAttributeValueWriter() throws UnsupportedEncodingException {
        String enc;
        EscapingWriterFactory f = this.mConfig.getAttrValueEscaperFactory();
        String string = enc = this.mEncoding == null || this.mEncoding.length() == 0 ? "UTF-8" : this.mEncoding;
        if (f == null) {
            return TextEscaper.constructAttrValueWriter(this.mWriter, enc, '\"');
        }
        return f.createEscapingWriterFor(this.mWriter, enc);
    }

    protected Writer constructTextWriter() throws UnsupportedEncodingException {
        String enc;
        EscapingWriterFactory f = this.mConfig.getTextEscaperFactory();
        String string = enc = this.mEncoding == null || this.mEncoding.length() == 0 ? "UTF-8" : this.mEncoding;
        if (f == null) {
            return TextEscaper.constructTextWriter(this.mWriter, enc);
        }
        return f.createEscapingWriterFor(this.mWriter, enc);
    }

    public void close() throws XMLStreamException {
        if (this.mState != 3) {
            this.writeEndDocument();
        }
        this.safeFlushStream();
    }

    public void flush() throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        this.safeFlushStream();
    }

    public abstract NamespaceContext getNamespaceContext();

    public abstract String getPrefix(String var1);

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void setNamespaceContext(NamespaceContext var1);

    public abstract void setPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeCData(String data) throws XMLStreamException {
        if (this.mCfgCDataAsText) {
            this.writeCharacters(data);
            return;
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        this.verifyWriteCData();
        if (this.mVldContent == 2 && this.mValidator != null) {
            this.mValidator.validateText(data, false);
        }
        try {
            int ix;
            if (this.mCheckContent && (ix = this.verifyCDataContent(data)) >= 0) {
                if (this.mFixContent) {
                    this.writeSegmentedCData(data, ix);
                    return;
                }
                BaseStreamWriter.throwCheckError(ErrorConsts.WERR_CDATA_CONTENT, new Integer(ix));
            }
            this.mWriter.write("<![CDATA[");
            if (data != null) {
                this.mWriter.write(data);
            }
            this.mWriter.write("]]>");
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog() && !StringUtil.isAllWhitespace(text, start, len)) {
            BaseStreamWriter.throwIllegalState(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(4);
            } else if (!StringUtil.isAllWhitespace(text, start, len)) {
                this.reportInvalidContent(4);
            }
        } else if (this.mVldContent == 2 && this.mValidator != null) {
            this.mValidator.validateText(text, start, len, false);
        }
        if (len > 0) {
            try {
                if (this.mTextWriter == null) {
                    this.mTextWriter = this.constructTextWriter();
                }
                this.mTextWriter.write(text, start, len);
            }
            catch (IOException ioe) {
                throw new WstxIOException(ioe);
            }
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog() && !StringUtil.isAllWhitespace(text)) {
            BaseStreamWriter.throwIllegalState(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(4);
            } else if (!StringUtil.isAllWhitespace(text)) {
                this.reportInvalidContent(4);
            }
        } else if (this.mVldContent == 2 && this.mValidator != null) {
            this.mValidator.validateText(text, false);
        }
        try {
            if (this.mTextWriter == null) {
                this.mTextWriter = this.constructTextWriter();
            }
            this.mTextWriter.write(text);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(5);
        }
        try {
            int ix;
            if (this.mCheckContent && (ix = this.verifyCommentContent(data)) >= 0) {
                if (this.mFixContent) {
                    this.writeSegmentedComment(data, ix);
                    return;
                }
                BaseStreamWriter.throwOutputError(ErrorConsts.WERR_COMMENT_CONTENT, new Integer(ix));
            }
            this.mWriter.write("<!--");
            this.mWriter.write(data);
            this.mWriter.write("-->");
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public void writeDTD(String dtd) throws XMLStreamException {
        this.verifyWriteDTD();
        this.mDtdRootElem = NO_NS_URI;
        try {
            this.mWriter.write(dtd);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public abstract void writeEmptyElement(String var1) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    public void writeEndDocument() throws XMLStreamException {
        if (this.mState != 3) {
            if (this.mCheckStructure && this.mState == 1) {
                BaseStreamWriter.throwIllegalState("Trying to write END_DOCUMENT when document has no root (ie. trying to output empty document).");
            }
            if (this.mStartElementOpen) {
                this.closeStartElement(this.mEmptyElement);
            }
            while (this.mState != 3) {
                this.writeEndElement();
            }
        }
    }

    public abstract void writeEndElement() throws XMLStreamException;

    public void writeEntityRef(String name) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            BaseStreamWriter.throwIllegalState("Trying to output an entity reference outside main element tree (in prolog or epilog)");
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(9);
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(name, this.mNsAware);
        }
        try {
            this.mWriter.write(38);
            this.mWriter.write(name);
            this.mWriter.write(59);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        int ix;
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(target, this.mNsAware);
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(3);
        }
        if (this.mCheckContent && data != null && data.length() > 1 && (ix = data.indexOf(63)) >= 0 && (ix = data.indexOf("?>", ix)) >= 0) {
            throw new XMLStreamException("Illegal input: processing instruction content has embedded '?>' in it (index " + ix + ")");
        }
        try {
            this.mWriter.write("<?");
            this.mWriter.write(target);
            if (data != null && data.length() > 0) {
                if (data.charAt(0) > ' ') {
                    this.mWriter.write(32);
                }
                this.mWriter.write(data);
            }
            this.mWriter.write("?>");
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        String enc = this.mEncoding == null ? "UTF-8" : this.mEncoding;
        this.writeStartDocument(enc, "1.0");
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(this.mEncoding, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.doWriteStartDocument(version, encoding, null);
    }

    protected void doWriteStartDocument(String version, String encoding, String standAlone) throws XMLStreamException {
        if (this.mCheckStructure && this.mAnyOutput) {
            BaseStreamWriter.throwIllegalState("Can not output XML declaration, after other output has already been done.");
        }
        this.mAnyOutput = true;
        if (this.mCheckContent && version != null && version.length() > 0 && !version.equals("1.0") && !version.equals("1.1")) {
            BaseStreamWriter.throwIllegalArg("Illegal version argument ('" + version + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (version == null || version.length() == 0) {
            version = "1.0";
        }
        this.mXml11 = "1.1".equals(version);
        if (encoding != null && encoding.length() > 0 && (this.mEncoding == null || this.mEncoding.length() == 0)) {
            this.mEncoding = encoding;
        }
        try {
            this.mWriter.write("<?xml version='");
            this.mWriter.write(version);
            this.mWriter.write(39);
            if (encoding != null && encoding.length() > 0) {
                this.mWriter.write(" encoding='");
                this.mWriter.write(encoding);
                this.mWriter.write(39);
            }
            if (standAlone != null) {
                this.mWriter.write(" standalone='");
                this.mWriter.write(standAlone);
                this.mWriter.write(39);
            }
            this.mWriter.write("?>");
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public abstract void writeStartElement(String var1) throws XMLStreamException;

    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value) {
        return this.mConfig.setProperty(name, value);
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        XMLValidator vld = schema.createValidator(this);
        if (this.mValidator == null) {
            this.mCheckStructure = true;
            this.mCheckAttrs = true;
            this.mValidator = vld;
        } else {
            this.mValidator = new XMLValidatorPair(this.mValidator, vld);
        }
        return vld;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        if (this.mValidator == null) {
            this.resetValidationFlags();
        }
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        if (this.mValidator == null) {
            this.resetValidationFlags();
        }
        return null;
    }

    private void resetValidationFlags() {
        int flags = this.mConfig.getConfigFlags();
        this.mCheckStructure = (flags & 0x20) != 0;
        this.mCheckAttrs = (flags & 0x100) != 0;
    }

    public Location getLocation() {
        return null;
    }

    public void writeCData(char[] c, int start, int len) throws XMLStreamException {
        if (this.mCfgCDataAsText) {
            this.writeCharacters(c, start, len);
            return;
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        this.verifyWriteCData();
        if (this.mVldContent == 2 && this.mValidator != null) {
            this.mValidator.validateText(c, start, len, false);
        }
        try {
            int ix;
            if (this.mCheckContent && c != null && (ix = this.verifyCDataContent(c, start, len)) >= 0) {
                if (this.mFixContent) {
                    this.writeSegmentedCData(c, start, len, ix);
                    return;
                }
                BaseStreamWriter.throwOutputError(ErrorConsts.WERR_CDATA_CONTENT, new Integer(ix));
            }
            this.mWriter.write("<![CDATA[");
            if (c != null) {
                this.mWriter.write(c, start, len);
            }
            this.mWriter.write("]]>");
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeDTD(DTDInfo info) throws XMLStreamException {
        this.writeDTD(info.getDTDRootName(), info.getDTDSystemId(), info.getDTDPublicId(), info.getDTDInternalSubset());
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws XMLStreamException {
        this.verifyWriteDTD();
        if (this.mCheckNames) {
            this.verifyNameValidity(rootName, false);
        }
        this.mDtdRootElem = rootName;
        try {
            this.mWriter.write("<!DOCTYPE ");
            this.mWriter.write(rootName);
            if (systemId != null) {
                if (publicId != null) {
                    this.mWriter.write(" PUBLIC \"");
                    this.mWriter.write(publicId);
                    this.mWriter.write("\" \"");
                } else {
                    this.mWriter.write(" SYSTEM \"");
                }
                this.mWriter.write(systemId);
                this.mWriter.write(34);
            }
            if (internalSubset != null && internalSubset.length() > 0) {
                this.mWriter.write(" [");
                this.mWriter.write(internalSubset);
                this.mWriter.write(93);
            }
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public abstract void writeFullEndElement() throws XMLStreamException;

    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this.doWriteStartDocument(version, encoding, standAlone ? "yes" : "no");
    }

    public void writeRaw(String text) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            this.mWriter.write(text);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            this.mWriter.write(text, offset, length);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void copyEventFromReader(XMLStreamReader2 sr, boolean preserveEventData) throws XMLStreamException {
        try {
            switch (sr.getEventType()) {
                case 7: {
                    String version = sr.getVersion();
                    if (version != null && version.length() != 0) {
                        if (sr.standaloneSet()) {
                            this.writeStartDocument(sr.getVersion(), sr.getCharacterEncodingScheme(), sr.isStandalone());
                        } else {
                            this.writeStartDocument(sr.getCharacterEncodingScheme(), sr.getVersion());
                        }
                    }
                    return;
                }
                case 8: {
                    this.writeEndDocument();
                    return;
                }
                case 1: {
                    if (sr != this.mLastReader) {
                        this.mLastReader = sr;
                        if (!(sr instanceof StreamReaderImpl)) {
                            throw new XMLStreamException("Can not yet copy START_ELEMENT events from non-Woodstox stream readers (class " + sr.getClass() + ")");
                        }
                        this.mLastReaderImpl = (StreamReaderImpl)sr;
                        this.mAttrCollector = this.mLastReaderImpl.getAttributeCollector();
                        this.mInputElemStack = this.mLastReaderImpl.getInputElementStack();
                    }
                    this.copyStartElement(this.mInputElemStack, this.mAttrCollector);
                    return;
                }
                case 2: {
                    this.writeEndElement();
                    return;
                }
                case 12: {
                    if (!this.mCfgCDataAsText) {
                        this.mAnyOutput = true;
                        if (this.mStartElementOpen) {
                            this.closeStartElement(this.mEmptyElement);
                        }
                        if (this.mCheckStructure && this.inPrologOrEpilog()) {
                            BaseStreamWriter.throwIllegalState(ErrorConsts.WERR_PROLOG_CDATA);
                        }
                        this.mWriter.write("<![CDATA[");
                        sr.getText(this.mWriter, preserveEventData);
                        this.mWriter.write("]]>");
                        return;
                    }
                }
                case 6: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    sr.getText(this.mWriter, preserveEventData);
                    return;
                }
                case 4: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    if (this.mTextWriter == null) {
                        this.mTextWriter = this.constructTextWriter();
                    }
                    sr.getText(this.mTextWriter, preserveEventData);
                    return;
                }
                case 5: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    this.mWriter.write("<!--");
                    sr.getText(this.mWriter, preserveEventData);
                    this.mWriter.write("-->");
                    return;
                }
                case 3: {
                    String target = sr.getPITarget();
                    String data = sr.getPIData();
                    if (data == null) {
                        this.writeProcessingInstruction(target);
                    } else {
                        this.writeProcessingInstruction(target, data);
                    }
                    return;
                }
                case 11: {
                    DTDInfo info = sr.getDTDInfo();
                    if (info == null) {
                        BaseStreamWriter.throwIllegalArg("Current state DOCTYPE, but not DTDInfo Object returned -- reader doesn't support DTDs?");
                    }
                    this.writeDTD(info);
                    return;
                }
                case 9: {
                    this.writeEntityRef(sr.getLocalName());
                    return;
                }
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
        throw new XMLStreamException("Unrecognized event type (" + sr.getEventType() + "); not sure how to copy");
    }

    public String getXmlVersion() {
        return this.mXml11 ? "1.1" : "1.0";
    }

    public abstract QName getCurrentElementName();

    public abstract String getNamespaceURI(String var1);

    public Location getValidationLocation() {
        return this.getLocation();
    }

    public void reportProblem(XMLValidationProblem prob) throws XMLValidationException {
        if (prob.getSeverity() >= 2) {
            throw WstxValidationException.create(prob);
        }
        XMLReporter rep = this.mConfig.getProblemReporter();
        if (rep != null) {
            this.doReportProblem(rep, ErrorConsts.WT_VALIDATION, prob.getMessage(), prob.getLocation());
        }
    }

    public int addDefaultAttribute(String localName, String uri, String prefix, String value) {
        return -1;
    }

    public Writer getWriter() {
        return this.mWriter;
    }

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    public abstract void writeEndElement(QName var1) throws XMLStreamException;

    public void writeCharacters(Characters ch) throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog() && !ch.isIgnorableWhiteSpace() && !ch.isWhiteSpace()) {
            BaseStreamWriter.throwIllegalState(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            if (this.mTextWriter == null) {
                this.mTextWriter = this.constructTextWriter();
            }
            this.mTextWriter.write(ch.getData());
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected abstract void closeStartElement(boolean var1) throws XMLStreamException;

    public boolean inPrologOrEpilog() {
        return this.mState != 2;
    }

    public abstract void copyStartElement(InputElementStack var1, AttributeCollector var2) throws IOException, XMLStreamException;

    public void flushStream() throws IOException {
        this.mWriter.flush();
    }

    public void safeFlushStream() throws XMLStreamException {
        try {
            this.flushStream();
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    public final void verifyNameValidity(String name, boolean nsAware) {
        if (name == null || name.length() == 0) {
            BaseStreamWriter.throwIllegalArg(ErrorConsts.WERR_NAME_EMPTY);
        }
        char c = name.charAt(0);
        if (this.mXml11) {
            if ((c != ':' || nsAware) && !WstxInputData.is11NameStartChar(c)) {
                BaseStreamWriter.throwIllegalArg(ErrorConsts.WERR_NAME_ILLEGAL_FIRST_CHAR, WstxInputData.getCharDesc(c));
            }
            int len = name.length();
            for (int i = 1; i < len; ++i) {
                c = name.charAt(i);
                if (c == ':' && !nsAware || WstxInputData.is11NameChar(c)) continue;
                BaseStreamWriter.throwIllegalArg(ErrorConsts.WERR_NAME_ILLEGAL_CHAR, WstxInputData.getCharDesc(c));
            }
        } else {
            if ((c != ':' || nsAware) && !WstxInputData.is10NameStartChar(c)) {
                BaseStreamWriter.throwIllegalArg(ErrorConsts.WERR_NAME_ILLEGAL_FIRST_CHAR, WstxInputData.getCharDesc(c));
            }
            int len = name.length();
            for (int i = 1; i < len; ++i) {
                c = name.charAt(i);
                if (c == ':' && !nsAware || WstxInputData.is10NameChar(c)) continue;
                BaseStreamWriter.throwIllegalArg(ErrorConsts.WERR_NAME_ILLEGAL_CHAR, WstxInputData.getCharDesc(c));
            }
        }
    }

    protected void verifyWriteCData() throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            BaseStreamWriter.throwIllegalState(ErrorConsts.WERR_PROLOG_CDATA);
        }
        if (this.mVldContent <= 1) {
            this.reportInvalidContent(12);
        }
    }

    protected void verifyWriteDTD() throws XMLStreamException {
        if (this.mCheckStructure) {
            if (this.mState != 1) {
                throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + this.mState + "; start element(s) written)");
            }
            if (this.mDtdRootElem != null) {
                throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
            }
        }
    }

    protected int verifyCDataContent(String content) {
        int ix;
        if (content != null && content.length() >= 3 && (ix = content.indexOf(93)) >= 0) {
            return content.indexOf("]]>", ix);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] c, int start, int end) {
        if (c != null) {
            start += 2;
            while (start < end) {
                char ch = c[start];
                if (ch == ']') {
                    ++start;
                    continue;
                }
                if (ch == '>' && c[start - 1] == ']' && c[start - 2] == ']') {
                    return start - 2;
                }
                start += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String content) {
        int ix = content.indexOf(45);
        if (ix >= 0 && ix < content.length() - 1) {
            ix = content.indexOf("--", ix);
        }
        return ix;
    }

    protected void verifyRootElement(String localName, String prefix) throws XMLValidationException {
        if (this.mDtdRootElem != null && this.mDtdRootElem.length() > 0) {
            String wrongElem = null;
            if (!localName.equals(this.mDtdRootElem)) {
                int lnLen = localName.length();
                int oldLen = this.mDtdRootElem.length();
                if (oldLen <= lnLen || !this.mDtdRootElem.endsWith(localName) || this.mDtdRootElem.charAt(oldLen - lnLen - 1) != ':') {
                    wrongElem = prefix == null ? localName : (prefix.length() == 0 ? "[unknown]:" + localName : prefix + ":" + localName);
                }
            }
            if (wrongElem != null) {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_WRONG_ROOT, wrongElem, this.mDtdRootElem);
            }
        }
        this.mState = 2;
    }

    protected void writeSegmentedCData(String content, int index) throws IOException {
        int start = 0;
        while (index >= 0) {
            this.mWriter.write("<![CDATA[");
            this.mWriter.write(content, start, index + 2 - start);
            this.mWriter.write("]]>");
            start = index + 2;
            index = content.indexOf("]]>", start);
        }
        this.mWriter.write("<![CDATA[");
        this.mWriter.write(content, start, content.length() - start);
        this.mWriter.write("]]>");
    }

    protected void writeSegmentedCData(char[] c, int start, int len, int index) throws IOException {
        int end = start + len;
        while (index >= 0) {
            this.mWriter.write("<![CDATA[");
            this.mWriter.write(c, start, index + 2 - start);
            this.mWriter.write("]]>");
            start = index + 2;
            index = this.verifyCDataContent(c, start, end);
        }
        this.mWriter.write("<![CDATA[");
        this.mWriter.write(c, start, end - start);
        this.mWriter.write("]]>");
    }

    protected void writeSegmentedComment(String content, int index) throws IOException {
        int len = content.length();
        if (index == len - 1) {
            this.mWriter.write("<!--");
            this.mWriter.write(content);
            this.mWriter.write(" -->");
            return;
        }
        int start = 0;
        while (index >= 0) {
            this.mWriter.write("<!--");
            this.mWriter.write(content, start, index + 1 - start);
            this.mWriter.write(32);
            start = index + 1;
            index = content.indexOf("--", start);
        }
        this.mWriter.write(content, start, len - start);
        if (content.charAt(len - 1) == '-') {
            this.mWriter.write(32);
        }
        this.mWriter.write("-->");
    }

    protected static void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    protected static void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        BaseStreamWriter.throwOutputError(msg);
    }

    protected static void throwCheckError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    protected static void throwCheckError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        BaseStreamWriter.throwCheckError(msg);
    }

    protected static void throwFromIOE(IOException ioe) throws XMLStreamException {
        throw new WstxIOException(ioe);
    }

    protected static void throwIllegalArg(String msg) throws IllegalArgumentException {
        throw new IllegalArgumentException(msg);
    }

    protected static void throwIllegalArg(String format, Object arg) throws IllegalArgumentException {
        String msg = MessageFormat.format(format, arg);
        BaseStreamWriter.throwIllegalArg(msg);
    }

    protected static void throwIllegalState(String msg) throws IllegalArgumentException {
        throw new IllegalStateException(msg);
    }

    protected void reportInvalidContent(int evtType) throws XMLStreamException {
        switch (this.mVldContent) {
            case 0: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_EMPTY, this.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            case 1: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_NON_MIXED, (Object)this.getTopElementDesc());
                break;
            }
            case 2: 
            case 3: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_ANY, this.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            default: {
                this.reportValidationProblem("Internal error: trying to report invalid content for " + evtType);
            }
        }
    }

    public void reportValidationProblem(String msg, Location loc, int severity) throws XMLValidationException {
        this.reportProblem(new XMLValidationProblem(loc, msg, severity));
    }

    public void reportValidationProblem(String msg, int severity) throws XMLValidationException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg, severity));
    }

    public void reportValidationProblem(String msg) throws XMLValidationException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg, 2));
    }

    public void reportValidationProblem(Location loc, String msg) throws XMLValidationException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg));
    }

    public void reportValidationProblem(String format, Object arg) throws XMLValidationException {
        String msg = MessageFormat.format(format, arg);
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg));
    }

    public void reportValidationProblem(String format, Object arg, Object arg2) throws XMLValidationException {
        String msg = MessageFormat.format(format, arg, arg2);
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), msg));
    }

    protected final void doReportProblem(XMLReporter rep, String probType, String msg, Location loc) {
        if (rep != null) {
            try {
                rep.report(msg, probType, null, loc);
            }
            catch (XMLStreamException e) {
                System.err.println("Problem reporting a problem: " + e);
            }
        }
    }

    protected abstract String getTopElementDesc();
}

