/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.evt.WstxEventWriter;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.NonNsStreamWriter;
import com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.ctc.wstx.sw.SimpleNsStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;

public final class WstxOutputFactory
extends XMLOutputFactory2
implements OutputConfigFlags {
    protected final WriterConfig mConfig = WriterConfig.createFullDefaults();

    public XMLEventWriter createXMLEventWriter(OutputStream out) throws XMLStreamException {
        return this.createXMLEventWriter(out, null);
    }

    public XMLEventWriter createXMLEventWriter(OutputStream out, String enc) throws XMLStreamException {
        if (out == null) {
            throw new IllegalArgumentException("Null OutputStream is not a valid argument");
        }
        return new WstxEventWriter(this.createSW(out, null, enc));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new WstxEventWriter(this.createSW(result));
    }

    public XMLEventWriter createXMLEventWriter(Writer w) throws XMLStreamException {
        if (w == null) {
            throw new IllegalArgumentException("Null Writer is not a valid argument");
        }
        return new WstxEventWriter(this.createSW(null, w, null));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return this.createXMLStreamWriter(out, null);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        if (out == null) {
            throw new IllegalArgumentException("Null OutputStream is not a valid argument");
        }
        return this.createSW(out, null, enc);
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) throws XMLStreamException {
        if (w == null) {
            throw new IllegalArgumentException("Null Writer is not a valid argument");
        }
        return this.createSW(null, w, null);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this.mConfig.setProperty(name, value);
    }

    public XMLEventWriter createXMLEventWriter(Writer w, String enc) throws XMLStreamException {
        return new WstxEventWriter(this.createSW(null, w, enc));
    }

    public XMLStreamWriter2 createXMLStreamWriter(Writer w, String enc) throws XMLStreamException {
        return this.createSW(null, w, enc);
    }

    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    public void configureForRobustness() {
        this.mConfig.configureForRobustness();
    }

    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    public WriterConfig getConfig() {
        return this.mConfig;
    }

    private BaseStreamWriter createSW(OutputStream out, Writer w, String enc) throws XMLStreamException {
        WriterConfig cfg;
        if (w == null) {
            try {
                w = enc == null ? new OutputStreamWriter(out, "UTF-8") : new OutputStreamWriter(out, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new XMLStreamException(ex);
            }
        }
        if ((cfg = this.mConfig.createNonShared()).willSupportNamespaces()) {
            if (cfg.automaticNamespacesEnabled()) {
                return new RepairingNsStreamWriter(w, enc, cfg);
            }
            return new SimpleNsStreamWriter(w, enc, cfg);
        }
        return new NonNsStreamWriter(w, enc, cfg);
    }

    private BaseStreamWriter createSW(Result res) throws XMLStreamException {
        if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            Writer w = sr.getWriter();
            if (w == null) {
                OutputStream out = sr.getOutputStream();
                if (out == null) {
                    throw new XMLStreamException("Can not create StAX writer for a StreamResult -- neither writer nor output stream was set.");
                }
                return this.createSW(out, null, null);
            }
            return this.createSW(null, w, null);
        }
        if (res instanceof SAXResult) {
            throw new XMLStreamException("Can not create a STaX writer for a SAXResult -- not (yet) implemented.");
        }
        if (res instanceof DOMResult) {
            throw new XMLStreamException("Can not create a STaX writer for a DOMResult -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + res.getClass() + " (unknown type)");
    }
}

