/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.evt.DefaultEventAllocator;
import com.ctc.wstx.evt.FilteredEventReader;
import com.ctc.wstx.evt.WstxEventReader;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.DefaultInputResolver;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.sr.ValidatingStreamReader;
import com.ctc.wstx.stax.FilteredStreamReader;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SimpleCache;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.xml.sax.InputSource;

public final class WstxInputFactory
extends XMLInputFactory2
implements ReaderCreator,
InputConfigFlags {
    protected final ReaderConfig mConfig;
    protected XMLEventAllocator mAllocator = null;
    protected SimpleCache mDTDCache = null;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;

    public WstxInputFactory() {
        this.mConfig = ReaderConfig.createFullDefaults();
    }

    public synchronized DTDSubset findCachedDTD(DTDId id) {
        return this.mDTDCache == null ? null : (DTDSubset)this.mDTDCache.find(id);
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = this.mSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
        if (this.mDTDCache == null) {
            this.mDTDCache = new SimpleCache(this.mConfig.getDtdCacheSize());
        }
        this.mDTDCache.add(id, extSubset);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) {
        return new FilteredEventReader(reader, filter);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, in, null, true, false));
    }

    public XMLEventReader createXMLEventReader(InputStream in, String enc) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, in, enc, true, false));
    }

    public XMLEventReader createXMLEventReader(Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(null, r, true, false));
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(source, true, true));
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(systemId, in, null, true, false));
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(systemId, r, true, false));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader sr) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), sr);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createSR(null, in, null, false, false);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        return this.createSR(null, in, enc, false, false);
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createSR(null, r, false, false);
    }

    public XMLStreamReader createXMLStreamReader(Source src) throws XMLStreamException {
        return this.createSR(src, false, true);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, in, null, false, false);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, r, false, false);
    }

    public Object getProperty(String name) {
        int id = this.mConfig.getPropertyId(name);
        if (id == 7) {
            return this.getEventAllocator();
        }
        return this.mConfig.getProperty(id);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.mAllocator;
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.mAllocator = allocator;
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public void setProperty(String propName, Object value) {
        if ("javax.xml.stream.allocator".equals(propName)) {
            this.setEventAllocator((XMLEventAllocator)value);
        } else {
            this.mConfig.setProperty(propName, value);
        }
    }

    public XMLEventReader2 createXMLEventReader(URL src) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(src, true, true));
    }

    public XMLEventReader2 createXMLEventReader(File f) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createSR(f, true, true));
    }

    public XMLStreamReader2 createXMLStreamReader(URL src) throws XMLStreamException {
        return this.createSR(src, false, true);
    }

    public XMLStreamReader2 createXMLStreamReader(File f) throws XMLStreamException {
        return this.createSR(f, false, true);
    }

    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    public void configureForConvenience() {
        this.mConfig.configureForConvenience();
    }

    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    public void configureForLowMemUsage() {
        this.mConfig.configureForLowMemUsage();
    }

    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    private ValidatingStreamReader createSR(String systemId, InputBootstrapper bs, URL src, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        Reader r;
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        if (!autoCloseInput) {
            autoCloseInput = cfg.willAutoCloseInput();
        }
        try {
            r = bs.bootstrapInput(true, this.getXMLReporter(), 0);
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource(bs, null, systemId, src, r, autoCloseInput, cfg.getInputBufferLength());
        try {
            ValidatingStreamReader sr = ValidatingStreamReader.createValidatingStreamReader(input, this, cfg, bs, forER);
            return sr;
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    private ValidatingStreamReader createSR(String systemId, InputBootstrapper bs, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        return this.createSR(systemId, bs, src, forER, autoCloseInput);
    }

    protected ValidatingStreamReader createSR(String systemId, InputStream in, String enc, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        if (in == null) {
            throw new IllegalArgumentException("Null InputStream is not a valid argument");
        }
        if (enc == null || enc.length() == 0) {
            return this.createSR(systemId, StreamBootstrapper.getInstance(in, null, systemId, this.mConfig.getInputBufferLength()), forER, autoCloseInput);
        }
        int inputBufLen = this.mConfig.getInputBufferLength();
        Reader r = DefaultInputResolver.constructOptimizedReader(in, false, enc, inputBufLen);
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, enc), forER, autoCloseInput);
    }

    protected ValidatingStreamReader createSR(URL src, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        try {
            return this.createSR(src, URLUtil.optimizedStreamFromURL(src), forER, autoCloseInput);
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    private ValidatingStreamReader createSR(URL src, InputStream in, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        String sysId = src.toExternalForm();
        return this.createSR(sysId, StreamBootstrapper.getInstance(in, null, sysId, this.mConfig.getInputBufferLength()), src, forER, autoCloseInput);
    }

    protected ValidatingStreamReader createSR(String systemId, Reader r, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, null), forER, autoCloseInput);
    }

    protected ValidatingStreamReader createSR(File f, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        try {
            return this.createSR(f.toURL(), new FileInputStream(f), forER, autoCloseInput);
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    protected ValidatingStreamReader createSR(Source src, boolean forER, boolean autoCloseInput) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            String sysId = ss.getSystemId();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    if (sysId == null) {
                        throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader, input stream nor system id was set.");
                    }
                    try {
                        return this.createSR(URLUtil.urlFromSystemId(sysId), forER, autoCloseInput);
                    }
                    catch (IOException ioe) {
                        throw new WstxIOException(ioe);
                    }
                }
                bs = StreamBootstrapper.getInstance(in, ss.getPublicId(), sysId, this.mConfig.getInputBufferLength());
            } else {
                bs = ReaderBootstrapper.getInstance(r, ss.getPublicId(), sysId, null);
            }
            return this.createSR(sysId, bs, forER, autoCloseInput);
        }
        if (src instanceof SAXSource) {
            SAXSource ss = (SAXSource)src;
            InputSource isrc = ss.getInputSource();
            if (isrc != null) {
                InputBootstrapper bs = null;
                Reader r = isrc.getCharacterStream();
                String sysId = isrc.getSystemId();
                if (r != null) {
                    bs = ReaderBootstrapper.getInstance(r, isrc.getPublicId(), sysId, null);
                } else {
                    InputStream in = isrc.getByteStream();
                    if (in != null) {
                        bs = StreamBootstrapper.getInstance(in, isrc.getPublicId(), sysId, this.mConfig.getInputBufferLength());
                    } else if (sysId != null) {
                        try {
                            return this.createSR(URLUtil.urlFromSystemId(sysId), forER, autoCloseInput);
                        }
                        catch (IOException ioe) {
                            throw new WstxIOException(ioe);
                        }
                    }
                }
                if (bs != null) {
                    return this.createSR(sysId, bs, forER, autoCloseInput);
                }
            }
            throw new XMLStreamException("Can only create STaX reader for a SAXSource if Reader or InputStream exposed via getSource(); can not use -- not implemented.");
        }
        if (src instanceof DOMSource) {
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this.mAllocator != null) {
            return this.mAllocator.newInstance();
        }
        return this.mConfig.willPreserveLocation() ? DefaultEventAllocator.getDefaultInstance() : DefaultEventAllocator.getFastInstance();
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

