/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseReader;
import java.io.IOException;
import java.io.InputStream;

public final class ISOLatinReader
extends BaseReader {
    boolean mXml11 = false;
    int mByteCount = 0;

    public ISOLatinReader(InputStream in, byte[] buf, int ptr, int len) {
        super(in, buf, ptr, len);
    }

    public void setXmlCompliancy(int xmlVersion) {
        this.mXml11 = xmlVersion == 272;
    }

    public int read(char[] cbuf, int start, int len) throws IOException {
        int avail;
        if (this.mBuffer == null) {
            return -1;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        if ((avail = this.mLength - this.mPtr) <= 0) {
            this.mByteCount += this.mLength;
            int count = this.mIn.read(this.mBuffer);
            if (count <= 0) {
                if (count == 0) {
                    this.reportStrangeStream();
                }
                this.mBuffer = null;
                return -1;
            }
            this.mLength = avail = count;
            this.mPtr = 0;
        }
        if (len > avail) {
            len = avail;
        }
        int i = this.mPtr;
        int last = i + len;
        if (this.mXml11) {
            while (i < last) {
                int c;
                if ((c = (int)(this.mBuffer[i++] & 0xFF)) >= 127 && c <= 159) {
                    if (c == 133) {
                        c = 10;
                    } else if (c >= 127) {
                        int pos = this.mByteCount + this.mPtr;
                        this.reportInvalidXml11(c, pos, pos);
                    }
                }
                cbuf[start++] = c;
            }
        } else {
            while (i < last) {
                cbuf[start++] = (char)(this.mBuffer[i++] & 0xFF);
            }
        }
        this.mPtr = last;
        return len;
    }
}

