/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

abstract class BaseReader
extends Reader {
    protected static final char NULL_CHAR = '\u0000';
    protected static final char NULL_BYTE = '\u0000';
    protected static final char CONVERT_NEL_TO = '\n';
    protected static final char CONVERT_LSEP_TO = '\n';
    static final char CHAR_DEL = '\u007f';
    protected InputStream mIn;
    protected byte[] mBuffer;
    protected int mPtr;
    protected int mLength;
    char[] mTmpBuf = null;

    protected BaseReader(InputStream in, byte[] buf, int ptr, int len) {
        this.mIn = in;
        this.mBuffer = buf;
        this.mPtr = ptr;
        this.mLength = len;
    }

    public abstract void setXmlCompliancy(int var1);

    public void close() throws IOException {
        InputStream in = this.mIn;
        if (in != null) {
            this.mIn = null;
            this.mBuffer = null;
            in.close();
        }
    }

    public int read() throws IOException {
        if (this.mTmpBuf == null) {
            this.mTmpBuf = new char[1];
        }
        if (this.read(this.mTmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this.mTmpBuf[0];
    }

    protected void reportBounds(char[] cbuf, int start, int len) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + start + "," + len + "), cbuf[" + cbuf.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }

    protected void reportInvalidXml11(int value, int bytePos, int charPos) throws IOException {
        throw new CharConversionException("Invalid character 0x" + Integer.toHexString(value) + ", can only be included in xml 1.1 using character entities (at char #" + charPos + ", byte #" + bytePos + ")");
    }
}

