/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import javax.xml.stream.Location;
import org.codehaus.stax2.validation.XMLValidationException;

public final class DTDIdAttr
extends DTDAttribute {
    public DTDIdAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 2;
    }

    public boolean typeIsId() {
        return true;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start, int end, boolean normalize) throws XMLValidationException {
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v, "Empty ID value");
        }
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
        }
        int c = cbuf[start];
        if (!WstxInputData.is11NameStartChar((char)c) && c != 58) {
            return this.reportInvalidChar(v, (char)c, "not valid as the first ID character");
        }
        int hash = c;
        for (int i = start + 1; i <= end; ++i) {
            c = cbuf[i];
            if (!WstxInputData.is11NameChar((char)c)) {
                return this.reportInvalidChar(v, (char)c, "not valid as an ID character");
            }
            hash = hash * 31 + c;
        }
        ElementIdMap m = v.getIdMap();
        NameKey elemName = v.getElemName();
        Location loc = v.getLocation();
        ElementId id = m.addDefined(cbuf, start, end - start + 1, hash, loc, elemName, this.mName);
        if (id.getLocation() != loc) {
            return this.reportValidationProblem(v, "Duplicate id '" + id.getId() + "', first declared at " + id.getLocation());
        }
        if (normalize) {
            return id.getId();
        }
        return null;
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        throw new Error(ErrorConsts.ERR_INTERNAL);
    }
}

