/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.WordResolver;
import org.codehaus.stax2.validation.XMLValidationException;

public final class DTDEnumAttr
extends DTDAttribute {
    final WordResolver mEnumValues;

    public DTDEnumAttr(NameKey name, int defValueType, String defValue, int specIndex, WordResolver enumValues) {
        super(name, defValueType, defValue, specIndex);
        this.mEnumValues = enumValues;
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDEnumAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex, this.mEnumValues);
    }

    public int getValueType() {
        return 1;
    }

    public String validate(DTDValidatorBase v, char[] cbuf, int start, int end, boolean normalize) throws XMLValidationException {
        String ok = this.validateEnumValue(cbuf, start, end, normalize, this.mEnumValues);
        if (ok == null) {
            String val = new String(cbuf, start, end - start);
            return this.reportValidationProblem(v, "Invalid enumerated value '" + val + "': has to be one of (" + this.mEnumValues + ")");
        }
        return ok;
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String def = this.validateDefaultNmToken(rep, normalize);
        String shared = this.mEnumValues.find(def);
        if (shared == null) {
            this.reportValidationProblem(rep, "Invalid default value '" + def + "': has to be one of (" + this.mEnumValues + ")");
            return;
        }
        if (normalize) {
            this.mDefValue = shared;
        }
    }
}

