/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.StringUtil;
import com.ctc.wstx.util.WordResolver;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationException;

public abstract class DTDAttribute {
    static final char CHAR_SPACE = ' ';
    public static final int TYPE_CDATA = 0;
    public static final int TYPE_ENUMERATED = 1;
    public static final int TYPE_ID = 2;
    public static final int TYPE_IDREF = 3;
    public static final int TYPE_IDREFS = 4;
    public static final int TYPE_ENTITY = 5;
    public static final int TYPE_ENTITIES = 6;
    public static final int TYPE_NOTATION = 7;
    public static final int TYPE_NMTOKEN = 8;
    public static final int TYPE_NMTOKENS = 9;
    public static final int DEF_DEFAULT = 1;
    public static final int DEF_IMPLIED = 2;
    public static final int DEF_REQUIRED = 3;
    public static final int DEF_FIXED = 4;
    static final String[] sTypes = new String[]{"CDATA", "ENUMERATED", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    protected final NameKey mName;
    protected final int mSpecialIndex;
    protected final int mDefValueType;
    protected String mDefValue;

    public DTDAttribute(NameKey name, int defValueType, String defValue, int specIndex) {
        this.mName = name;
        this.mDefValueType = defValueType;
        this.mDefValue = defValue;
        this.mSpecialIndex = specIndex;
    }

    public abstract DTDAttribute cloneWith(int var1);

    public final NameKey getName() {
        return this.mName;
    }

    public final String toString() {
        return this.mName.toString();
    }

    public final int getDefaultType() {
        return this.mDefValueType;
    }

    public final String getDefaultValue() {
        return this.mDefValue;
    }

    public final boolean isSpecial() {
        return DTDAttribute.isSpecial(this.mDefValueType);
    }

    public static boolean isSpecial(int defValueType) {
        return defValueType == 1 || defValueType == 4 || defValueType == 3;
    }

    public final boolean hasDefaultValue() {
        return this.mDefValueType == 1 || this.mDefValueType == 4;
    }

    public final boolean isRequired() {
        return this.mDefValueType == 3;
    }

    public final boolean isFixed() {
        return this.mDefValueType == 4;
    }

    public final int getSpecialIndex() {
        return this.mSpecialIndex;
    }

    public final boolean needsValidation() {
        return this.getValueType() != 0;
    }

    public int getValueType() {
        return 0;
    }

    public String getValueTypeString() {
        return sTypes[this.getValueType()];
    }

    public boolean typeIsId() {
        return false;
    }

    public boolean typeIsNotation() {
        return false;
    }

    public abstract String validate(DTDValidatorBase var1, char[] var2, int var3, int var4, boolean var5) throws XMLValidationException;

    public String validate(DTDValidatorBase v, String value, boolean normalize) throws XMLValidationException {
        int len = value.length();
        char[] cbuf = v.getTempAttrValueBuffer(value.length());
        if (len > 0) {
            value.getChars(0, len, cbuf, 0);
        }
        return this.validate(v, cbuf, 0, len, normalize);
    }

    public abstract void validateDefault(InputProblemReporter var1, boolean var2) throws XMLStreamException;

    public String normalize(DTDValidatorBase v, char[] cbuf, int start, int end) {
        return StringUtil.normalizeSpaces(cbuf, start, end);
    }

    public void normalizeDefault() {
        char[] cbuf;
        String str;
        if (this.mDefValue != null && this.mDefValue.length() > 0 && (str = StringUtil.normalizeSpaces(cbuf = this.mDefValue.toCharArray(), 0, cbuf.length)) != null) {
            this.mDefValue = str;
        }
    }

    protected String validateDefaultName(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        char c;
        String defValue = this.mDefValue.trim();
        if (defValue.length() == 0) {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; empty String is not a valid name");
        }
        if (!WstxInputData.is11NameStartChar(c = defValue.charAt(0)) && c != ':') {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character " + WstxInputData.getCharDesc(c) + ") not valid first character of a name");
        }
        int len = defValue.length();
        for (int i = 1; i < len; ++i) {
            if (WstxInputData.is11NameChar(defValue.charAt(i))) continue;
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + WstxInputData.getCharDesc(defValue.charAt(i)) + ") not valid name character");
        }
        return normalize ? defValue : this.mDefValue;
    }

    protected String validateDefaultNames(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String defValue = this.mDefValue;
        int len = defValue.length();
        StringBuffer sb = null;
        int count = 0;
        int start = 0;
        block0: while (start < len) {
            int i;
            char c = defValue.charAt(start);
            while (WstxInputData.isSpaceChar(c)) {
                if (++start >= len) break block0;
                c = defValue.charAt(start);
            }
            if (!WstxInputData.is11NameStartChar(c) && c != ':') {
                this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character " + WstxInputData.getCharDesc(c) + ") not valid first character of a name token");
            }
            for (i = start + 1; i < len && !WstxInputData.isSpaceChar(c = defValue.charAt(i)); ++i) {
                if (WstxInputData.is11NameChar(c)) continue;
                this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character " + WstxInputData.getCharDesc(c) + ") not a valid name character");
            }
            ++count;
            if (normalize) {
                if (sb == null) {
                    sb = new StringBuffer(i - start + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(defValue.substring(start, i));
            }
            start = i + 1;
        }
        if (count == 0) {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; empty String is not a valid name value");
        }
        return normalize ? sb.toString() : this.mDefValue;
    }

    protected String validateDefaultNmToken(InputProblemReporter rep, boolean normalize) throws XMLValidationException {
        String defValue = this.mDefValue.trim();
        if (defValue.length() == 0) {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKEN");
        }
        int len = defValue.length();
        for (int i = 0; i < len; ++i) {
            if (WstxInputData.is11NameChar(defValue.charAt(i))) continue;
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + WstxInputData.getCharDesc(defValue.charAt(i)) + ") not valid NMTOKEN character");
        }
        return normalize ? defValue : this.mDefValue;
    }

    public String validateEnumValue(char[] cbuf, int start, int end, boolean normalize, WordResolver res) {
        if (normalize) {
            while (start < end && cbuf[start] <= ' ') {
                ++start;
            }
            while (--end > start && cbuf[end] <= ' ') {
            }
            ++end;
        }
        if (start >= end) {
            return null;
        }
        return res.find(cbuf, start, end);
    }

    protected EntityDecl findEntityDecl(DTDValidatorBase v, char[] ch, int start, int len, int hash) throws XMLValidationException {
        String id;
        Map entMap = v.getEntityMap();
        EntityDecl ent = (EntityDecl)entMap.get(id = new String(ch, start, len));
        if (ent == null) {
            this.reportValidationProblem(v, "Referenced entity '" + id + "' not defined");
        } else if (ent.isParsed()) {
            this.reportValidationProblem(v, "Referenced entity '" + id + "' is not an unparsed entity");
        }
        return ent;
    }

    protected void checkEntity(InputProblemReporter rep, String id, EntityDecl ent) throws XMLValidationException {
        if (ent == null) {
            rep.reportValidationProblem("Referenced entity '" + id + "' not defined");
        } else if (ent.isParsed()) {
            rep.reportValidationProblem("Referenced entity '" + id + "' is not an unparsed entity");
        }
    }

    protected String reportInvalidChar(DTDValidatorBase v, char c, String msg) throws XMLValidationException {
        this.reportValidationProblem(v, "Invalid character " + WstxInputData.getCharDesc(c) + ": " + msg);
        return null;
    }

    protected String reportValidationProblem(DTDValidatorBase v, String msg) throws XMLValidationException {
        v.reportValidationProblem("Attribute '" + this.mName + "': " + msg);
        return null;
    }

    protected String reportValidationProblem(InputProblemReporter rep, String msg) throws XMLValidationException {
        rep.reportValidationProblem("Attribute definition '" + this.mName + "': " + msg);
        return null;
    }
}

