/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import com.ctc.wstx.util.WordResolver;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;

public abstract class AttributeCollector {
    static final char CHAR_SPACE = ' ';
    protected static final int LONG_ATTR_LIST_LEN = 4;
    protected static final int EXP_ATTR_COUNT = 32;
    protected final boolean mNormAttrs;
    protected int mAttrCount;
    protected int mNonDefCount;
    protected final TextBuilder mValueBuffer = new TextBuilder(32);
    protected final StringVector mAttrNames = new StringVector(32);
    protected String[] mAttrValues = null;
    protected int[] mAttrMap = null;
    protected int mAttrHashSize;
    protected int mAttrSpillEnd;

    protected AttributeCollector(boolean normAttrs) {
        this.mNormAttrs = normAttrs;
    }

    protected abstract void reset();

    public abstract int getNsCount();

    public abstract String getNsPrefix(int var1);

    public abstract String getNsURI(int var1);

    public final int getCount() {
        return this.mAttrCount;
    }

    public int getSpecifiedCount() {
        return this.mNonDefCount;
    }

    public abstract String getPrefix(int var1);

    public abstract String getLocalName(int var1);

    public abstract String getURI(int var1);

    public abstract QName getQName(int var1);

    public final String getValue(int index) {
        String str;
        if (index < 0 || index >= this.mAttrCount) {
            this.throwIndex(index);
        }
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[this.mAttrCount];
        }
        if ((str = this.mAttrValues[index]) == null) {
            this.mAttrValues[index] = str = this.mValueBuffer.getEntry(index);
        }
        return str;
    }

    public abstract String getValue(String var1, String var2);

    public boolean isSpecified(int index) {
        return index < this.mNonDefCount;
    }

    public abstract TextBuilder getDefaultNsBuilder();

    public abstract TextBuilder getNsBuilder(String var1);

    public abstract TextBuilder getAttrBuilder(String var1, String var2);

    public abstract ElemAttrs buildAttrOb();

    public void normalizeValue(int index) {
        String val = this.mValueBuffer.normalizeSpaces(index);
        if (val == null) {
            if (this.mAttrValues == null) {
                this.mAttrValues = new String[this.mAttrCount];
            }
            this.mAttrValues[index] = val;
        }
    }

    public String checkEnumValue(int index, WordResolver res) {
        int start;
        TextBuilder b = this.mValueBuffer;
        int end = b.getOffset(index + 1) - 1;
        char[] buf = b.getCharBuffer();
        if (this.mNormAttrs) {
            for (start = b.getOffset(index); start <= end && buf[start] == ' '; ++start) {
            }
            while (end > start && buf[end] == ' ') {
                --end;
            }
        }
        if (start > end) {
            return null;
        }
        String result = res.find(buf, start, end + 1);
        if (result != null) {
            if (this.mAttrValues == null) {
                this.mAttrValues = new String[this.mAttrCount];
            }
            this.mAttrValues[index] = result;
        }
        return result;
    }

    public abstract void addDefaultAttr(InputProblemReporter var1, StringVector var2, String var3, String var4, String var5) throws WstxException;

    public final TextBuilder getAttrBuilder() {
        return this.mValueBuffer;
    }

    public final void setNormalizedValue(int index, String value) {
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[this.mAttrCount];
        }
        this.mAttrValues[index] = value;
    }

    protected void throwIndex(int index) {
        throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + this.getCount() + " attributes");
    }

    public StringVector getNameList() {
        return this.mAttrNames;
    }

    public final void writeValue(int index, Writer w) throws IOException {
        this.mValueBuffer.getEntry(index, w);
    }

    public abstract void writeAttribute(int var1, char var2, Writer var3, Writer var4) throws IOException;

    protected static String[] resize(String[] old) {
        int len = old.length;
        String[] result = new String[len];
        System.arraycopy(old, 0, result, 0, len);
        return result;
    }

    protected void throwDupAttr(InputProblemReporter rep, int index) throws WstxException {
        rep.throwParseError("Duplicate attribute '" + this.getQName(index) + "'.");
    }
}

