/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.ent.NotationDecl;
import com.ctc.wstx.evt.WEntityDeclaration;
import com.ctc.wstx.evt.WEvent;
import com.ctc.wstx.evt.WNotationDeclaration;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.evt.DTD2;

public class WDTD
extends WEvent
implements DTD2 {
    final String mRootName;
    final String mSystemId;
    final String mPublicId;
    final String mInternalSubset;
    final DTDSubset mDTD;
    List mEntities = null;
    List mNotations = null;
    String mFullText = null;

    public WDTD(Location loc, String rootName, String sysId, String pubId, String intSubset, DTDSubset dtd) {
        super(loc);
        this.mDTD = dtd;
        this.mRootName = rootName;
        this.mSystemId = sysId;
        this.mPublicId = pubId;
        this.mInternalSubset = intSubset;
        this.mFullText = null;
    }

    public WDTD(Location loc, String rootName, String sysId, String pubId, String intSubset) {
        this(loc, rootName, sysId, pubId, intSubset, null);
    }

    public WDTD(Location loc, String rootName, String intSubset) {
        this(loc, rootName, null, null, intSubset, null);
    }

    public WDTD(Location loc, String fullText) {
        this(loc, null, null, null, null, null);
        this.mFullText = fullText;
    }

    public String getDocumentTypeDeclaration() {
        if (this.mFullText == null) {
            int len = 60;
            if (this.mInternalSubset != null) {
                len += this.mInternalSubset.length() + 4;
            }
            StringWriter sw = new StringWriter(len);
            try {
                this.writeAsEncodedUnicode(sw);
            }
            catch (XMLStreamException sex) {
                throw new Error(ErrorConsts.ERR_INTERNAL + ": " + sex);
            }
            this.mFullText = sw.toString();
        }
        return this.mFullText;
    }

    public List getEntities() {
        if (this.mEntities == null && this.mDTD != null) {
            List in = this.mDTD.getGeneralEntityList();
            int len = in.size();
            ArrayList<WEntityDeclaration> out = new ArrayList<WEntityDeclaration>(len);
            for (int i = 0; i < len; ++i) {
                out.add(new WEntityDeclaration((EntityDecl)in.get(i)));
            }
            this.mEntities = out;
        }
        return this.mEntities;
    }

    public List getNotations() {
        if (this.mNotations == null && this.mDTD != null) {
            List in = this.mDTD.getNotationList();
            int len = in.size();
            ArrayList<WNotationDeclaration> out = new ArrayList<WNotationDeclaration>(len);
            for (int i = 0; i < len; ++i) {
                out.add(new WNotationDeclaration((NotationDecl)in.get(i)));
            }
            this.mNotations = out;
        }
        return this.mNotations;
    }

    public Object getProcessedDTD() {
        return this.mDTD;
    }

    public int getEventType() {
        return 11;
    }

    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
        try {
            w.write("<!DOCTYPE");
            if (this.mRootName != null) {
                w.write(32);
                w.write(this.mRootName);
            }
            if (this.mSystemId != null) {
                if (this.mPublicId != null) {
                    w.write(" PUBLIC \"");
                    w.write(this.mPublicId);
                    w.write("\" ");
                } else {
                    w.write(" SYSTEM \"");
                }
                w.write(this.mSystemId);
                w.write(34);
            }
            if (this.mInternalSubset != null) {
                w.write(" [");
                w.write(this.mInternalSubset);
                w.write(93);
            }
            w.write(">");
        }
        catch (IOException ie) {
            this.throwFromIOE(ie);
        }
    }

    public void writeUsing(XMLStreamWriter w) throws XMLStreamException {
        if (w instanceof XMLStreamWriter2 && this.mRootName != null) {
            XMLStreamWriter2 sw2 = (XMLStreamWriter2)w;
            sw2.writeDTD(this.mRootName, this.mSystemId, this.mPublicId, this.mInternalSubset);
            return;
        }
        w.writeDTD(this.getDocumentTypeDeclaration());
    }

    public String getRootName() {
        return this.mRootName;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getInternalSubset() {
        return this.mInternalSubset;
    }
}

