/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDElement;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.StructValidator;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.SymbolTable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;

public class ElementValidator
implements InputConfigFlags {
    static final int DEFAULT_STACK_SIZE = 32;
    static final int EXP_MAX_ATTRS = 32;
    static final HashMap EMPTY_MAP = new HashMap();
    final InputProblemReporter mReporter;
    final SymbolTable mSymbols;
    final Map mGeneralEntities;
    final boolean mNsAware;
    final AttributeCollector mAttrCollector;
    final boolean mNormAttrs;
    protected DTDElement[] mElemStack = null;
    protected int mElemCount = 0;
    protected StructValidator[] mValidators = null;
    protected DTDAttribute[] mAttrSpecs = null;
    protected int mAttrCount = 1;
    protected int mIdAttrIndex = -1;
    protected ElementIdMap mIdMap = null;
    final transient NameKey mTmpKey = new NameKey(null, null);
    BitSet mTmpSpecs;

    public ElementValidator(InputProblemReporter rep, SymbolTable symbols, boolean nsAware, Map genEntities, AttributeCollector ac, boolean normAttrs) {
        this.mReporter = rep;
        this.mSymbols = symbols;
        this.mNsAware = nsAware;
        this.mGeneralEntities = genEntities;
        this.mAttrCollector = ac;
        this.mNormAttrs = normAttrs;
        this.mElemStack = new DTDElement[32];
        this.mValidators = new StructValidator[32];
        this.mAttrSpecs = new DTDAttribute[32];
    }

    public int pop(InputProblemReporter rep) throws WstxException {
        String msg;
        int ix = --this.mElemCount;
        DTDElement closingElem = this.mElemStack[ix];
        this.mElemStack[ix] = null;
        StructValidator v = this.mValidators[ix];
        this.mValidators[ix] = null;
        if (v != null && (msg = v.fullyValid()) != null) {
            rep.throwParseError("Validation error, element </" + closingElem + ">: " + msg);
        }
        if (ix < 1) {
            ElementId ref;
            if (this.mIdMap != null && (ref = this.mIdMap.getFirstUndefined()) != null) {
                this.throwParseError(ref.getLocation(), "Undefined id '" + ref.getId() + "': referenced from element <" + ref.getElemName() + ">, attribute '" + ref.getAttrName() + "'");
            }
            return 1;
        }
        return this.mElemStack[ix - 1].getAllowedContent();
    }

    public int resolveElem(InputProblemReporter rep, DTDElement elem, StringVector ns) throws WstxException {
        String msg;
        StructValidator pv;
        BitSet specBits;
        int specCount;
        int elemCount;
        if ((elemCount = this.mElemCount++) >= this.mElemStack.length) {
            this.mElemStack = (DTDElement[])DataUtil.growArrayBy50Pct(this.mElemStack);
            this.mValidators = (StructValidator[])DataUtil.growArrayBy50Pct(this.mValidators);
        }
        this.mElemStack[elemCount] = elem;
        StringVector attrNames = this.mAttrCollector.getNameList();
        HashMap attrMap = elem.getAttributes();
        if (attrMap == null) {
            attrMap = EMPTY_MAP;
        }
        if ((specCount = elem.getSpecialCount()) == 0) {
            specBits = null;
        } else {
            specBits = this.mTmpSpecs;
            if (specBits == null) {
                this.mTmpSpecs = specBits = new BitSet(specCount);
            } else {
                specBits.clear();
            }
        }
        int attrLen = attrNames.size();
        int maxAttrs = specCount + (this.mNsAware ? attrLen >> 1 : attrLen);
        if (this.mAttrSpecs.length < maxAttrs) {
            this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayToAtLeast(this.mAttrSpecs, maxAttrs);
        }
        NameKey tmpKey = this.mTmpKey;
        boolean validateAttrs = elem.attrsNeedValidation();
        boolean anyFixed = elem.hasFixedAttrs();
        int j = 0;
        DTDAttribute idAttr = elem.getIdAttribute();
        this.mIdAttrIndex = -1;
        int i = 0;
        while (i < attrLen) {
            int specIndex;
            if (this.mNsAware) {
                tmpKey.reset(attrNames.getString(i), attrNames.getString(i + 1));
                i += 2;
            } else {
                tmpKey.reset(null, attrNames.getString(i));
                ++i;
            }
            DTDAttribute attr = (DTDAttribute)attrMap.get(tmpKey);
            if (attr == null) {
                rep.throwParseError(ErrorConsts.ERR_VLD_UNKNOWN_ATTR, elem.toString(), tmpKey.toString());
            }
            this.mAttrSpecs[j] = attr;
            if (attr == idAttr) {
                this.mIdAttrIndex = j;
            }
            if (specBits != null && (specIndex = attr.getSpecialIndex()) >= 0) {
                specBits.set(specIndex);
            }
            if (validateAttrs) {
                attr.validate(this, this.mNormAttrs, this.mAttrCollector, j);
            }
            if (anyFixed && attr.isFixed()) {
                String exp = attr.getDefaultValue();
                String act = this.mAttrCollector.getValue(j);
                if (!act.equals(exp)) {
                    rep.throwParseError("Value of attribute \"" + attr + "\" (element <" + elem + ">) not \"" + exp + "\" as expected, but \"" + act + "\"");
                }
            }
            ++j;
        }
        this.mAttrCount = j;
        if (specBits != null) {
            int ix = specBits.nextClearBit(0);
            while (ix < specCount) {
                String def;
                List specAttrs = elem.getSpecialAttrs();
                DTDAttribute attr = (DTDAttribute)specAttrs.get(ix);
                if (attr.isRequired()) {
                    rep.throwParseError("Required attribute '" + attr + "' missing from element <" + elem + ">");
                }
                if ((def = attr.getDefaultValue()) == null) {
                    throw new Error("Internal error: null default attribute value");
                }
                NameKey an = attr.getName();
                this.mAttrCollector.addDefaultAttr(rep, ns, an.getPrefix(), an.getLocalName(), def);
                this.mAttrSpecs[this.mAttrCount++] = attr;
                ix = specBits.nextClearBit(ix + 1);
            }
        }
        StructValidator structValidator = pv = elemCount > 0 ? this.mValidators[elemCount - 1] : null;
        if (pv != null && (msg = pv.tryToValidate(elem.getName())) != null) {
            int ix = msg.indexOf("$END");
            String pname = this.mElemStack[elemCount - 1].toString();
            if (ix >= 0) {
                msg = msg.substring(0, ix) + "</" + pname + ">" + msg.substring(ix + 4);
            }
            rep.throwParseError("Validation error, encountered element <" + elem.getName() + "> as child of <" + pname + ">: " + msg);
        }
        this.mValidators[elemCount] = elem.getValidator();
        return elem.getAllowedContent();
    }

    NameKey getElemName() {
        DTDElement elem = this.mElemStack[this.mElemCount - 1];
        return elem.getName();
    }

    InputProblemReporter getReporter() {
        return this.mReporter;
    }

    Location getLocation() {
        return this.mReporter.getLocation();
    }

    ElementIdMap getIdMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new ElementIdMap();
        }
        return this.mIdMap;
    }

    SymbolTable getSymbolTable() {
        return this.mSymbols;
    }

    Map getEntityMap() {
        return this.mGeneralEntities;
    }

    public String getAttributeType(int index) {
        return this.mAttrSpecs[index].getValueTypeString();
    }

    public int getIdAttrIndex() {
        return this.mIdAttrIndex;
    }

    public int getNotationAttrIndex() {
        int len = this.mAttrCount;
        for (int i = 0; i < len; ++i) {
            if (!this.mAttrSpecs[i].typeIsNotation()) continue;
            return i;
        }
        return -1;
    }

    void throwParseError(String msg) throws WstxException {
        this.mReporter.throwParseError(msg);
    }

    void throwParseError(Location loc, String msg) throws WstxException {
        this.mReporter.throwParseError(loc, msg);
    }
}

