/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.MinimalDTDReader;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.TextBuilder;
import java.util.Map;
import java.util.StringTokenizer;

public final class DTDEntitiesAttr
extends DTDAttribute {
    public DTDEntitiesAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDEntitiesAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 6;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int last = tb.getOffset(index + 1) - 1;
        for (start = tb.getOffset(index); start <= last && WstxInputData.isSpaceChar(ch[start]); ++start) {
        }
        if (last < start) {
            this.reportParseError(v, "Empty ENTITIES value");
        }
        while (last > start && WstxInputData.isSpaceChar(ch[last])) {
            --last;
        }
        SymbolTable st = v.getSymbolTable();
        Map entMap = v.getEntityMap();
        String idStr = null;
        StringBuffer sb = null;
        while (start <= last) {
            int i;
            int c = ch[start];
            if (!WstxInputData.is11NameStartChar((char)c) && c != 58) {
                this.reportInvalidChar(v, (char)c, "not valid as the first ENTITIES character");
            }
            int hash = c;
            for (i = start + 1; i <= last && !WstxInputData.isSpaceChar((char)(c = ch[i])); ++i) {
                if (!WstxInputData.is11NameChar((char)c)) {
                    this.reportInvalidChar(v, (char)c, "not valid as an ENTITIES character");
                }
                hash = hash * 31 + c;
            }
            EntityDecl ent = this.findEntityDecl(v, ch, start, i - start, hash);
            start = i + 1;
            if (normalize) {
                if (idStr == null) {
                    idStr = ent.getName();
                } else {
                    if (sb == null) {
                        sb = new StringBuffer(idStr);
                    }
                    idStr = ent.getName();
                    sb.append(' ');
                    sb.append(idStr);
                }
            }
            while (start <= last && WstxInputData.isSpaceChar(ch[start])) {
                ++start;
            }
        }
        if (normalize) {
            if (sb != null) {
                idStr = sb.toString();
            }
            ac.setNormalizedValue(index, idStr);
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        String normStr = this.validateDefaultNames(rep, true);
        if (normalize) {
            this.mDefValue = normStr;
        }
        StringTokenizer st = new StringTokenizer(normStr);
        MinimalDTDReader dtdr = (MinimalDTDReader)rep;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            EntityDecl ent = dtdr.findEntity(str);
            this.checkEntity(rep, normStr, ent);
        }
    }
}

