/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WriterBase;
import java.io.IOException;
import java.io.Writer;

public class UTFAttrValueWriter
extends WriterBase {
    final char mQuoteChar;
    final String mQuoteEntity;

    public UTFAttrValueWriter(Writer out, String enc, char qchar) {
        super(out);
        this.mQuoteChar = qchar;
        this.mQuoteEntity = UTFAttrValueWriter.getQuoteEntity(qchar);
    }

    public void write(int c) throws IOException {
        if (c <= 60) {
            if (c == this.mQuoteChar) {
                this.out.write(this.mQuoteEntity);
                return;
            }
            if (c == 60) {
                this.out.write("&lt;");
                return;
            }
            if (c == 38) {
                this.out.write("&amp;");
                return;
            }
            if (c == 0) {
                this.throwNullChar();
            }
        } else {
            this.out.write(c);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        len += off;
        char qchar = this.mQuoteChar;
        do {
            int outLen;
            int start = off;
            char c = '\u0000';
            String ent = null;
            while (off < len) {
                c = cbuf[off];
                if (c <= '<') {
                    if (c == qchar) {
                        ent = this.mQuoteEntity;
                        break;
                    }
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\u0000') {
                        this.throwNullChar();
                    }
                }
                ++off;
            }
            if ((outLen = off - start) > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
        } while (++off < len);
    }

    public void write(String str, int off, int len) throws IOException {
        len += off;
        char qchar = this.mQuoteChar;
        do {
            int outLen;
            int start = off;
            char c = '\u0000';
            String ent = null;
            while (off < len) {
                c = str.charAt(off);
                if (c <= '<') {
                    if (c == qchar) {
                        ent = this.mQuoteEntity;
                        break;
                    }
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\u0000') {
                        this.throwNullChar();
                    }
                }
                ++off;
            }
            if ((outLen = off - start) > 0) {
                this.out.write(str, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
        } while (++off < len);
    }
}

