/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import java.net.URL;

public final class DTDId {
    final String mPublicId;
    final URL mSystemId;
    final int mConfigFlags;
    int mHashCode = 0;

    private DTDId(String publicId, URL systemId, int configFlags) {
        this.mPublicId = publicId;
        this.mSystemId = systemId;
        this.mConfigFlags = configFlags;
    }

    public static DTDId constructFromPublicId(String publicId, int configFlags) {
        if (publicId == null || publicId.length() == 0) {
            throw new IllegalArgumentException("Empty/null public id.");
        }
        return new DTDId(publicId, null, configFlags);
    }

    public static DTDId constructFromSystemId(URL systemId, int configFlags) {
        if (systemId == null) {
            throw new IllegalArgumentException("Null system id.");
        }
        return new DTDId(null, systemId, configFlags);
    }

    public static DTDId construct(String publicId, URL systemId, int configFlags) {
        if (publicId != null && publicId.length() > 0) {
            return new DTDId(publicId, null, configFlags);
        }
        if (systemId == null) {
            throw new IllegalArgumentException("Illegal arguments; both public and system id null/empty.");
        }
        return new DTDId(null, systemId, configFlags);
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public URL getSystemId() {
        return this.mSystemId;
    }

    public int hashCode() {
        int hash = this.mHashCode;
        if (hash == 0) {
            hash = this.mConfigFlags;
            hash = this.mPublicId != null ? (hash ^= this.mPublicId.hashCode()) : (hash ^= this.mSystemId.hashCode());
            this.mHashCode = hash;
        }
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append("Public-id: ");
        sb.append(this.mPublicId);
        sb.append(", system-id: ");
        sb.append(this.mSystemId);
        sb.append(" [config flags: 0x");
        sb.append(Integer.toHexString(this.mConfigFlags));
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DTDId)) {
            return false;
        }
        DTDId other = (DTDId)o;
        if (other.mConfigFlags != this.mConfigFlags) {
            return false;
        }
        if (this.mPublicId != null) {
            String op = other.mPublicId;
            return op != null && op.equals(this.mPublicId);
        }
        return this.mSystemId.equals(other.mSystemId);
    }
}

