/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.SingleByteAttrValueWriter;
import com.ctc.wstx.io.SingleByteTextWriter;
import com.ctc.wstx.io.UTFAttrValueWriter;
import com.ctc.wstx.io.UTFTextWriter;
import com.ctc.wstx.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class TextEscaper {
    private TextEscaper() {
    }

    public static Writer constructAttrValueWriter(Writer w, String enc, char qchar) throws UnsupportedEncodingException {
        int bitSize = TextEscaper.guessEncodingBitSize(enc);
        if (bitSize < 16) {
            return new SingleByteAttrValueWriter(w, enc, qchar, 1 << bitSize);
        }
        return new UTFAttrValueWriter(w, enc, qchar);
    }

    public static Writer constructTextWriter(Writer w, String enc) throws UnsupportedEncodingException {
        int bitSize = TextEscaper.guessEncodingBitSize(enc);
        if (bitSize < 16) {
            return new SingleByteTextWriter(w, enc, 1 << bitSize);
        }
        return new UTFTextWriter(w, enc);
    }

    public static void writeEscapedXMLText(Writer w, String text) throws IOException {
        int len = text.length();
        if (len < 2) {
            if (len == 1) {
                char c = text.charAt(0);
                if (c == '<') {
                    w.write("&lt;");
                } else if (c == '&') {
                    w.write("&amp;");
                } else {
                    w.write(text.charAt(0));
                }
            }
            return;
        }
        for (int i = 0; i < len; ++i) {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = text.charAt(i)) != '<' && c != '&' && (c != '>' || i < 2 || text.charAt(i - 1) != ']' || text.charAt(i - 2) != ']')) {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(text, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            w.write("&gt;");
        }
    }

    public static void writeEscapedAttrValue(Writer w, String value) throws IOException {
        int i = 0;
        int len = value.length();
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = value.charAt(i)) != '<' && c != '&' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(value, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&quot;");
        } while (++i < len);
    }

    public static void outputDTDText(Writer w, char[] ch, int offset, int len) throws IOException {
        int i = offset;
        len += offset;
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = ch[i]) != '&' && c != '%' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(ch, start, outLen);
            }
            if (i >= len) continue;
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c == '%') {
                w.write("&#37;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&#34;");
        } while (++i < len);
    }

    public static int guessEncodingBitSize(String enc) {
        if (enc.length() < 1) {
            return 16;
        }
        char c = enc.charAt(0);
        if (c == 'u' || c == 'U') {
            if (StringUtil.encodingStartsWith(enc, "UTF") || StringUtil.encodingStartsWith(enc, "UCS")) {
                return 16;
            }
            if (StringUtil.equalEncodings(enc, "US-ASCII")) {
                return 7;
            }
            if (StringUtil.encodingStartsWith(enc, "UNICODE")) {
                return 16;
            }
        } else if (c == 'i' || c == 'I') {
            if (StringUtil.encodingStartsWith(enc, "ISO-10646")) {
                int ix = enc.indexOf("10646");
                String suffix = enc.substring(ix + 5);
                if (StringUtil.encodingStartsWith(enc, "UTF") || StringUtil.encodingStartsWith(enc, "UCS")) {
                    return 16;
                }
                if (StringUtil.equalEncodings(enc, "US-ASCII")) {
                    return 7;
                }
            } else {
                if (StringUtil.encodingStartsWith(enc, "ISO-646")) {
                    return 7;
                }
                if (StringUtil.encodingStartsWith(enc, "ISO-Latin")) {
                    return 8;
                }
            }
        } else if ((c == 'a' || c == 'A') && StringUtil.equalEncodings(enc, "ASCII")) {
            return 7;
        }
        return 8;
    }
}

