/*
 * Decompiled with CFR 0.152.
 */
package com.github.robust.client.utils;

import android.util.Log;
import com.github.robust.client.utils.FileUtil;
import com.meituan.robust.RobustCallBack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class NetUtil {
    public static final String CONTENT_TYPE_DOWNLOAD = "application/octet-stream;charset=utf8";
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CHARSET_NAME = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean download(String url, String savePath, RobustCallBack noticeCall) {
        boolean bl;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            int flag;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(60000);
            connection.setReadTimeout(60000);
            connection.setDoInput(true);
            connection.addRequestProperty("Content-Type", CONTENT_TYPE_DOWNLOAD);
            connection.addRequestProperty("User-Agent", "Robust-Client");
            byte[] buff = new byte[4096];
            fileOutputStream = new FileOutputStream(new File(savePath));
            inputStream = connection.getInputStream();
            while ((flag = inputStream.read(buff)) > 0) {
                fileOutputStream.write(buff, 0, flag);
            }
            Log.i((String)"FILE_DOWNLOAD", (String)("\u6587\u4ef6\u4e0b\u8f7d\u5b8c\u6210:" + savePath));
            bl = true;
        }
        catch (IOException e) {
            try {
                if (noticeCall != null) {
                    noticeCall.exceptionNotify((Throwable)e, "\u4e0b\u8f7d\u8865\u4e01\u5f02\u5e38");
                }
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeStream(fileOutputStream, inputStream);
                throw throwable;
            }
            FileUtil.closeStream(fileOutputStream, inputStream);
            return false;
        }
        FileUtil.closeStream(fileOutputStream, inputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String body) throws Exception {
        String string;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String strBuff;
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setReadTimeout(30000);
            connection.setConnectTimeout(30000);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", CONTENT_TYPE_JSON);
            connection.addRequestProperty("User-Agent", "Robust-Client");
            outputStream = connection.getOutputStream();
            outputStream.write(body.getBytes(CHARSET_NAME));
            StringBuilder stringBuilder = new StringBuilder();
            inputStream = connection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((strBuff = bufferedReader.readLine()) != null) {
                stringBuilder.append(strBuff);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            FileUtil.closeStream(bufferedReader, outputStream, inputStream);
            throw throwable;
        }
        FileUtil.closeStream(bufferedReader, outputStream, inputStream);
        return string;
    }
}

