/*
 * Decompiled with CFR 0.152.
 */
package com.github.robust.client;

import android.util.Log;
import com.github.robust.client.PatchInfo;
import com.github.robust.client.RobustSdkManager;
import com.github.robust.client.utils.FileUtil;
import com.github.robust.client.utils.NetUtil;
import com.google.gson.Gson;
import com.meituan.robust.Patch;
import com.meituan.robust.RobustCallBack;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RobustCallbackImpl
implements RobustCallBack {
    private static final String TAG = "Robust-Callback";
    private static final Gson GSON = new Gson();

    public void onPatchListFetched(boolean result, boolean isNet, List<Patch> patches) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("code", "1000");
        map.put("msg", "\u52a0\u8f7d\u8865\u4e01" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
        this.postBody(map);
    }

    public void onPatchFetched(boolean result, boolean isNet, Patch patch) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("code", "1000");
        map.put("msg", "\u52a0\u8f7d\u8865\u4e01" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
        this.postBody(map);
    }

    public void onPatchApplied(boolean result, Patch patch) {
        FileUtil.deleteFile(patch.getTempPath());
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("code", result ? "1001" : "1002");
        map.put("msg", "\u8865\u4e01\u5e94\u7528" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
        map.put("patchId", patch.getName());
        this.postBody(map);
    }

    public void logNotify(String log, String where) {
        Log.i((String)TAG, (String)("\u8865\u4e01\u52a0\u8f7d\u65e5\u5fd7\uff1a" + log + " \u51fa\u5904\uff1a " + where));
    }

    public void exceptionNotify(Throwable throwable, String where) {
        Log.i((String)TAG, (String)("\u8865\u4e01\u52a0\u8f7d\u5f02\u5e38\uff1a" + throwable.getMessage() + " \u51fa\u5904\uff1a " + where));
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("code", "1003");
        map.put("msg", "\u8865\u4e01\u5e94\u7528\u52a0\u8f7d\u5931\u8d25" + where);
        map.put("exp", this.printException(throwable));
        PatchInfo patchInfo = RobustSdkManager.getPatchInfo();
        map.put("patchId", patchInfo == null ? "unknown" : patchInfo.getPatchId());
        this.postBody(map);
    }

    private void postBody(Map<String, String> body) {
        String reportUrl = RobustSdkManager.getInstance().getAppMetaData().getReportUrl();
        if (reportUrl == null) {
            return;
        }
        try {
            NetUtil.doPost(reportUrl, GSON.toJson(body));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printException(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        try (PrintWriter printWriter = null;){
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            printWriter = new PrintWriter(stream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String string = stream.toString("utf-8");
            return string;
        }
        return "";
    }
}

