/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.selenium;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import net.lightbody.bmp.proxy.selenium.CertificateCreator;
import net.lightbody.bmp.proxy.selenium.ThumbprintUtil;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreManager {
    public static final String _caPrivKeyAlias = "signingCertPrivKey";
    private final Logger log = LoggerFactory.getLogger(KeyStoreManager.class);
    public final String RSA_KEYGEN_ALGO = "RSA";
    public final String DSA_KEYGEN_ALGO = "DSA";
    public final KeyPairGenerator _rsaKpg;
    public final KeyPairGenerator _dsaKpg;
    private final String CERTMAP_SER_FILE = "certmap.ser";
    private final String SUBJMAP_SER_FILE = "subjmap.ser";
    private final String EXPORTED_CERT_NAME = "cybervillainsCA.cer";
    private final char[] _keypassword = "password".toCharArray();
    private final char[] _keystorepass = "password".toCharArray();
    private final String _caPrivateKeystore = "cybervillainsCA.jks";
    private final String _caCertAlias = "signingCert";
    private final String KEYMAP_SER_FILE = "keymap.ser";
    private final String PUB_KEYMAP_SER_FILE = "pubkeymap.ser";
    X509Certificate _caCert;
    PrivateKey _caPrivKey;
    KeyStore _ks;
    private HashMap<PublicKey, PrivateKey> _rememberedPrivateKeys;
    private HashMap<PublicKey, PublicKey> _mappedPublicKeys;
    private HashMap<String, String> _certMap;
    private HashMap<String, String> _subjectMap;
    private SecureRandom _sr;
    private final boolean persistImmediately = true;
    private final File root;

    public KeyStoreManager(File root) {
        File file;
        ObjectInputStream in;
        this.root = root;
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 2);
        this._sr = new SecureRandom();
        try {
            this._rsaKpg = KeyPairGenerator.getInstance("RSA");
            this._dsaKpg = KeyPairGenerator.getInstance("DSA");
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        try {
            File privKeys = new File(root, "keymap.ser");
            if (!privKeys.exists()) {
                this._rememberedPrivateKeys = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(privKeys));
                this._rememberedPrivateKeys = (HashMap)in.readObject();
                in.close();
            }
            File pubKeys = new File(root, "pubkeymap.ser");
            if (!pubKeys.exists()) {
                this._mappedPublicKeys = new HashMap();
            } else {
                ObjectInputStream in2 = new ObjectInputStream(new FileInputStream(pubKeys));
                this._mappedPublicKeys = (HashMap)in2.readObject();
                in2.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        this._rsaKpg.initialize(2048, this._sr);
        this._dsaKpg.initialize(2048, this._sr);
        try {
            this._ks = KeyStore.getInstance("JKS");
            this.reloadKeystore();
        }
        catch (FileNotFoundException fnfe) {
            try {
                this.createKeystore();
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            file = new File(root, "certmap.ser");
            if (!file.exists()) {
                this._certMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this._certMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        try {
            file = new File(root, "subjmap.ser");
            if (!file.exists()) {
                this._subjectMap = new HashMap();
            } else {
                in = new ObjectInputStream(new FileInputStream(file));
                this._subjectMap = (HashMap)in.readObject();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private void reloadKeystore() throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        File keyStoreFile = new File(this.root, "cybervillainsCA.jks");
        FileInputStream is = new FileInputStream(keyStoreFile);
        this._ks.load(is, this._keystorepass);
        this._caCert = (X509Certificate)this._ks.getCertificate("signingCert");
        this._caPrivKey = (PrivateKey)this._ks.getKey(_caPrivKeyAlias, this._keypassword);
    }

    protected void createKeystore() {
        if (this._caCert == null || this._caPrivKey == null) {
            this.log.error("Fatal error creating/storing keystore or signing cert.");
            throw new RuntimeException("Ups, tried to create a Cert");
        }
        this.log.debug("Successfully loaded keystore.");
    }

    public synchronized void addCertAndPrivateKey(String hostname, X509Certificate cert, PrivateKey privKey) throws KeyStoreException, CertificateException, NoSuchAlgorithmException {
        this._ks.deleteEntry(hostname);
        this._ks.setCertificateEntry(hostname, cert);
        this._ks.setKeyEntry(hostname, privKey, this._keypassword, new Certificate[]{cert});
        this.persist();
    }

    public synchronized void persist() throws KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try {
            FileOutputStream kso = new FileOutputStream(new File(this.root, "cybervillainsCA.jks"));
            this._ks.store(kso, this._keystorepass);
            kso.flush();
            kso.close();
            this.persistCertMap();
            this.persistSubjectMap();
            this.persistKeyPairMap();
            this.persistPublicKeyMap();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public synchronized X509Certificate getCertificateByAlias(String alias) throws KeyStoreException {
        return (X509Certificate)this._ks.getCertificate(alias);
    }

    public synchronized X509Certificate getCertificateByHostname(String hostname) throws KeyStoreException, CertificateParsingException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException, CertIOException, OperatorCreationException {
        String alias = this._subjectMap.get(this.getSubjectForHostname(hostname));
        if (alias != null) {
            return (X509Certificate)this._ks.getCertificate(alias);
        }
        return this.getMappedCertificateForHostname(hostname);
    }

    public synchronized X509Certificate getSigningCert() throws KeyStoreException {
        return this._caCert;
    }

    public synchronized PrivateKey getSigningPrivateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this._caPrivKey;
    }

    public synchronized X509Certificate getMappedCertificate(X509Certificate cert) throws CertificateEncodingException, InvalidKeyException, CertificateException, CertificateNotYetValidException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, UnrecoverableKeyException, CertIOException, OperatorCreationException {
        String thumbprint = ThumbprintUtil.getThumbprint(cert);
        String mappedCertThumbprint = this._certMap.get(thumbprint);
        if (mappedCertThumbprint == null) {
            PrivateKey privKey;
            PublicKey mappedPk = this.getMappedPublicKey(cert.getPublicKey());
            if (mappedPk == null) {
                KeyPair kp;
                PublicKey pk = cert.getPublicKey();
                String algo = pk.getAlgorithm();
                if (algo.equals("RSA")) {
                    kp = this.getRSAKeyPair();
                } else if (algo.equals("DSA")) {
                    kp = this.getDSAKeyPair();
                } else {
                    throw new InvalidKeyException("Key algorithm " + algo + " not supported.");
                }
                mappedPk = kp.getPublic();
                privKey = kp.getPrivate();
                this.mapPublicKeys(cert.getPublicKey(), mappedPk);
            } else {
                privKey = this.getPrivateKey(mappedPk);
            }
            X509Certificate replacementCert = CertificateCreator.mitmDuplicateCertificate(cert, mappedPk, this.getSigningCert(), this.getSigningPrivateKey());
            this.addCertAndPrivateKey(null, replacementCert, privKey);
            mappedCertThumbprint = ThumbprintUtil.getThumbprint(replacementCert);
            this._certMap.put(thumbprint, mappedCertThumbprint);
            this._certMap.put(mappedCertThumbprint, thumbprint);
            this._subjectMap.put(replacementCert.getSubjectX500Principal().getName(), thumbprint);
            this.persist();
            return replacementCert;
        }
        return this.getCertificateByAlias(mappedCertThumbprint);
    }

    public X509Certificate getMappedCertificateForHostname(String hostname) throws CertificateParsingException, InvalidKeyException, CertificateExpiredException, CertificateNotYetValidException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertIOException, OperatorCreationException {
        String subject = this.getSubjectForHostname(hostname);
        String thumbprint = this._subjectMap.get(subject);
        if (thumbprint == null) {
            KeyPair kp = this.getRSAKeyPair();
            X509Certificate newCert = CertificateCreator.generateStdSSLServerCertificate(kp.getPublic(), this.getSigningCert(), this.getSigningPrivateKey(), subject, hostname);
            this.addCertAndPrivateKey(hostname, newCert, kp.getPrivate());
            thumbprint = ThumbprintUtil.getThumbprint(newCert);
            this._subjectMap.put(subject, thumbprint);
            this.persist();
            return newCert;
        }
        return this.getCertificateByAlias(thumbprint);
    }

    private String getSubjectForHostname(String hostname) {
        String subject = "CN=" + hostname + ", OU=CyberVillians Certification Authority,O=CyberVillians.com,C=US";
        return subject;
    }

    private synchronized void persistCertMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "certmap.ser")));
            out.writeObject(this._certMap);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void persistSubjectMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "subjmap.ser")));
            out.writeObject(this._subjectMap);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public synchronized PrivateKey getPrivateKeyForLocalCert(X509Certificate cert) throws CertificateEncodingException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        String thumbprint = ThumbprintUtil.getThumbprint(cert);
        return (PrivateKey)this._ks.getKey(thumbprint, this._keypassword);
    }

    public KeyPair getRSAKeyPair() {
        KeyPair kp = this._rsaKpg.generateKeyPair();
        this.rememberKeyPair(kp);
        return kp;
    }

    public KeyPair getDSAKeyPair() {
        KeyPair kp = this._dsaKpg.generateKeyPair();
        this.rememberKeyPair(kp);
        return kp;
    }

    private synchronized void persistPublicKeyMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "pubkeymap.ser")));
            out.writeObject(this._mappedPublicKeys);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void persistKeyPairMap() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.root, "keymap.ser")));
            out.writeObject(this._rememberedPrivateKeys);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    private synchronized void rememberKeyPair(KeyPair kp) {
        this._rememberedPrivateKeys.put(kp.getPublic(), kp.getPrivate());
        this.persistKeyPairMap();
    }

    public synchronized void mapPublicKeys(PublicKey original, PublicKey substitute) {
        this._mappedPublicKeys.put(original, substitute);
        this.persistPublicKeyMap();
    }

    public synchronized PublicKey getMappedPublicKey(PublicKey original) {
        return this._mappedPublicKeys.get(original);
    }

    public synchronized PrivateKey getPrivateKey(PublicKey pk) {
        return this._rememberedPrivateKeys.get(pk);
    }

    public KeyStore getKeyStore() {
        return this._ks;
    }
}

