/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

import java.security.MessageDigest;
import net.lightbody.bmp.proxy.jetty.util.Password;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import net.lightbody.bmp.proxy.jetty.util.TypeUtil;
import net.lightbody.bmp.proxy.jetty.util.UnixCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Credential {
    private static final Logger log = LoggerFactory.getLogger(Credential.class);

    public abstract boolean check(Object var1);

    public static class MD5
    extends Credential {
        public static final String __TYPE = "MD5:";
        private static MessageDigest __md;
        private final byte[] _digest;

        MD5(String digest) {
            digest = digest.startsWith(__TYPE) ? digest.substring(__TYPE.length()) : digest;
            this._digest = TypeUtil.parseBytes(digest, 16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String digest(String password) {
            try {
                String string = __TYPE;
                synchronized (__TYPE) {
                    if (__md == null) {
                        try {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        catch (Exception e) {
                            log.warn("EXCEPTION ", (Throwable)e);
                            // ** MonitorExit[var2_1] (shouldn't be in output)
                            return null;
                        }
                    }
                    __md.reset();
                    __md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    byte[] digest = __md.digest();
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return __TYPE + TypeUtil.toString(digest, 16);
                }
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean check(Object credentials) {
            try {
                if (credentials instanceof Password || credentials instanceof String) {
                    String string = __TYPE;
                    synchronized (__TYPE) {
                        if (__md == null) {
                            __md = MessageDigest.getInstance("MD5");
                        }
                        __md.reset();
                        __md.update(credentials.toString().getBytes(StringUtil.__ISO_8859_1));
                        byte[] digest = __md.digest();
                        // ** MonitorExit[var3_2] (shouldn't be in output)
                        if (digest == null || digest.length != this._digest.length) {
                            return false;
                        }
                        for (int i = 0; i < digest.length; ++i) {
                            if (digest[i] == this._digest[i]) continue;
                            return false;
                        }
                        return true;
                    }
                }
                if (credentials instanceof MD5) {
                    MD5 md5 = (MD5)credentials;
                    if (this._digest.length != md5._digest.length) {
                        return false;
                    }
                    for (int i = 0; i < this._digest.length; ++i) {
                        if (this._digest[i] == md5._digest[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (credentials instanceof Credential) {
                    return ((Credential)credentials).check(this);
                }
                log.warn("Can't check {} against MD5", credentials.getClass());
                return false;
            }
            catch (Exception e) {
                log.warn("EXCEPTION ", (Throwable)e);
                return false;
            }
        }
    }

    public static class Crypt
    extends Credential {
        public static final String __TYPE = "CRYPT:";
        private final String _cooked;

        Crypt(String cooked) {
            this._cooked = cooked.startsWith(__TYPE) ? cooked.substring(__TYPE.length()) : cooked;
        }

        public static String crypt(String user, String pw) {
            return __TYPE + UnixCrypt.crypt(pw, user);
        }

        @Override
        public boolean check(Object credentials) {
            if (!(credentials instanceof String) && !(credentials instanceof Password)) {
                log.warn("Can't check " + credentials.getClass() + " against CRYPT");
            }
            String passwd = credentials.toString();
            return this._cooked.equals(UnixCrypt.crypt(passwd, this._cooked));
        }
    }
}

