/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.FormAuthenticator;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHandler;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHolder;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpRequest;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpResponse;

public class ServletHttpContext
extends HttpContext {
    private HashMap _localeEncodingMap = new HashMap();
    private ServletHandler _servletHandler = null;

    public ServletContext getServletContext() {
        ServletHandler shandler = this.getServletHandler();
        if (shandler != null) {
            return shandler.getServletContext();
        }
        throw new IllegalStateException();
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._servletHandler == null) {
            this._servletHandler = (ServletHandler)this.getHandler(ServletHandler.class);
        }
        if (this._servletHandler == null) {
            this._servletHandler = new ServletHandler();
            this.addHandler(this._servletHandler);
        }
        return this._servletHandler;
    }

    public synchronized ServletHolder addServlet(String pathSpec, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.addServlet(className, pathSpec, className);
    }

    public synchronized ServletHolder addServlet(String name, String pathSpec, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.getServletHandler().addServlet(name, pathSpec, className, null);
    }

    protected boolean jSecurityCheck(String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        return !(this.getAuthenticator() instanceof FormAuthenticator) || !pathInContext.endsWith("j_security_check") || this.getAuthenticator().authenticate(this.getRealm(), pathInContext, request, response) != null;
    }

    @Override
    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        return super.checkSecurityConstraints(pathInContext, request, response) && this.jSecurityCheck(pathInContext, request, response);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        String encoding = (String)this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    @Override
    public String toString() {
        return "Servlet" + super.toString();
    }

    @Override
    public void sendError(HttpResponse response, int code, String msg) throws IOException {
        Object wrapper = response.getWrapper();
        if (wrapper != null && wrapper instanceof HttpServletResponse) {
            ((HttpServletResponse)wrapper).sendError(code, msg);
        } else {
            super.sendError(response, code, msg);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this._localeEncodingMap != null) {
            this._localeEncodingMap.clear();
        }
        this._localeEncodingMap = null;
    }

    @Override
    public Object enterContextScope(HttpRequest request, HttpResponse response) {
        ServletHttpRequest srequest = (ServletHttpRequest)request.getWrapper();
        ServletHttpResponse sresponse = (ServletHttpResponse)response.getWrapper();
        if (srequest == null) {
            srequest = new ServletHttpRequest(this.getServletHandler(), null, request);
            sresponse = new ServletHttpResponse(srequest, response);
            request.setWrapper(srequest);
            response.setWrapper(sresponse);
        }
        return super.enterContextScope(request, response);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._servletHandler = null;
    }
}

