/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.proxy;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.core.util.ThreadUtils;
import net.lightbody.bmp.proxy.BrowserMobProxyHandler;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.SocketListener;
import net.lightbody.bmp.proxy.jetty.jetty.BmpServer;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.proxy.RequestInterceptor;
import website.magyar.mitm.proxy.ResponseInterceptor;

public class ProxyServer {
    protected static final Logger logger = LoggerFactory.getLogger(ProxyServer.class);
    private static final HarNameVersion CREATOR = new HarNameVersion("Mitm Java Proxy", "0.0");
    public static int PROXY_TIMEOUT = 240000;
    private static Boolean responseVolatile = Boolean.FALSE;
    private static Boolean shouldKeepSslConnectionAlive = Boolean.FALSE;
    private final AtomicInteger requestCounter = new AtomicInteger(0);
    private BmpServer bmpServer;
    private int port = -1;
    private BrowserMobHttpClient client;
    private HarPage currentPage;
    private BrowserMobProxyHandler handler;
    private int pageCount = 1;

    public ProxyServer() {
    }

    public ProxyServer(int port) {
        this.port = port;
    }

    public static Boolean getResponseVolatile() {
        return responseVolatile;
    }

    public static void setResponseVolatile(Boolean responseVolatile) {
        ProxyServer.responseVolatile = responseVolatile;
    }

    public static Boolean getShouldKeepSslConnectionAlive() {
        return shouldKeepSslConnectionAlive;
    }

    public static void setShouldKeepSslConnectionAlive(Boolean shouldKeepSslConnectionAlive) {
        ProxyServer.shouldKeepSslConnectionAlive = shouldKeepSslConnectionAlive;
    }

    public void start(int requestTimeOut) throws Exception {
        if (this.port == -1) {
            throw new IllegalStateException("Must set port before starting");
        }
        PROXY_TIMEOUT = requestTimeOut;
        this.bmpServer = new BmpServer();
        SocketListener listener = new SocketListener(new InetAddrPort(this.getPort()));
        this.bmpServer.addListener(listener);
        HttpContext context = new HttpContext();
        context.setContextPath("/");
        this.bmpServer.addContext(context);
        this.handler = new BrowserMobProxyHandler();
        this.handler.setJettyServer(this.bmpServer);
        this.handler.setShutdownLock(new Object());
        this.client = new BrowserMobHttpClient(this.requestCounter, requestTimeOut);
        this.client.prepareForBrowser();
        this.handler.setHttpClient(this.client);
        context.addHandler(this.handler);
        this.bmpServer.start();
        this.setPort(listener.getPort());
    }

    public void cleanup() {
        this.handler.cleanup();
    }

    public void stop() throws Exception {
        this.cleanup();
        this.client.shutdown();
        this.bmpServer.stop();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Har getHar() {
        boolean success = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                return ProxyServer.this.requestCounter.get() == 0;
            }
        }, TimeUnit.SECONDS, 5L);
        if (!success) {
            logger.warn("Waited 5 seconds for requests to cease before returning HAR; giving up!");
        }
        return this.client.getHar();
    }

    public Har newHar(String initialPageRef) {
        this.pageCount = 1;
        Har oldHar = this.getHar();
        Har har = new Har(new HarLog(CREATOR));
        this.client.setHar(har);
        this.newPage(initialPageRef);
        return oldHar;
    }

    public void newPage(String pageRef) {
        if (pageRef == null) {
            pageRef = "Page " + this.pageCount;
        }
        this.client.setHarPageRef((String)pageRef);
        this.currentPage = new HarPage((String)pageRef);
        this.client.getHar().getLog().addPage(this.currentPage);
        ++this.pageCount;
    }

    public void addRequestInterceptor(RequestInterceptor interceptor) {
        this.client.addRequestInterceptor(interceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        this.client.addResponseInterceptor(interceptor);
    }

    public void setRequestTimeout(int requestTimeout) {
        this.client.setRequestTimeout(requestTimeout);
    }

    public void rewriteUrl(String match, String replace) {
        this.client.rewriteUrl(match, replace);
    }

    public void addHeader(String name, String value) {
        this.client.addHeader(name, value);
    }

    public void setCaptureHeaders(boolean captureHeaders) {
        this.client.setCaptureHeaders(captureHeaders);
    }

    public void setCaptureContent(boolean captureContent) {
        this.client.setCaptureContent(captureContent);
    }

    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        this.client.setCaptureBinaryContent(captureBinaryContent);
    }

    public void clearDNSCache() {
        this.client.clearDNSCache();
    }

    public void setDNSCacheTimeout(int timeout) {
        this.client.setDNSCacheTimeout(timeout);
    }

    public void waitForNetworkTrafficToStop(final long quietPeriodInMs, long timeoutInMs) {
        boolean result = ThreadUtils.waitFor(new ThreadUtils.WaitCondition(){

            @Override
            public boolean checkCondition(long elapsedTimeInMs) {
                Date lastCompleted = null;
                Har har = ProxyServer.this.client.getHar();
                if (har == null || har.getLog() == null) {
                    return true;
                }
                for (HarEntry entry : har.getLog().getEntries()) {
                    if (entry.getResponse().getStatus() < 0) {
                        return false;
                    }
                    Date end = new Date(entry.getStartedDateTime().getTime() + entry.getTime());
                    if (lastCompleted == null) {
                        lastCompleted = end;
                        continue;
                    }
                    if (!end.after(lastCompleted)) continue;
                    lastCompleted = end;
                }
                return lastCompleted != null && System.currentTimeMillis() - lastCompleted.getTime() >= quietPeriodInMs;
            }
        }, TimeUnit.MILLISECONDS, timeoutInMs);
        if (!result) {
            throw new RuntimeException("Timed out after " + timeoutInMs + " ms while waiting for network traffic to stop");
        }
    }

    public void setOptions(Map<String, String> options) {
        if (options.containsKey("httpProxy")) {
            this.client.setHttpProxy(options.get("httpProxy"));
        }
    }
}

