/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ClonedOutputStream
extends OutputStream {
    private OutputStream os;
    private ByteArrayOutputStream copy = new ByteArrayOutputStream();

    public ClonedOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        this.copy.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.copy.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.copy.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
        this.copy.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.copy.close();
    }

    public ByteArrayOutputStream getOutput() {
        return this.copy;
    }
}

