/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import net.lightbody.bmp.proxy.jetty.http.HttpConnection;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.http.HttpTunnel;
import net.lightbody.bmp.proxy.jetty.http.SslListener;
import net.lightbody.bmp.proxy.jetty.http.handler.AbstractHttpHandler;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;
import net.lightbody.bmp.proxy.jetty.util.StringMap;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.selenium.KeyStoreManager;
import net.lightbody.bmp.proxy.selenium.LauncherUtils;
import net.lightbody.bmp.proxy.selenium.ModifiedIO;
import net.lightbody.bmp.proxy.util.ResourceExtractor;
import net.lightbody.bmp.proxy.util.TrustEverythingSSLTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.proxy.ProxyServer;

public class SeleniumProxyHandler
extends AbstractHttpHandler {
    private final Logger log = LoggerFactory.getLogger(SeleniumProxyHandler.class);
    private final Map<String, SslRelay> _sslMap = new LinkedHashMap<String, SslRelay>();
    private final boolean proxyInjectionMode;
    private final boolean forceProxyChain;
    protected Set<String> _proxyHostsWhiteList;
    protected Set<String> _proxyHostsBlackList;
    protected int _tunnelTimeoutMs = 60000;
    protected StringMap _DontProxyHeaders = new StringMap();
    protected StringMap _ProxyAuthHeaders = new StringMap();
    protected StringMap _ProxySchemes = new StringMap();
    private boolean _anonymous = false;
    private transient boolean _chained = false;
    private String sslKeystorePath;
    private boolean useCyberVillains = true;
    private boolean trustAllSSLCertificates = false;
    private Object shutdownLock;

    public SeleniumProxyHandler(boolean trustAllSSLCertificates, boolean proxyInjectionMode, boolean forceProxyChain) {
        Object o = new Object();
        this._DontProxyHeaders.setIgnoreCase(true);
        this._DontProxyHeaders.put("Proxy-Connection", o);
        this._DontProxyHeaders.put("Connection", o);
        this._DontProxyHeaders.put("keep-alive", o);
        this._DontProxyHeaders.put("Transfer-Encoding", o);
        this._DontProxyHeaders.put("TE", o);
        this._DontProxyHeaders.put("Trailer", o);
        this._DontProxyHeaders.put("Upgrade", o);
        o = new Object();
        this._ProxyAuthHeaders.put("Proxy-Authorization", o);
        this._ProxyAuthHeaders.put("Proxy-Authenticate", o);
        o = new Object();
        this._ProxySchemes.setIgnoreCase(true);
        this._ProxySchemes.put("http", o);
        this._ProxySchemes.put("https", o);
        this._ProxySchemes.put("ftp", o);
        this.trustAllSSLCertificates = trustAllSSLCertificates;
        this.proxyInjectionMode = proxyInjectionMode;
        this.forceProxyChain = forceProxyChain;
    }

    @Override
    public void start() throws Exception {
        this._chained = System.getProperty("http.proxyHost") != null || this.forceProxyChain;
        super.start();
    }

    public int getTunnelTimeoutMs() {
        return this._tunnelTimeoutMs;
    }

    public void setTunnelTimeoutMs(int ms) {
        this._tunnelTimeoutMs = ms;
    }

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        block11: {
            URI uri = request.getURI();
            if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
                if (!ProxyServer.getShouldKeepSslConnectionAlive().booleanValue()) {
                    response.setField("Connection", "close");
                }
                this.handleConnect(pathInContext, pathParams, request, response);
                return;
            }
            try {
                if ("True".equals(response.getAttribute("NotFound"))) {
                    response.removeAttribute("NotFound");
                    this.sendNotFound(response);
                    return;
                }
                URL url = this.isProxied(uri);
                if (url == null) {
                    if (this.isForbidden(uri)) {
                        this.sendForbid(request, response, uri);
                    }
                    return;
                }
                if (this.isSeleniumUrl(url.toString())) {
                    request.setHandled(false);
                    return;
                }
                this.proxyPlainTextRequest(url, pathInContext, pathParams, request, response);
            }
            catch (UnknownHostException e) {
                this.log.info("Couldn't proxy to {} because host not found", (Object)uri);
                response.setStatus(400);
                String host = uri.getHost();
                response.setReason("Host " + host + " not found");
                OutputStreamWriter out = new OutputStreamWriter(response.getOutputStream());
                out.write("<html><head><title>Problem loading page</title></head><body style=\"background-color:#F0F0F0; font-family: sans-serif\"><div style=\"margin:auto; margin-top: 3em;width:600px; background-color:#FFF; padding:30px;border: 1px solid #DDD\"><h1 style=\"font-size: 18px;border-bottom:thin solid #DDD\">Server not found</h1><p style=\"border-bottom: 1px solid #DDD; padding-bottom: 20px\">Selenium can't find the server at " + host + "</p><ul style=\"list-style: square outside none;font-size:13px\"><li style=\"margin-bottom:6px;\">Check the address for typing errors such as ww.example.com instead of www.example.com</li><li style=\"margin-bottom:6px;\">If you are unable to load any pages, check your computer's network connection.</li><li style=\"margin-bottom:6px;\">If your computer or network is protected by a firewall or proxy, make sure that your browser is permitted to access the Web.</li></ul></div></body>");
                out.close();
                response.getOutputStream().close();
            }
            catch (ConnectException e) {
                this.log.info("Couldn't proxy to {} because host not listening", (Object)uri);
                response.setStatus(400);
                Object host = uri.getHost();
                if (uri.getPort() > 0) {
                    host = (String)host + ":" + uri.getPort();
                }
                response.setReason("Couldn't connect to " + (String)host);
                OutputStreamWriter out = new OutputStreamWriter(response.getOutputStream());
                out.write("<html><head><title>Problem loading page</title></head><body style=\"background-color:#F0F0F0; font-family: sans-serif\"><div style=\"margin:auto; margin-top: 3em;width:600px; background-color:#FFF; padding:30px;border: 1px solid #DDD\"><h1 style=\"font-size: 18px;border-bottom:thin solid #DDD\">Unable to connect</h1><p style=\"border-bottom: 1px solid #DDD; padding-bottom: 20px\">Selenium can't establish a connection to the server at " + (String)host + "</p><ul style=\"list-style: square outside none;font-size:13px\"><li style=\"margin-bottom:6px;\">The site could be temporarily unavailable or too busy. Try again in a few moments.</li><li style=\"margin-bottom:6px;\">If you are unable to load any pages, check your computer's network connection.</li><li style=\"margin-bottom:6px;\">If your computer or network is protected by a firewall or proxy, make sure that your browser is permitted to access the Web.</li></ul></div></body>");
                out.close();
                response.getOutputStream().close();
            }
            catch (Exception e) {
                this.log.debug("Could not proxy {}", (Object)uri, (Object)e);
                if (response.isCommitted()) break block11;
                response.sendError(400, "Could not proxy " + uri + "\n" + e);
            }
        }
    }

    private boolean isSeleniumUrl(String url) {
        int slashSlash = url.indexOf("//");
        if (slashSlash == -1) {
            return false;
        }
        int nextSlash = url.indexOf("/", slashSlash + 2);
        if (nextSlash == -1) {
            return false;
        }
        int seleniumServer = url.indexOf("/selenium-server/");
        if (seleniumServer == -1) {
            return false;
        }
        return seleniumServer == nextSlash;
    }

    protected long proxyPlainTextRequest(URL url, String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws IOException {
        String cache_control;
        String connectionHdr;
        this.log.debug("PROXY URL={}", (Object)url);
        URLConnection connection = url.openConnection();
        if (System.getProperty("http.proxyHost") != null && System.getProperty("https.proxyHost") == null && "https".equals(url.getProtocol())) {
            String proxyHost = System.getProperty("http.proxyHost");
            int proxyPort = Integer.getInteger("http.proxyPort");
            InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
            connection = url.openConnection(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        connection.setAllowUserInteraction(false);
        if (this.proxyInjectionMode) {
            this.adjustRequestForProxyInjection(request, connection);
        }
        HttpURLConnection http = null;
        if (connection instanceof HttpURLConnection) {
            http = (HttpURLConnection)connection;
            http.setRequestMethod(request.getMethod());
            http.setInstanceFollowRedirects(false);
            if (this.trustAllSSLCertificates && connection instanceof HttpsURLConnection) {
                TrustEverythingSSLTrustManager.trustAllSSLCertificates((HttpsURLConnection)connection);
            }
        }
        if ((connectionHdr = request.getField("Connection")) != null && (connectionHdr.equalsIgnoreCase("keep-alive") || connectionHdr.equalsIgnoreCase("close"))) {
            connectionHdr = null;
        }
        boolean xForwardedFor = false;
        boolean isGet = "GET".equals(request.getMethod());
        boolean hasContent = false;
        Enumeration enm = request.getFieldNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            if (this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr) || connectionHdr != null && connectionHdr.indexOf(hdr) >= 0) continue;
            if (!isGet && "Content-Type".equals(hdr)) {
                hasContent = true;
            }
            Enumeration vals = request.getFieldValues(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null || "Referer".equals(hdr) && val.contains("/selenium-server/")) continue;
                if (!isGet && "Content-Length".equals(hdr) && Integer.parseInt(val) > 0) {
                    hasContent = true;
                }
                connection.addRequestProperty(hdr, val);
                xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
            }
        }
        if (!this._anonymous) {
            connection.setRequestProperty("Via", "1.1 (jetty)");
        }
        if (!xForwardedFor) {
            connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
        }
        if ((cache_control = request.getField("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
            connection.setUseCaches(false);
        }
        this.customizeConnection(pathInContext, pathParams, request, connection);
        try {
            connection.setDoInput(true);
            InputStream in = request.getInputStream();
            if (hasContent) {
                connection.setDoOutput(true);
                IO.copy(in, connection.getOutputStream());
            }
            connection.connect();
        }
        catch (Exception in) {
            // empty catch block
        }
        InputStream proxy_in = null;
        int code = -1;
        if (http != null) {
            proxy_in = http.getErrorStream();
            try {
                code = http.getResponseCode();
            }
            catch (SSLHandshakeException e) {
                throw new RuntimeException("Couldn't establish SSL handshake.  Try using trustAllSSLCertificates.\n" + e.getLocalizedMessage(), e);
            }
            response.setStatus(code);
            response.setReason(http.getResponseMessage());
            String contentType = http.getContentType();
            this.log.debug("Content-Type is: {}", (Object)contentType);
        }
        if (proxy_in == null) {
            try {
                proxy_in = connection.getInputStream();
            }
            catch (Exception e) {
                proxy_in = http.getErrorStream();
            }
        }
        response.removeField("Date");
        response.removeField("Server");
        int h = 0;
        String hdr = connection.getHeaderFieldKey(h);
        String val = connection.getHeaderField(h);
        while (hdr != null || val != null) {
            if (!(hdr == null || val == null || this._DontProxyHeaders.containsKey(hdr) || !this._chained && this._ProxyAuthHeaders.containsKey(hdr))) {
                response.addField(hdr, val);
            }
            hdr = connection.getHeaderFieldKey(++h);
            val = connection.getHeaderField(h);
        }
        if (!this._anonymous) {
            response.setField("Via", "1.1 (jetty)");
        }
        response.removeField("ETag");
        response.removeField("Last-Modified");
        long bytesCopied = -1L;
        request.setHandled(true);
        if (proxy_in != null) {
            bytesCopied = ModifiedIO.copy(proxy_in, response.getOutputStream());
        }
        return bytesCopied;
    }

    private void adjustRequestForProxyInjection(HttpRequest request, URLConnection connection) {
        request.setState(0);
        if (request.containsField("If-Modified-Since")) {
            request.removeField("If-Modified-Since");
            request.removeField("If-None-Match");
            connection.setUseCaches(false);
        }
        request.removeField("Accept-Encoding");
        request.setState(2);
    }

    public void handleConnect(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        URI uri = request.getURI();
        try {
            this.log.debug("CONNECT: {}", (Object)uri);
            InetAddrPort addrPort = uri.toString().endsWith(".selenium.doesnotexist:443") ? new InetAddrPort(443) : new InetAddrPort(uri.toString());
            if (this.isForbidden("https", addrPort.getHost(), addrPort.getPort(), false)) {
                this.sendForbid(request, response, uri);
            } else {
                HttpTunnel tunnel;
                HttpConnection http_connection = request.getHttpConnection();
                if (!ProxyServer.getShouldKeepSslConnectionAlive().booleanValue()) {
                    http_connection.forceClose();
                }
                HttpServer server = http_connection.getHttpServer();
                SslRelay listener = this.getSslRelayOrCreateNew(uri, addrPort, server);
                int port = listener.getPort();
                int timeoutMs = 30000;
                Object maybesocket = http_connection.getConnection();
                if (maybesocket instanceof Socket) {
                    Socket s = (Socket)maybesocket;
                    timeoutMs = s.getSoTimeout();
                }
                if ((tunnel = this.newHttpTunnel(request, response, InetAddress.getByName(null), port, timeoutMs)) != null) {
                    if (this._tunnelTimeoutMs > 0) {
                        tunnel.getSocket().setSoTimeout(this._tunnelTimeoutMs);
                        if (maybesocket instanceof Socket) {
                            Socket s = (Socket)maybesocket;
                            s.setSoTimeout(this._tunnelTimeoutMs);
                        }
                    }
                    tunnel.setTimeoutMs(timeoutMs);
                    this.customizeConnection(pathInContext, pathParams, request, tunnel.getSocket());
                    request.getHttpConnection().setHttpTunnel(tunnel);
                    response.setStatus(200);
                    response.setContentLength(0);
                }
                request.setHandled(true);
            }
        }
        catch (Exception e) {
            this.log.debug("error during handleConnect", (Throwable)e);
            response.sendError(500, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SslRelay getSslRelayOrCreateNew(URI uri, InetAddrPort addrPort, HttpServer server) throws Exception {
        SslRelay listener;
        Map<String, SslRelay> map = this._sslMap;
        synchronized (map) {
            listener = this._sslMap.get(uri.toString());
            if (listener == null) {
                String host = new URL("https://" + uri.toString()).getHost();
                listener = new SslRelay(addrPort);
                if (this.useCyberVillains) {
                    this.wireUpSslWithCyberVilliansCA(host, listener);
                } else {
                    this.wireUpSslWithRemoteService(host, listener);
                }
                listener.setPassword("password");
                listener.setKeyPassword("password");
                server.addListener(listener);
                Object object = this.shutdownLock;
                synchronized (object) {
                    try {
                        if (!server.isStarted()) {
                            throw new RuntimeException("Can't start SslRelay: server is not started (perhaps it was just shut down?)");
                        }
                        listener.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                this._sslMap.put(uri.toString(), listener);
            }
        }
        return listener;
    }

    protected void wireUpSslWithRemoteService(String host, SslRelay listener) throws IOException {
        int length;
        File keystore = File.createTempFile("selenium-rc-" + host, "keystore");
        String urlString = "http://dangerous-certificate-authority.openqa.org/genkey.jsp?padding=" + this._sslMap.size() + "&domain=" + host;
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream is = conn.getInputStream();
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(keystore);
        while ((length = is.read(buffer)) != -1) {
            fos.write(buffer, 0, length);
        }
        fos.close();
        is.close();
        listener.setKeystore(keystore.getAbsolutePath());
        listener.setNukeDirOrFile(keystore);
    }

    protected void wireUpSslWithCyberVilliansCA(String host, SslRelay listener) {
        try {
            File root = File.createTempFile("seleniumSslSupport", host);
            root.delete();
            root.mkdirs();
            ResourceExtractor.extractResourcePath(this.getClass(), "/sslSupport", root);
            KeyStoreManager mgr = new KeyStoreManager(root);
            mgr.getCertificateByHostname(host);
            mgr.getKeyStore().deleteEntry("signingCertPrivKey");
            mgr.persist();
            listener.setKeystore(new File(root, "cybervillainsCA.jks").getAbsolutePath());
            listener.setNukeDirOrFile(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpTunnel newHttpTunnel(HttpRequest request, HttpResponse response, InetAddress iaddr, int port, int timeoutMS) throws IOException {
        try {
            Socket socket = new Socket(iaddr, port);
            socket.setSoTimeout(timeoutMS);
            socket.setTcpNoDelay(true);
            return new HttpTunnel(socket);
        }
        catch (IOException e) {
            this.log.debug("Exception thrown", (Throwable)e);
            response.sendError(400);
            return null;
        }
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, Socket socket) {
    }

    protected void customizeConnection(String pathInContext, String pathParams, HttpRequest request, URLConnection connection) {
    }

    protected URL isProxied(URI uri) throws MalformedURLException {
        if (this.isForbidden(uri)) {
            return null;
        }
        return new URL(uri.toString());
    }

    protected boolean isForbidden(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return this.isForbidden(scheme, host, port, true);
    }

    protected boolean isForbidden(String scheme, String host, int port, boolean openNonPrivPorts) {
        if (scheme == null || !this._ProxySchemes.containsKey(scheme)) {
            return true;
        }
        if (this._proxyHostsWhiteList != null && !this._proxyHostsWhiteList.contains(host)) {
            return true;
        }
        return this._proxyHostsBlackList != null && this._proxyHostsBlackList.contains(host);
    }

    protected void sendForbid(HttpRequest request, HttpResponse response, URI uri) throws IOException {
        response.sendError(403, "Forbidden for Proxy @691");
    }

    protected void sendNotFound(HttpResponse response) throws IOException {
        response.sendError(404, "Not found");
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this._anonymous = anonymous;
    }

    public void setSslKeystorePath(String sslKeystorePath) {
        this.sslKeystorePath = sslKeystorePath;
    }

    public void setShutdownLock(Object shutdownLock) {
        this.shutdownLock = shutdownLock;
    }

    public static class SslRelay
    extends SslListener {
        InetAddrPort _addr;
        File nukeDirOrFile;

        SslRelay(InetAddrPort addr) {
            this._addr = addr;
        }

        public void setNukeDirOrFile(File nukeDirOrFile) {
            this.nukeDirOrFile = nukeDirOrFile;
        }

        @Override
        protected void customizeRequest(Socket socket, HttpRequest request) {
            super.customizeRequest(socket, request);
            URI uri = request.getURI();
            request.setURI(new URI("https://" + this._addr.getHost() + ":" + this._addr.getPort() + uri.toString()));
        }

        @Override
        public void stop() throws InterruptedException {
            super.stop();
            if (this.nukeDirOrFile != null) {
                if (this.nukeDirOrFile.isDirectory()) {
                    LauncherUtils.recursivelyDeleteDir(this.nukeDirOrFile);
                } else {
                    this.nukeDirOrFile.delete();
                }
            }
        }
    }
}

