/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.util;

import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CappedByteArrayOutputStream
extends ByteArrayOutputStream {
    protected static final Logger logger = LoggerFactory.getLogger(CappedByteArrayOutputStream.class);
    private int maxBytes;
    private boolean writeable = true;

    public CappedByteArrayOutputStream(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public void write(int b) {
        if (this.writeable) {
            super.write(b);
            this.checkWritable();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.writeable) {
            super.write(b, off, len);
            this.checkWritable();
        }
    }

    private void checkWritable() {
        if (this.count > this.maxBytes) {
            this.writeable = false;
            logger.warn("BUFFER OVERLOAD!");
        }
    }
}

