/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    private static final long __hitWindow = 3600L;
    private static final long __MaxMisses = 10L;
    private final String _formatString;
    private String _tzFormatString;
    private SimpleDateFormat _tzFormat;
    private String _minFormatString;
    private SimpleDateFormat _minFormat;
    private String _secFormatString;
    private String _secFormatString0;
    private String _secFormatString1;
    private boolean _millis = false;
    private long _misses = 0L;
    private long _lastMinutes = -1L;
    private long _lastSeconds = -1L;
    private String _lastResult = null;
    private final Locale _locale;

    public DateCache(String format, Locale l) {
        this._formatString = format;
        this._locale = l;
        this.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeZone(TimeZone tz) {
        this.setTzFormatString(tz);
        if (this._locale != null) {
            this._tzFormat = new SimpleDateFormat(this._tzFormatString, this._locale);
            this._minFormat = new SimpleDateFormat(this._minFormatString, this._locale);
        } else {
            this._tzFormat = new SimpleDateFormat(this._tzFormatString);
            this._minFormat = new SimpleDateFormat(this._minFormatString);
        }
        this._tzFormat.setTimeZone(tz);
        this._minFormat.setTimeZone(tz);
        this._lastSeconds = -1L;
        this._lastMinutes = -1L;
    }

    private void setTzFormatString(TimeZone tz) {
        int zIndex = this._formatString.indexOf("ZZZ");
        if (zIndex >= 0) {
            String ss1 = this._formatString.substring(0, zIndex);
            String ss2 = this._formatString.substring(zIndex + 3);
            int tzOffset = tz.getRawOffset();
            StringBuffer sb = new StringBuffer(this._formatString.length() + 10);
            sb.append(ss1);
            sb.append("'");
            if (tzOffset >= 0) {
                sb.append('+');
            } else {
                tzOffset = -tzOffset;
                sb.append('-');
            }
            int raw = tzOffset / 60000;
            int hr = raw / 60;
            int min = raw % 60;
            if (hr < 10) {
                sb.append('0');
            }
            sb.append(hr);
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
            sb.append('\'');
            sb.append(ss2);
            this._tzFormatString = sb.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this.setMinFormatString();
    }

    private void setMinFormatString() {
        int i = this._tzFormatString.indexOf("ss.SSS");
        int l = 6;
        if (i >= 0) {
            this._millis = true;
        } else {
            i = this._tzFormatString.indexOf("ss");
            l = 2;
        }
        String ss1 = this._tzFormatString.substring(0, i);
        String ss2 = this._tzFormatString.substring(i + l);
        this._minFormatString = ss1 + (this._millis ? "'ss.SSS'" : "'ss'") + ss2;
    }

    public synchronized String format(Date inDate) {
        return this.format(inDate.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String format(long inDate) {
        StringBuffer sb;
        long seconds = inDate / 1000L;
        if (seconds < this._lastSeconds || this._lastSeconds > 0L && seconds > this._lastSeconds + 3600L) {
            ++this._misses;
            if (this._misses < 10L) {
                Date d = new Date(inDate);
                return this._tzFormat.format(d);
            }
        } else if (this._misses > 0L) {
            --this._misses;
        }
        if (this._lastSeconds == seconds && !this._millis) {
            return this._lastResult;
        }
        Date d = new Date(inDate);
        long minutes = seconds / 60L;
        if (this._lastMinutes != minutes) {
            int l;
            int i;
            this._lastMinutes = minutes;
            this._secFormatString = this._minFormat.format(d);
            if (this._millis) {
                i = this._secFormatString.indexOf("ss.SSS");
                l = 6;
            } else {
                i = this._secFormatString.indexOf("ss");
                l = 2;
            }
            this._secFormatString0 = this._secFormatString.substring(0, i);
            this._secFormatString1 = this._secFormatString.substring(i + l);
        }
        this._lastSeconds = seconds;
        StringBuffer stringBuffer = sb = new StringBuffer(this._secFormatString.length());
        synchronized (stringBuffer) {
            sb.append(this._secFormatString0);
            int s = (int)(seconds % 60L);
            if (s < 10) {
                sb.append('0');
            }
            sb.append(s);
            if (this._millis) {
                long millis = inDate % 1000L;
                if (millis < 10L) {
                    sb.append(".00");
                } else if (millis < 100L) {
                    sb.append(".0");
                } else {
                    sb.append('.');
                }
                sb.append(millis);
            }
            sb.append(this._secFormatString1);
            this._lastResult = sb.toString();
        }
        return this._lastResult;
    }

    public void format(long inDate, StringBuffer buffer) {
        buffer.append(this.format(inDate));
    }

    public SimpleDateFormat getFormat() {
        return this._minFormat;
    }
}

