/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpServer;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmpServer
extends HttpServer {
    private static final Logger log = LoggerFactory.getLogger(BmpServer.class);
    private String _configuration;

    @Override
    protected HttpContext newHttpContext() {
        return new ServletHttpContext();
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                try {
                    Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
                    shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                    this.hooked = true;
                }
                catch (Exception e) {
                    log.debug("No shutdown hook in JVM ", (Throwable)e);
                }
            }
        }

        public boolean add(BmpServer bmpServer) {
            this.createShutdownHook();
            return this.servers.add(bmpServer);
        }

        public boolean contains(BmpServer bmpServer) {
            return this.servers.contains(bmpServer);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(BmpServer bmpServer) {
            this.createShutdownHook();
            return this.servers.remove(bmpServer);
        }

        @Override
        public void run() {
            this.setName("Shutdown");
            log.info("Shutdown hook executing");
            for (BmpServer svr : this.servers) {
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", (Throwable)e);
                }
                log.info("Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    log.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
    }
}

