/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatedSocketFactory
implements ConnectionSocketFactory {
    protected static final Logger logger = LoggerFactory.getLogger(SimulatedSocketFactory.class);
    private static Method getHostMethod;
    private HostNameResolver hostNameResolver;
    private int requestTimeout;

    public SimulatedSocketFactory(HostNameResolver hostNameResolver, int requestTimeout) {
        assert (hostNameResolver != null);
        this.hostNameResolver = hostNameResolver;
        this.requestTimeout = requestTimeout;
    }

    private void configureSocket(Socket socket) {
        try {
            socket.setReuseAddress(true);
            socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String resolveHostName(InetSocketAddress remoteAddress) {
        String hostString = null;
        try {
            hostString = (String)getHostMethod.invoke((Object)remoteAddress, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Expecting InetSocketAddress to have a package scoped \"getHostString\" method which returns a String and takes no input");
        }
        return hostString;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        Socket newSocket = new Socket(){

            @Override
            public void connect(SocketAddress endpoint) throws IOException {
                super.connect(endpoint);
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                super.connect(endpoint, timeout);
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return super.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return super.getOutputStream();
            }
        };
        this.configureSocket(newSocket);
        return newSocket;
    }

    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Target host may not be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Context may not be null.");
        }
        if (sock == null) {
            sock = this.createSocket(null);
        }
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        String hostName = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost().getHostName() : this.resolveHostName(remoteAddress);
        InetSocketAddress remoteAddr = remoteAddress;
        if (this.hostNameResolver != null) {
            remoteAddr = new InetSocketAddress(this.hostNameResolver.resolve(hostName), remoteAddress.getPort());
        }
        try {
            sock.connect(remoteAddr, connectTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out");
        }
        return sock;
    }

    static {
        try {
            getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
            if (!Modifier.isPublic(getHostMethod.getModifiers())) {
                getHostMethod = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (getHostMethod == null) {
            try {
                getHostMethod = InetSocketAddress.class.getDeclaredMethod("getHostName", new Class[0]);
                logger.warn("Using InetSocketAddress.getHostName() rather than InetSocketAddress.getHostString(). Consider upgrading to Java 7 for faster performance!");
            }
            catch (NoSuchMethodException e) {
                String msg = "Something is wrong inside SimulatedSocketFactory and I don't know why!";
                logger.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        getHostMethod.setAccessible(true);
    }
}

