/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.lightbody.bmp.proxy.http.RequestInfo;
import org.apache.http.conn.scheme.HostNameResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public class BrowserMobHostNameResolver
implements HostNameResolver {
    protected final Logger logger = LoggerFactory.getLogger(BrowserMobHostNameResolver.class);
    private final Map<String, String> remappings = new ConcurrentHashMap<String, String>();
    private final Map<String, List<String>> reverseMapping = new ConcurrentHashMap<String, List<String>>();
    private Cache cache;
    private Resolver resolver;

    public BrowserMobHostNameResolver(Cache cache) {
        this.cache = cache;
        this.resolver = new ExtendedResolver();
        this.remappings.put("localhost", "127.0.0.1");
    }

    public InetAddress resolve(String hostname) throws IOException {
        String remapping = this.remappings.get(hostname);
        if (remapping != null) {
            hostname = remapping;
        }
        try {
            return Address.getByAddress((String)hostname);
        }
        catch (UnknownHostException unknownHostException) {
            boolean isCached = this.isCached(hostname);
            Lookup lookup = new Lookup(Name.fromString((String)hostname), 1);
            lookup.setCache(this.cache);
            lookup.setResolver(this.resolver);
            Date start = new Date();
            Record[] records = lookup.run();
            Date end = new Date();
            if (records == null || records.length == 0) {
                throw new UnknownHostException(hostname);
            }
            ARecord a = (ARecord)records[0];
            InetAddress addr = InetAddress.getByAddress(hostname, a.getAddress().getAddress());
            if (!isCached) {
                RequestInfo.get().dns(start, end, addr.getHostAddress());
            } else {
                RequestInfo.get().dns(end, end, addr.getHostAddress());
            }
            return addr;
        }
    }

    public void remap(String source, String target) {
        this.remappings.put(source, target);
        List<String> list = this.reverseMapping.get(target);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(source);
        this.reverseMapping.put(target, list);
    }

    public String remapping(String host) {
        return this.remappings.get(host);
    }

    public List<String> original(String host) {
        return this.reverseMapping.get(host);
    }

    public void clearCache() {
        this.cache.clearCache();
    }

    public void setCacheTimeout(int timeout) {
        this.cache.setMaxCache(timeout);
    }

    public boolean isCached(String hostname) throws TextParseException {
        return this.cache.lookupRecords(Name.fromString((String)hostname), 255, 3).isSuccessful();
    }

    public void addHostToCacheAs(String hostname, String ipAddress) throws UnknownHostException, TextParseException {
        Name host = new Name(hostname + ".");
        ARecord aRec = new ARecord(host, 1, 9999999L, this.getInetAddressFromString(ipAddress));
        Lookup.getDefaultCache((int)1).addRecord((Record)aRec, 3);
    }

    private InetAddress getInetAddressFromString(String ip) throws UnknownHostException {
        byte[] bytes = new byte[4];
        String[] ipParts = ip.split("\\.");
        InetAddress addr = null;
        if (ipParts.length <= 1) {
            addr = InetAddress.getByName(ip);
        } else {
            for (int i = 0; i < ipParts.length; ++i) {
                bytes[i] = Byte.parseByte(ipParts[i]);
            }
            addr = InetAddress.getByAddress(bytes);
        }
        return addr;
    }
}

