/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import android.util.AndroidRuntimeException;
import com.whl.quickjs.wrapper.JSArray;
import com.whl.quickjs.wrapper.JSObject;
import com.whl.quickjs.wrapper.NativeCleaner;

public class QuickJSContext {
    private static final String UNKNOWN_FILE = "unknown.js";
    private final long context;
    private final NativeCleaner<JSObject> nativeCleaner = new NativeCleaner<JSObject>(){

        @Override
        public void onRemove(long pointer) {
            QuickJSContext.this.freeDupValue(QuickJSContext.this.context, pointer);
        }
    };
    private final long currentThreadId;

    public static QuickJSContext create() {
        return new QuickJSContext();
    }

    public static QuickJSContext create(int maxStackSize) {
        QuickJSContext context = QuickJSContext.create();
        context.setMaxStackSize(maxStackSize);
        return context;
    }

    private QuickJSContext() {
        this.context = this.createContext();
        this.currentThreadId = Thread.currentThread().getId();
    }

    private void checkSameThread() {
        boolean isSameThread;
        boolean bl = isSameThread = this.currentThreadId == Thread.currentThread().getId();
        if (!isSameThread) {
            throw new AndroidRuntimeException("Must be call same thread in QuickJSContext.create!");
        }
    }

    public Object evaluate(String script) {
        return this.evaluate(script, UNKNOWN_FILE);
    }

    public Object evaluate(String script, String fileName) {
        this.checkSameThread();
        return this.evaluate(this.context, script, fileName);
    }

    public JSObject getGlobalObject() {
        this.checkSameThread();
        return this.getGlobalObject(this.context);
    }

    public void destroyContext() {
        this.checkSameThread();
        this.nativeCleaner.forceClean();
        this.destroyContext(this.context);
    }

    public String stringify(JSObject jsObj) {
        this.checkSameThread();
        return this.stringify(this.context, jsObj.getPointer());
    }

    public Object getProperty(JSObject jsObj, String name) {
        this.checkSameThread();
        return this.getProperty(this.context, jsObj.getPointer(), name);
    }

    public void setProperty(JSObject jsObj, String name, Object value) {
        this.checkSameThread();
        this.setProperty(this.context, jsObj.getPointer(), name, value);
    }

    public void freeValue(JSObject jsObj) {
        this.checkSameThread();
        this.freeValue(this.context, jsObj.getPointer());
    }

    private void dupValue(JSObject jsObj) {
        this.checkSameThread();
        this.dupValue(this.context, jsObj.getPointer());
    }

    private void freeDupValue(JSObject jsObj) {
        this.checkSameThread();
        this.freeDupValue(this.context, jsObj.getPointer());
    }

    public int length(JSArray jsArray) {
        this.checkSameThread();
        return this.length(this.context, jsArray.getPointer());
    }

    public Object get(JSArray jsArray, int index) {
        this.checkSameThread();
        return this.get(this.context, jsArray.getPointer(), index);
    }

    public void set(JSArray jsArray, Object value, int index) {
        this.checkSameThread();
        this.set(this.context, jsArray.getPointer(), value, index);
    }

    Object call(JSObject func, long objPointer, Object ... args) {
        this.checkSameThread();
        return this.call(this.context, func.getPointer(), objPointer, args);
    }

    public void hold(JSObject jsObj) {
        this.checkSameThread();
        this.dupValue(jsObj);
        this.nativeCleaner.register(jsObj, jsObj.getPointer());
    }

    public JSObject createNewJSObject() {
        return this.parseJSON("{}");
    }

    public JSArray createNewJSArray() {
        return (JSArray)this.parseJSON("[]");
    }

    public JSObject parseJSON(String json) {
        this.checkSameThread();
        return this.parseJSON(this.context, json);
    }

    public byte[] compile(String sourceCode) {
        this.checkSameThread();
        return this.compile(this.context, sourceCode, UNKNOWN_FILE);
    }

    public byte[] compile(String sourceCode, String fileName) {
        this.checkSameThread();
        return this.compile(this.context, sourceCode, fileName);
    }

    public Object execute(byte[] code) {
        this.checkSameThread();
        return this.execute(this.context, code);
    }

    public Object evaluateModule(String script, String moduleName) {
        return this.evaluateModule(this.context, script, moduleName);
    }

    public Object evaluateModule(String script) {
        this.checkSameThread();
        return this.evaluateModule(script, UNKNOWN_FILE);
    }

    public void throwJSException(String error) {
        this.checkSameThread();
        String errorScript = "throw \"" + error + "\";";
        this.evaluate(errorScript);
    }

    public void setMaxStackSize(int maxStackSize) {
        this.checkSameThread();
        this.setMaxStackSize(this.context, maxStackSize);
    }

    private native long createContext();

    private native void destroyContext(long var1);

    private native Object evaluate(long var1, String var3, String var4);

    private native Object evaluateModule(long var1, String var3, String var4);

    private native JSObject getGlobalObject(long var1);

    private native Object call(long var1, long var3, long var5, Object[] var7);

    private native Object getProperty(long var1, long var3, String var5);

    private native void setProperty(long var1, long var3, String var5, Object var6);

    private native String stringify(long var1, long var3);

    private native int length(long var1, long var3);

    private native Object get(long var1, long var3, int var5);

    private native void set(long var1, long var3, Object var5, int var6);

    private native void freeValue(long var1, long var3);

    private native void dupValue(long var1, long var3);

    private native void freeDupValue(long var1, long var3);

    private native JSObject parseJSON(long var1, String var3);

    private native byte[] compile(long var1, String var3, String var4);

    private native Object execute(long var1, byte[] var3);

    private native void setMaxStackSize(long var1, int var3);

    static {
        System.loadLibrary("quickjs-android-wrapper");
    }
}

