/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.utils;

import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.exception.MyUncaughtExceptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static Logger logger;
    private static Project project;
    private static boolean isPreBuild;
    private static boolean isDev;
    static ExecutorService executorService;

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static void init(Project project) {
        Utils.project = project;
        logger = project.getLogger();
        Utils.logE("0.0.1.16");
    }

    public static boolean isFilePath(String str) {
        if (Utils.isHttpUrl(str)) {
            return false;
        }
        if (str.contains("$project") || str.startsWith("../") || str.startsWith("./")) {
            str = Utils.getPath(str);
        }
        File file = new File(str);
        return file.exists();
    }

    public static boolean isHttpUrl(String str) {
        if (Utils.isNullStr(str)) {
            return false;
        }
        return str.startsWith("http://") || str.startsWith("https://");
    }

    public static boolean isNullStr(String str) {
        return str == null || str.equals("");
    }

    public static boolean isPreBuild() {
        return isPreBuild;
    }

    public static boolean isDev() {
        if (isDev) {
            return true;
        }
        File file = new File(project.getRootProject().getRootDir(), "local.properties");
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Utils.logE("is properties dev " + properties.get("dev"));
            boolean dev = "true".equals(properties.get("dev"));
            if (dev) {
                isDev = true;
            }
            return dev;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void logE(String message) {
        logger.log(LogLevel.ERROR, "Monkey:" + message);
    }

    public static void v(String message) {
        logger.log(LogLevel.INFO, "Monkey:" + message);
    }

    public static void d(String message) {
        logger.log(LogLevel.DEBUG, "Monkey:" + message);
    }

    public static void print(Throwable e) {
        String stackTraceString = Utils.getStackTraceString(e);
        System.err.println(stackTraceString);
        System.exit(-1);
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String getPath(String source) {
        if (source == null) {
            throw new MonkeyBuildException("source is empty");
        }
        if (source.contains("$project")) {
            return source.replace("$project", project.getRootDir().getPath());
        }
        if (source.startsWith("../")) {
            String path = ConfigManager.getPath();
            File baseDir = new File(path).getParentFile();
            int count = 0;
            int lastIndex = 0;
            for (int i = 0; i < source.length(); ++i) {
                if ('.' != source.charAt(i) || i + 1 >= source.length() || '.' != source.charAt(i + 1) || i + 2 >= source.length() || '/' != source.charAt(i + 2)) continue;
                ++count;
                lastIndex = i + 3;
                i += 2;
            }
            while (count > 0) {
                --count;
                baseDir = baseDir.getParentFile();
            }
            return new File(baseDir, source.substring(lastIndex)).getPath();
        }
        if (source.startsWith("./")) {
            String path = ConfigManager.getPath();
            return new File(new File(path).getParentFile(), source.substring(2)).getPath();
        }
        if (source.startsWith("/")) {
            return source;
        }
        String path = ConfigManager.getPath();
        File file = new File(path).getParentFile();
        File file1 = new File(file, source.substring(2));
        return file1.getPath();
    }

    static {
        executorService = Executors.newFixedThreadPool(16, new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r);
                thread.setUncaughtExceptionHandler(MyUncaughtExceptionHandler.getInstance());
                thread.setName("Monkey-" + thread.getId());
                return thread;
            }
        });
        isDev = "true".equals(System.getenv("IS_TINY_RUNTIME"));
        isPreBuild = "true".equals(System.getenv("ELEPHANT_PRE_BUILD"));
    }
}

