/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.network;

import com.sunmi.android.elephant.exception.MonkeyBuildException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class NetworkClient {
    private static OkHttpClient okHttpClient = null;
    public static NetworkClient instance;

    private NetworkClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.retryOnConnectionFailure(true);
        int timeout = 20;
        builder.connectTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS);
        okHttpClient = builder.build();
    }

    public OkHttpClient getOkHttpClient() {
        return okHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkClient getInstance() {
        if (instance != null) return instance;
        Class<NetworkClient> clazz = NetworkClient.class;
        synchronized (NetworkClient.class) {
            if (instance != null) return instance;
            Class<NetworkClient> clazz2 = NetworkClient.class;
            synchronized (NetworkClient.class) {
                instance = new NetworkClient();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }
    }

    public byte[] download(String url) {
        Request request = new Request.Builder().url(url).build();
        NetworkClient instance = NetworkClient.getInstance();
        OkHttpClient okHttpClient = instance.getOkHttpClient();
        Call call = okHttpClient.newCall(request);
        Response execute = null;
        try {
            execute = call.execute();
            if (execute.code() == 200 && execute.body() != null) {
                ResponseBody body = execute.body();
                byte[] bytes = body.bytes();
                execute.close();
                return bytes;
            }
        }
        catch (IOException e) {
            throw new MonkeyBuildException(e);
        }
        return null;
    }
}

