/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.manager;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.Build;
import com.sunmi.android.elephant.model.Config;
import com.sunmi.android.elephant.model.Configs;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.Nullable;

public class ProductManager {
    public static void collectTheProduct(final Project project, final AppExtension appExtension, final String name) {
        ProductManager.proguardFiles(project, appExtension);
        Gradle gradle = project.getGradle();
        gradle.addBuildListener(new BuildListener(){

            public void buildStarted(Gradle gradle) {
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult result) {
                Throwable failure = result.getFailure();
                if (failure == null) {
                    NamedDomainObjectContainer buildOutputs = appExtension.getBuildOutputs();
                    Utils.logE(name);
                    ProductManager.out((BaseVariantOutput)buildOutputs.getByName("release"), project);
                    ProductManager.out((BaseVariantOutput)buildOutputs.getByName("debug"), project);
                } else {
                    Utils.logE("buildFinished:" + Utils.getStackTraceString(failure));
                }
            }
        });
    }

    private static void proguardFiles(Project project, AppExtension appExtension) {
        NamedDomainObjectContainer buildTypes = appExtension.getBuildTypes();
        ProductManager.setProguardFiles(project, (BuildType)buildTypes.getByName("release"));
        ProductManager.setProguardFiles(project, (BuildType)buildTypes.getByName("debug"));
    }

    private static void setProguardFiles(Project project, BuildType release) {
        List proguardFiles = release.getProguardFiles();
        File buildDir = project.getBuildDir();
        File file = new File(buildDir, "proguardFiles.txt");
        String mappingPath = "-printmapping  ../../mapping.txt";
        if (!file.exists()) {
            try {
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(mappingPath.getBytes("UTF-8"));
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        proguardFiles.add(file);
    }

    private static void out(BaseVariantOutput release, Project project) {
        File outputFile = release.getOutputFile();
        if (!outputFile.exists()) {
            return;
        }
        if (Utils.isPreBuild()) {
            outputFile = ProductManager.rename(outputFile);
            Utils.logE("\u9884\u6784\u5efa\u4ea7\u7269:" + outputFile.getPath() + " :" + outputFile.exists());
        }
        Config config = ConfigManager.getInstance().getConfig();
        Build build = config.getBuild();
        String apkName = null;
        try {
            apkName = new String(ProductManager.getDefaultAppName(build).getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new MonkeyBuildException(e);
        }
        try {
            Configs configs;
            String out;
            String buildId = build.getBuildId();
            buildId = buildId == null ? "test" : buildId.substring(buildId.length() - 8);
            File file1 = new File(project.getRootDir(), new String((apkName + "_" + release.getName() + "_" + build.getVersionName() + "_" + buildId + ".apk").getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            if (config != null && config.getBuild() != null && config.getBuild().getConfigs() != null && !Utils.isNullStr(out = (configs = config.getBuild().getConfigs()).getOutApk())) {
                file1 = new File(Utils.getPath(out));
            }
            if (file1.exists()) {
                file1.delete();
            }
            FileUtils.copyFile((File)outputFile, (File)file1);
            Utils.logE("Product File:" + file1.getPath());
        }
        catch (IOException e) {
            throw new MonkeyBuildException(e);
        }
    }

    private static File rename(File outputFile) {
        File file;
        String name = outputFile.getName();
        File parentFile = outputFile.getParentFile();
        if (name.contains("-unsigned") && outputFile.renameTo(file = new File(parentFile, name.replace("-unsigned", "")))) {
            outputFile = file;
        }
        return outputFile;
    }

    @Nullable
    private static String getDefaultAppName(Build build) {
        Map<String, String> appName = build.getAppName();
        if (appName != null) {
            return appName.get("default");
        }
        return null;
    }

    public static void signing(AppExtension appExtension) {
        NamedDomainObjectContainer buildTypes = appExtension.getBuildTypes();
        if (Utils.isPreBuild()) {
            Utils.logE("pre build signing skip");
            ProductManager.cleanSigning((BuildType)buildTypes.getAt("release"));
            ProductManager.cleanSigning((BuildType)buildTypes.getAt("debug"));
        } else {
            ProductManager.setKeystore((BuildType)buildTypes.getAt("release"));
            ProductManager.setKeystore((BuildType)buildTypes.getAt("debug"));
        }
    }

    private static void cleanSigning(BuildType release) {
        release.setSigningConfig(null);
    }

    private static void setKeystore(BuildType release) {
        SigningConfig signingConfig = new SigningConfig("key");
        ConfigManager instance = ConfigManager.getInstance();
        Config config = instance.getConfig();
        String storeFilepath = config.getBuild().getKeystore().getStoreFilepath();
        if (!Utils.isNullStr(storeFilepath)) {
            File file = new File(Utils.getPath(storeFilepath));
            signingConfig.storeFile(file);
            Utils.logE("keystore path:" + file.getPath());
        }
        signingConfig.keyAlias(config.getBuild().getKeystore().getKeyAlias());
        signingConfig.keyPassword(config.getBuild().getKeystore().getKeyPassword());
        signingConfig.storePassword(config.getBuild().getKeystore().getStorePassword());
        release.setSigningConfig(signingConfig);
    }

    public static void injectionBuildId(AppExtension appExtension) {
        NamedDomainObjectContainer buildTypes = appExtension.getBuildTypes();
        Iterator iterator = buildTypes.iterator();
        ConfigManager instance = ConfigManager.getInstance();
        Config config = instance.getConfig();
        while (iterator.hasNext()) {
            BuildType next = (BuildType)iterator.next();
            next.buildConfigField("String", "BUILD_ID", "\"" + config.getBuild().getBuildId() + "\"");
        }
    }

    public static void transaction(final Project project, Gradle gradle, final AppExtension appExtension) {
        final TaskExecutionGraph taskGraph = gradle.getTaskGraph();
        taskGraph.addTaskExecutionGraphListener(new TaskExecutionGraphListener(){

            public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
                List allTasks = taskExecutionGraph.getAllTasks();
                for (Task allTask : allTasks) {
                    String name = allTask.getName();
                    if (!"assembleRelease".equals(name) && !"assembleDebug".equals(name)) continue;
                    taskGraph.removeTaskExecutionGraphListener((TaskExecutionGraphListener)this);
                    ProductManager.collectTheProduct(project, appExtension, name);
                    break;
                }
            }
        });
    }
}

