/*
 * Decompiled with CFR 0.152.
 */
package com.sunmi.android.elephant.manager;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.sunmi.android.elephant.ConfigManager;
import com.sunmi.android.elephant.exception.MonkeyBuildException;
import com.sunmi.android.elephant.model.Build;
import com.sunmi.android.elephant.model.Config;
import com.sunmi.android.elephant.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class BuildCacheManager {
    public static BuildCacheManager instance = new BuildCacheManager();

    public static BuildCacheManager getInstance() {
        return instance;
    }

    public File setBuildCache(Project project, AppExtension appExtension) {
        File cacheDir = null;
        if (!Utils.isDev()) {
            Config config = ConfigManager.getInstance().getConfig();
            Build build = config.getBuild();
            if (build != null && build.getConfigs() != null && !Utils.isNullStr(build.getConfigs().getBuildCache())) {
                cacheDir = new File(Utils.getPath(build.getConfigs().getBuildCache()));
                Utils.logE("set build cache " + cacheDir.getPath());
            } else {
                cacheDir = project.getRootDir();
                Utils.logE("use build cache by default:" + cacheDir.getPath());
            }
            cacheDir = new File(cacheDir, "build");
            project.setBuildDir(cacheDir);
            final File file = new File(cacheDir, "ElephantSource");
            appExtension.sourceSets((Action)new Action<NamedDomainObjectContainer<AndroidSourceSet>>(){

                public void execute(NamedDomainObjectContainer<AndroidSourceSet> androidSourceSets) {
                    for (AndroidSourceSet androidSourceSet : androidSourceSets) {
                        if (!"main".equals(androidSourceSet.getName())) continue;
                        long start = System.currentTimeMillis();
                        AndroidSourceDirectorySet assets = androidSourceSet.getAssets();
                        File newAssets = new File(file, "assets");
                        instance.setSourceDir(assets, newAssets);
                        File newRes = new File(file, "res");
                        AndroidSourceDirectorySet res = androidSourceSet.getRes();
                        instance.copyProjectRes(newRes, res);
                        instance.setSourceDir(res, newRes);
                        long end = System.currentTimeMillis();
                        Utils.logE("set source dir end:" + String.valueOf(end - start));
                        break;
                    }
                }
            });
        }
        return cacheDir;
    }

    private void setSourceDir(AndroidSourceDirectorySet assets, File file) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(file.getPath());
        assets.setSrcDirs(strings);
    }

    private void copyProjectRes(File newRes, AndroidSourceDirectorySet res) {
        Set srcDirs = res.getSrcDirs();
        if (newRes.exists()) {
            try {
                FileUtils.cleanDirectory((File)newRes);
            }
            catch (IOException e) {
                throw new MonkeyBuildException(e);
            }
        }
        for (File temp : srcDirs) {
            try {
                if (temp.isDirectory()) {
                    FileUtils.copyDirectory((File)temp, (File)newRes);
                    continue;
                }
                FileUtils.copyFile((File)temp, (File)new File(newRes, temp.getName()));
            }
            catch (IOException e) {
                throw new MonkeyBuildException(e);
            }
        }
    }
}

