/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.webRTC.common;

import android.content.Context;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.lite.webRTC.common.AppRTCClient;
import com.netacom.lite.webRTC.common.RecordedAudioToFileController;
import com.netacom.lite.webRTC.common.RtcEventLog;
import com.netacom.lite.webRTC.common.callback.SwitchCameraCallback;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.Logging;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.StatsObserver;
import org.webrtc.StatsReport;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class PeerConnectionClient {
    private static final String VIDEO_TRACK_ID = "ARDAMSv0";
    private static final String AUDIO_TRACK_ID = "ARDAMSa0";
    private static final String VIDEO_TRACK_TYPE = "video";
    private static final String TAG = "PCRTCClient";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1280;
    private static final int HD_VIDEO_HEIGHT = 720;
    private static final int BPS_IN_KBPS = 1000;
    private static final String RTCEVENTLOG_OUTPUT_DIR_NAME = "rtc_event_log";
    private static final List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private final Timer statsTimer = new Timer();
    private final EglBase rootEglBase;
    private final Context appContext;
    private final PeerConnectionParameters peerConnectionParameters;
    private final PeerConnectionEvents events;
    @Nullable
    private PeerConnectionFactory factory;
    @Nullable
    private PeerConnection peerConnection;
    @Nullable
    private AudioSource audioSource;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VideoSource videoSource;
    private boolean preferIsac;
    private boolean videoCapturerStopped;
    private boolean isError;
    @Nullable
    private VideoSink localRender;
    @Nullable
    private List<VideoSink> remoteSinks;
    private AppRTCClient.SignalingParameters signalingParameters;
    private int videoWidth;
    private int videoHeight;
    private int videoFps;
    private MediaConstraints audioConstraints;
    private MediaConstraints sdpMediaConstraints;
    @Nullable
    private List<IceCandidate> queuedRemoteCandidates;
    private boolean isInitiator;
    @Nullable
    private SessionDescription localSdp;
    @Nullable
    private VideoCapturer videoCapturer;
    private boolean renderVideo = true;
    @Nullable
    private VideoTrack localVideoTrack;
    @Nullable
    private VideoTrack remoteVideoTrack;
    @Nullable
    private RtpSender localVideoSender;
    private boolean enableAudio = true;
    @Nullable
    private AudioTrack localAudioTrack;
    @Nullable
    private DataChannel dataChannel;
    private final boolean dataChannelEnabled;
    @Nullable
    private RtcEventLog rtcEventLog;
    @Nullable
    private RecordedAudioToFileController saveRecordedAudioToFile;

    public PeerConnectionClient(Context appContext, EglBase eglBase, PeerConnectionParameters peerConnectionParameters, PeerConnectionEvents events) {
        this.rootEglBase = eglBase;
        this.appContext = appContext;
        this.events = events;
        this.peerConnectionParameters = peerConnectionParameters;
        this.dataChannelEnabled = peerConnectionParameters.dataChannelParameters != null;
        Log.d((String)TAG, (String)("Preferred video codec: " + PeerConnectionClient.getSdpVideoCodecName(peerConnectionParameters)));
        String fieldTrials = PeerConnectionClient.getFieldTrials(peerConnectionParameters);
        executor.execute(() -> {
            Log.d((String)TAG, (String)("Initialize WebRTC. Field trials: " + fieldTrials));
            PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)appContext).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
        });
    }

    public void createPeerConnectionFactory(PeerConnectionFactory.Options options) {
        if (this.factory != null) {
            throw new IllegalStateException("PeerConnectionFactory has already been constructed");
        }
        executor.execute(() -> this.createPeerConnectionFactoryInternal(options));
    }

    public void createPeerConnection(VideoSink localRender, VideoSink remoteSink, VideoCapturer videoCapturer, AppRTCClient.SignalingParameters signalingParameters, boolean isVideoEnabled) {
        if (videoCapturer == null) {
            Log.w((String)TAG, (String)"Video call enabled but no video capturer provided.");
        }
        this.createPeerConnection(localRender, Collections.singletonList(remoteSink), videoCapturer, signalingParameters, isVideoEnabled);
    }

    public void createPeerConnection(VideoSink localRender, List<VideoSink> remoteSinks, VideoCapturer videoCapturer, AppRTCClient.SignalingParameters signalingParameters, boolean isVideoEnabled) {
        if (this.peerConnectionParameters == null) {
            Log.e((String)TAG, (String)"Creating peer connection without initializing factory.");
            return;
        }
        this.localRender = localRender;
        this.remoteSinks = remoteSinks;
        this.videoCapturer = videoCapturer;
        this.signalingParameters = signalingParameters;
        this.renderVideo = isVideoEnabled;
        executor.execute(() -> {
            try {
                this.createMediaConstraintsInternal();
                this.createPeerConnectionInternal();
                this.maybeCreateAndStartRtcEventLog();
            }
            catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                this.reportError("Failed to create peer connection: " + e.getMessage());
                throw e;
            }
        });
    }

    public void close() {
        executor.execute(this::closeInternal);
    }

    private void createPeerConnectionFactoryInternal(PeerConnectionFactory.Options options) {
        try {
            SoftwareVideoDecoderFactory decoderFactory;
            SoftwareVideoEncoderFactory encoderFactory;
            this.isError = false;
            if (this.peerConnectionParameters.tracing) {
                PeerConnectionFactory.startInternalTracingCapture((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "webrtc-trace.txt"));
            }
            boolean bl = this.preferIsac = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ISAC);
            if (this.peerConnectionParameters.saveInputAudioToFile) {
                if (!this.peerConnectionParameters.useOpenSLES) {
                    Log.d((String)TAG, (String)"Enable recording of microphone input audio to file");
                    this.saveRecordedAudioToFile = new RecordedAudioToFileController(executor);
                } else {
                    Log.e((String)TAG, (String)"Recording of input audio is not supported for OpenSL ES");
                }
            }
            AudioDeviceModule adm = this.createJavaAudioDevice();
            if (options != null) {
                Log.d((String)TAG, (String)("Factory networkIgnoreMask option: " + options.networkIgnoreMask));
            }
            boolean enableH264HighProfile = VIDEO_CODEC_H264_HIGH.equals(this.peerConnectionParameters.videoCodec);
            if (this.peerConnectionParameters.videoCodecHwAcceleration) {
                encoderFactory = new DefaultVideoEncoderFactory(this.rootEglBase.getEglBaseContext(), true, enableH264HighProfile);
                decoderFactory = new DefaultVideoDecoderFactory(this.rootEglBase.getEglBaseContext());
            } else {
                encoderFactory = new SoftwareVideoEncoderFactory();
                decoderFactory = new SoftwareVideoDecoderFactory();
            }
            this.factory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(adm).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
            Log.d((String)TAG, (String)"Peer connection factory created.");
            adm.release();
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    private AudioDeviceModule createJavaAudioDevice() {
        if (!this.peerConnectionParameters.useOpenSLES) {
            Log.w((String)TAG, (String)"External OpenSLES ADM not implemented yet.");
        }
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioRecordError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackInitError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackStartError: " + errorCode + ". " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                Log.e((String)PeerConnectionClient.TAG, (String)("onWebRtcAudioTrackError: " + errorMessage));
                PeerConnectionClient.this.reportError(errorMessage);
            }
        };
        return JavaAudioDeviceModule.builder((Context)this.appContext).setSamplesReadyCallback((JavaAudioDeviceModule.SamplesReadyCallback)this.saveRecordedAudioToFile).setUseHardwareAcousticEchoCanceler(!this.peerConnectionParameters.disableBuiltInAEC).setUseHardwareNoiseSuppressor(!this.peerConnectionParameters.disableBuiltInNS).setAudioRecordErrorCallback(audioRecordErrorCallback).setAudioTrackErrorCallback(audioTrackErrorCallback).createAudioDeviceModule();
    }

    private void createMediaConstraintsInternal() {
        this.videoWidth = this.peerConnectionParameters.videoWidth;
        this.videoHeight = this.peerConnectionParameters.videoHeight;
        this.videoFps = this.peerConnectionParameters.videoFps;
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            this.videoWidth = 1280;
            this.videoHeight = 720;
        }
        if (this.videoFps == 0) {
            this.videoFps = 30;
        }
        Logging.d((String)TAG, (String)("Capturing format: " + this.videoWidth + "x" + this.videoHeight + "@" + this.videoFps));
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            Log.d((String)TAG, (String)"Disabling audio processing");
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
        this.sdpMediaConstraints = new MediaConstraints();
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        this.sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
    }

    private void createPeerConnectionInternal() {
        if (this.factory == null || this.isError) {
            Log.e((String)TAG, (String)"Peerconnection factory is not created");
            return;
        }
        Log.d((String)TAG, (String)"Create peer connection.");
        try {
            this.queuedRemoteCandidates = new ArrayList<IceCandidate>();
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.signalingParameters.iceServers);
            rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
            rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
            rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
            rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
            rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
            rtcConfig.enableDtlsSrtp = !this.peerConnectionParameters.loopback;
            rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
            rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.ALL;
            this.peerConnection = this.factory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this.pcObserver);
            if (this.dataChannelEnabled) {
                DataChannel.Init init = new DataChannel.Init();
                init.ordered = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.ordered;
                init.negotiated = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.negotiated;
                init.maxRetransmits = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.maxRetransmits;
                init.maxRetransmitTimeMs = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.maxRetransmitTimeMs;
                init.id = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.id;
                init.protocol = ((PeerConnectionParameters)this.peerConnectionParameters).dataChannelParameters.protocol;
                this.dataChannel = this.peerConnection.createDataChannel("ApprtcDemo data", init);
            }
            this.isInitiator = false;
            Logging.enableLogToDebugOutput((Logging.Severity)Logging.Severity.LS_ERROR);
            this.peerConnection.addTrack((MediaStreamTrack)this.createVideoTrack(this.videoCapturer), mediaStreamLabels);
            this.remoteVideoTrack = this.getRemoteVideoTrack();
            if (this.remoteVideoTrack != null) {
                this.remoteVideoTrack.setEnabled(this.renderVideo);
                for (VideoSink remoteSink : this.remoteSinks) {
                    this.remoteVideoTrack.addSink(remoteSink);
                }
            }
            this.peerConnection.addTrack((MediaStreamTrack)this.createAudioTrack(), mediaStreamLabels);
            this.findVideoSender();
            if (this.peerConnectionParameters.aecDump) {
                try {
                    ParcelFileDescriptor aecDumpFileDescriptor = ParcelFileDescriptor.open((File)new File(Environment.getExternalStorageDirectory().getPath() + File.separator + "Download/audio.aecdump"), (int)0x3C000000);
                    this.factory.startAecDump(aecDumpFileDescriptor.detachFd(), -1);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Can not open aecdump file", (Throwable)e);
                }
            }
            if (this.saveRecordedAudioToFile != null && this.saveRecordedAudioToFile.start()) {
                Log.d((String)TAG, (String)"Recording input audio to file is activated");
            }
            Log.d((String)TAG, (String)"Peer connection created.");
        }
        catch (Exception e) {
            e.printStackTrace();
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
        }
    }

    private File createRtcEventLogOutputFile() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_hhmm_ss", Locale.getDefault());
        Date date = new Date();
        String outputFileName = "event_log_" + dateFormat.format(date) + ".log";
        return new File(this.appContext.getDir(RTCEVENTLOG_OUTPUT_DIR_NAME, 0), outputFileName);
    }

    private void maybeCreateAndStartRtcEventLog() {
        if (this.appContext == null || this.peerConnection == null) {
            return;
        }
        if (!this.peerConnectionParameters.enableRtcEventLog) {
            Log.d((String)TAG, (String)"RtcEventLog is disabled.");
            return;
        }
        this.rtcEventLog = new RtcEventLog(this.peerConnection);
        this.rtcEventLog.start(this.createRtcEventLogOutputFile());
    }

    private void closeInternal() {
        if (this.factory != null && this.peerConnectionParameters.aecDump) {
            this.factory.stopAecDump();
        }
        Log.d((String)TAG, (String)"Closing peer connection.");
        this.statsTimer.cancel();
        if (this.dataChannel != null) {
            this.dataChannel.dispose();
            this.dataChannel = null;
        }
        if (this.rtcEventLog != null) {
            this.rtcEventLog.stop();
            this.rtcEventLog = null;
        }
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        Log.d((String)TAG, (String)"Closing audio source.");
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        Log.d((String)TAG, (String)"Stopping capture.");
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.videoCapturerStopped = true;
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        Log.d((String)TAG, (String)"Closing video source.");
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        if (this.saveRecordedAudioToFile != null) {
            Log.d((String)TAG, (String)"Closing audio file for recorded input audio.");
            this.saveRecordedAudioToFile.stop();
            this.saveRecordedAudioToFile = null;
        }
        this.localRender = null;
        this.remoteSinks = null;
        Log.d((String)TAG, (String)"Closing peer connection factory.");
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        if (this.rootEglBase.hasSurface()) {
            this.rootEglBase.release();
        }
        Log.d((String)TAG, (String)"Closing peer connection done.");
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    public boolean isHDVideo() {
        return this.videoWidth * this.videoHeight >= 921600;
    }

    private void getStats() {
        if (this.peerConnection == null || this.isError) {
            return;
        }
        boolean success = this.peerConnection.getStats(new StatsObserver(){

            public void onComplete(StatsReport[] reports) {
                PeerConnectionClient.this.events.onPeerConnectionStatsReady(reports);
            }
        }, null);
        if (!success) {
            Log.e((String)TAG, (String)"getStats() returns false!");
        }
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(() -> PeerConnectionClient.this.getStats());
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Can not schedule statistics timer", (Throwable)e);
            }
        } else {
            this.statsTimer.cancel();
        }
    }

    public void setAudioEnabled(boolean enable) {
        executor.execute(() -> {
            this.enableAudio = enable;
            if (this.localAudioTrack != null) {
                this.localAudioTrack.setEnabled(this.enableAudio);
            }
        });
    }

    public void setVideoEnabledAll(boolean enable) {
        executor.execute(() -> {
            this.renderVideo = enable;
            if (this.localVideoTrack != null) {
                this.localVideoTrack.setEnabled(this.renderVideo);
            }
            if (this.remoteVideoTrack != null) {
                this.remoteVideoTrack.setEnabled(this.renderVideo);
            }
        });
    }

    public void setVideoEnabledLocal(boolean enable) {
        executor.execute(() -> {
            try {
                this.renderVideo = enable;
                if (this.localVideoTrack != null) {
                    this.localVideoTrack.setEnabled(this.renderVideo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void setVideoEnabledRemote(boolean enable) {
        executor.execute(() -> {
            try {
                if (this.remoteVideoTrack != null && this.remoteVideoTrack.enabled() != enable) {
                    this.remoteVideoTrack.setEnabled(enable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void createOffer(boolean isRetry) {
        executor.execute(() -> {
            try {
                if (this.peerConnection != null && !this.isError) {
                    Log.d((String)TAG, (String)"PC Create OFFER");
                    this.isInitiator = true;
                    if (isRetry) {
                        this.sdpMediaConstraints.optional.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
                    }
                    this.peerConnection.createOffer((SdpObserver)this.sdpObserver, this.sdpMediaConstraints);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void createAnswer() {
        Log.d((String)TAG, (String)"Try to PC create ANSWER");
        executor.execute(() -> {
            try {
                Log.d((String)TAG, (String)"Try to PC create ANSWER");
                if (this.peerConnection != null && !this.isError) {
                    Log.d((String)TAG, (String)"PC create ANSWER");
                    this.isInitiator = false;
                    this.peerConnection.createAnswer((SdpObserver)this.sdpObserver, this.sdpMediaConstraints);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void addRemoteIceCandidate(IceCandidate candidate) {
        executor.execute(() -> {
            try {
                if (this.peerConnection != null && !this.isError) {
                    if (this.queuedRemoteCandidates != null) {
                        this.queuedRemoteCandidates.add(candidate);
                    } else {
                        this.peerConnection.addIceCandidate(candidate);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void removeRemoteIceCandidates(IceCandidate[] candidates) {
        executor.execute(() -> {
            try {
                if (this.peerConnection == null || this.isError) {
                    Log.e((String)TAG, (String)("Error on setting remote candidate, peerConnection=" + this.peerConnection + ", error=" + this.isError));
                    return;
                }
                this.drainCandidates();
                this.peerConnection.removeIceCandidates(candidates);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void setRemoteDescription(SessionDescription sdp) {
        executor.execute(() -> {
            try {
                if (this.peerConnection == null || this.isError) {
                    Log.e((String)TAG, (String)("Error on setting remote sdp, peerConnection=" + this.peerConnection + ", error=" + this.isError));
                    return;
                }
                String sdpDescription = sdp.description;
                if (this.preferIsac) {
                    sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, AUDIO_CODEC_ISAC, true);
                }
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.getSdpVideoCodecName(this.peerConnectionParameters), false);
                if (this.peerConnectionParameters.audioStartBitrate > 0) {
                    sdpDescription = PeerConnectionClient.setStartBitrate(AUDIO_CODEC_OPUS, false, sdpDescription, this.peerConnectionParameters.audioStartBitrate);
                }
                Log.d((String)TAG, (String)"Set remote SDP.");
                SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
                this.peerConnection.setRemoteDescription((SdpObserver)this.sdpObserver, sdpRemote);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void stopVideoSource() {
        executor.execute(() -> {
            block4: {
                try {
                    if (this.videoCapturer == null || this.videoCapturerStopped) break block4;
                    Log.d((String)TAG, (String)"Stop video source.");
                    try {
                        this.videoCapturer.stopCapture();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.videoCapturerStopped = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void startVideoSource() {
        executor.execute(() -> {
            try {
                if (this.videoCapturer != null && this.videoCapturerStopped) {
                    Log.d((String)TAG, (String)"Restart video source.");
                    this.videoCapturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
                    this.videoCapturerStopped = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void setVideoMaxBitrate(@Nullable Integer maxBitrateKbps) {
        executor.execute(() -> {
            try {
                if (this.peerConnection == null || this.localVideoSender == null || this.isError) {
                    return;
                }
                Log.d((String)TAG, (String)("Requested max video bitrate: " + maxBitrateKbps));
                if (this.localVideoSender == null) {
                    Log.w((String)TAG, (String)"Sender is not ready.");
                    return;
                }
                RtpParameters parameters = this.localVideoSender.getParameters();
                if (parameters.encodings.size() == 0) {
                    Log.w((String)TAG, (String)"RtpParameters are not ready.");
                    return;
                }
                for (RtpParameters.Encoding encoding : parameters.encodings) {
                    encoding.maxBitrateBps = maxBitrateKbps == null ? null : Integer.valueOf(maxBitrateKbps * 1000);
                }
                if (!this.localVideoSender.setParameters(parameters)) {
                    Log.e((String)TAG, (String)"RtpSender.setParameters failed.");
                }
                Log.d((String)TAG, (String)("Configured max video bitrate to: " + maxBitrateKbps));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void reportError(String errorMessage) {
        Log.e((String)TAG, (String)("Peerconnection error: " + errorMessage));
        executor.execute(() -> {
            try {
                if (!this.isError) {
                    this.events.onPeerConnectionError(errorMessage);
                    this.isError = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Nullable
    private AudioTrack createAudioTrack() {
        WebRtcAudioUtils.setWebRtcBasedAcousticEchoCanceler((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedNoiseSuppressor((boolean)true);
        WebRtcAudioUtils.setWebRtcBasedAutomaticGainControl((boolean)true);
        this.audioSource = this.factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = this.factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(this.enableAudio);
        return this.localAudioTrack;
    }

    @Nullable
    private VideoTrack createVideoTrack(VideoCapturer capturer) {
        if (capturer != null) {
            this.surfaceTextureHelper = SurfaceTextureHelper.create((String)"CaptureThread", (EglBase.Context)this.rootEglBase.getEglBaseContext());
            this.videoSource = this.factory.createVideoSource(capturer.isScreencast());
            capturer.initialize(this.surfaceTextureHelper, this.appContext, this.videoSource.getCapturerObserver());
            capturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
        }
        if (this.videoSource != null) {
            this.localVideoTrack = this.factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
            this.localVideoTrack.setEnabled(this.renderVideo);
            this.localVideoTrack.addSink(this.localRender);
        }
        return this.localVideoTrack;
    }

    private void findVideoSender() {
        for (RtpSender sender : this.peerConnection.getSenders()) {
            String trackType;
            if (sender.track() == null || !(trackType = sender.track().kind()).equals(VIDEO_TRACK_TYPE)) continue;
            Log.d((String)TAG, (String)"Found video sender.");
            this.localVideoSender = sender;
        }
    }

    @Nullable
    private VideoTrack getRemoteVideoTrack() {
        for (RtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getReceiver().track();
            if (!(track instanceof VideoTrack)) continue;
            return (VideoTrack)track;
        }
        return null;
    }

    private static String getSdpVideoCodecName(PeerConnectionParameters parameters) {
        switch (parameters.videoCodec) {
            case "VP8": {
                return VIDEO_CODEC_VP8;
            }
            case "VP9": {
                return VIDEO_CODEC_VP9;
            }
            case "H264 High": 
            case "H264 Baseline": {
                return VIDEO_CODEC_H264;
            }
        }
        return VIDEO_CODEC_VP8;
    }

    private static String getFieldTrials(PeerConnectionParameters peerConnectionParameters) {
        String fieldTrials = "";
        if (peerConnectionParameters.videoFlexfecEnabled) {
            fieldTrials = fieldTrials + VIDEO_FLEXFEC_FIELDTRIAL;
            Log.d((String)TAG, (String)"Enable FlexFEC field trial.");
        }
        fieldTrials = fieldTrials + VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
        if (peerConnectionParameters.disableWebRtcAGCAndHPF) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
            Log.d((String)TAG, (String)"Disable WebRTC AGC field trial.");
        }
        return fieldTrials;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            Log.w((String)TAG, (String)("No rtpmap for " + codec + " codec"));
            return sdpDescription;
        }
        Log.d((String)TAG, (String)("Found " + codec + " rtpmap " + codecRtpMap + " at " + lines[rtpmapLineIndex]));
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            Log.d((String)TAG, (String)("Found " + codec + " " + lines[i]));
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            Log.d((String)TAG, (String)("Update remote SDP line: " + lines[i]));
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            Log.d((String)TAG, (String)("Add remote SDP line: " + bitrateSet));
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    @Nullable
    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            Log.e((String)TAG, (String)("Wrong SDP media description format: " + mLine));
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return PeerConnectionClient.joinString(newLineParts, " ", false);
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = PeerConnectionClient.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            Log.w((String)TAG, (String)("No mediaDescription line, so can't prefer " + codec));
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            Log.w((String)TAG, (String)("No payload types with name " + codec));
            return sdpDescription;
        }
        String newMLine = PeerConnectionClient.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        Log.d((String)TAG, (String)("Change media description from: " + lines[mLineIndex] + " to " + newMLine));
        lines[mLineIndex] = newMLine;
        return PeerConnectionClient.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            Log.d((String)TAG, (String)("Add " + this.queuedRemoteCandidates.size() + " remote candidates"));
            for (IceCandidate candidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    private void switchCameraInternal(final SwitchCameraCallback switchCameraCallback) {
        if (this.videoCapturer instanceof CameraVideoCapturer) {
            if (this.isError) {
                Log.e((String)TAG, (String)"Failed to switch camera. Error : true");
                return;
            }
            Log.d((String)TAG, (String)"Switch camera");
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.videoCapturer;
            cameraVideoCapturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                public void onCameraSwitchDone(boolean b) {
                    switchCameraCallback.switchDone(b);
                }

                public void onCameraSwitchError(String s) {
                    switchCameraCallback.switchError(s);
                }
            });
        } else {
            Log.d((String)TAG, (String)"Will not switch camera, video capturer is not a camera");
        }
    }

    public void switchCamera(SwitchCameraCallback switchCameraCallback) {
        executor.execute(() -> this.switchCameraInternal(switchCameraCallback));
    }

    public void changeCaptureFormat(int width, int height, int framerate) {
        executor.execute(() -> this.changeCaptureFormatInternal(width, height, framerate));
    }

    private void changeCaptureFormatInternal(int width, int height, int framerate) {
        if (this.isError || this.videoCapturer == null) {
            Log.e((String)TAG, (String)("Failed to change capture format. Error : " + this.isError));
            return;
        }
        Log.d((String)TAG, (String)("changeCaptureFormat: " + width + "x" + height + "@" + framerate));
        this.videoSource.adaptOutputFormat(width, height, framerate);
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        public void onCreateSuccess(SessionDescription origSdp) {
            String sdpDescription = origSdp.description;
            if (PeerConnectionClient.this.preferIsac) {
                sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.AUDIO_CODEC_ISAC, true);
            }
            sdpDescription = PeerConnectionClient.preferCodec(sdpDescription, PeerConnectionClient.getSdpVideoCodecName(PeerConnectionClient.this.peerConnectionParameters), false);
            SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            PeerConnectionClient.this.localSdp = sdp;
            executor.execute(() -> {
                if (PeerConnectionClient.this.peerConnection != null && !PeerConnectionClient.this.isError) {
                    Log.d((String)PeerConnectionClient.TAG, (String)("Set local SDP from " + sdp.type));
                    PeerConnectionClient.this.peerConnection.setLocalDescription((SdpObserver)PeerConnectionClient.this.sdpObserver, sdp);
                }
            });
        }

        public void onSetSuccess() {
            executor.execute(() -> {
                if (PeerConnectionClient.this.peerConnection == null || PeerConnectionClient.this.isError) {
                    return;
                }
                if (PeerConnectionClient.this.isInitiator) {
                    if (PeerConnectionClient.this.peerConnection.getRemoteDescription() == null) {
                        Log.d((String)PeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                        PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                    } else {
                        Log.d((String)PeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                        PeerConnectionClient.this.drainCandidates();
                    }
                } else if (PeerConnectionClient.this.peerConnection.getLocalDescription() != null) {
                    Log.d((String)PeerConnectionClient.TAG, (String)"Local SDP set succesfully");
                    PeerConnectionClient.this.events.onLocalDescription(PeerConnectionClient.this.localSdp);
                    PeerConnectionClient.this.drainCandidates();
                } else {
                    Log.d((String)PeerConnectionClient.TAG, (String)"Remote SDP set succesfully");
                }
            });
        }

        public void onCreateFailure(String error) {
            PeerConnectionClient.this.reportError("createSDP error: " + error);
        }

        public void onSetFailure(String error) {
            PeerConnectionClient.this.reportError("setSDP error: " + error);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        public void onIceCandidate(IceCandidate candidate) {
            executor.execute(() -> PeerConnectionClient.this.events.onIceCandidate(candidate));
        }

        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            executor.execute(() -> PeerConnectionClient.this.events.onIceCandidatesRemoved(candidates));
        }

        public void onSignalingChange(PeerConnection.SignalingState newState) {
            Log.d((String)PeerConnectionClient.TAG, (String)("SignalingState: " + newState));
        }

        public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
            executor.execute(() -> {
                Log.d((String)PeerConnectionClient.TAG, (String)("IceConnectionState: " + newState));
                if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                    PeerConnectionClient.this.events.onIceConnected();
                } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                    PeerConnectionClient.this.events.onIceDisconnected();
                } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                    PeerConnectionClient.this.reportError("ICE connection failed.");
                }
            });
        }

        public void onConnectionChange(PeerConnection.PeerConnectionState newState) {
            executor.execute(() -> {
                Log.d((String)PeerConnectionClient.TAG, (String)("PeerConnectionState: " + newState));
                if (newState == PeerConnection.PeerConnectionState.CONNECTED) {
                    PeerConnectionClient.this.events.onConnected();
                } else if (newState == PeerConnection.PeerConnectionState.DISCONNECTED) {
                    PeerConnectionClient.this.events.onDisconnected();
                } else if (newState == PeerConnection.PeerConnectionState.FAILED) {
                    PeerConnectionClient.this.reportError("DTLS connection failed.");
                }
            });
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            Log.d((String)PeerConnectionClient.TAG, (String)("IceGatheringState: " + newState));
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
            Log.d((String)PeerConnectionClient.TAG, (String)("IceConnectionReceiving changed to " + receiving));
        }

        public void onAddStream(MediaStream stream) {
            Log.e((String)"test", (String)"onAddStream");
        }

        public void onRemoveStream(MediaStream stream) {
        }

        public void onDataChannel(final DataChannel dc) {
            Log.d((String)PeerConnectionClient.TAG, (String)("New Data channel " + dc.label()));
            if (!PeerConnectionClient.this.dataChannelEnabled) {
                return;
            }
            dc.registerObserver(new DataChannel.Observer(){

                public void onBufferedAmountChange(long previousAmount) {
                    Log.d((String)PeerConnectionClient.TAG, (String)("Data channel buffered amount changed: " + dc.label() + ": " + dc.state()));
                }

                public void onStateChange() {
                    Log.d((String)PeerConnectionClient.TAG, (String)("Data channel state changed: " + dc.label() + ": " + dc.state()));
                }

                public void onMessage(DataChannel.Buffer buffer) {
                    if (buffer.binary) {
                        Log.d((String)PeerConnectionClient.TAG, (String)("Received binary msg over " + dc));
                        return;
                    }
                    ByteBuffer data = buffer.data;
                    byte[] bytes = new byte[data.capacity()];
                    data.get(bytes);
                    String strData = new String(bytes, StandardCharsets.UTF_8);
                    Log.d((String)PeerConnectionClient.TAG, (String)("Got msg: " + strData + " over " + dc));
                }
            });
        }

        public void onRenegotiationNeeded() {
        }

        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
            Log.e((String)"test", (String)"onAddTrack");
        }
    }

    public static interface PeerConnectionEvents {
        default public void onLocalDescription(SessionDescription sdp) {
        }

        default public void onIceCandidate(IceCandidate candidate) {
        }

        default public void onIceCandidatesRemoved(IceCandidate[] candidates) {
        }

        default public void onIceConnected() {
        }

        default public void onIceDisconnected() {
        }

        default public void onConnected() {
        }

        default public void onDisconnected() {
        }

        default public void onPeerConnectionClosed() {
        }

        default public void onPeerConnectionStatsReady(StatsReport[] reports) {
        }

        default public void onPeerConnectionError(String description) {
        }
    }

    public static class PeerConnectionParameters {
        private final boolean loopback;
        private final boolean tracing;
        private final int videoWidth;
        private final int videoHeight;
        private final int videoFps;
        private final int videoMaxBitrate;
        private final String videoCodec;
        private final boolean videoCodecHwAcceleration;
        private final boolean videoFlexfecEnabled;
        private final int audioStartBitrate;
        private final String audioCodec;
        private final boolean noAudioProcessing;
        private final boolean aecDump;
        private final boolean saveInputAudioToFile;
        private final boolean useOpenSLES;
        private final boolean disableBuiltInAEC;
        private final boolean disableBuiltInAGC;
        private final boolean disableBuiltInNS;
        private final boolean disableWebRtcAGCAndHPF;
        private final boolean enableRtcEventLog;
        private final boolean useLegacyAudioDevice;
        private final DataChannelParameters dataChannelParameters;

        public PeerConnectionParameters(boolean loopback, boolean tracing, int videoWidth, int videoHeight, int videoFps, int videoMaxBitrate, String videoCodec, boolean videoCodecHwAcceleration, boolean videoFlexfecEnabled, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean aecDump, boolean saveInputAudioToFile, boolean useOpenSLES, boolean disableBuiltInAEC, boolean disableBuiltInAGC, boolean disableBuiltInNS, boolean disableWebRtcAGCAndHPF, boolean enableRtcEventLog, boolean useLegacyAudioDevice, DataChannelParameters dataChannelParameters) {
            this.loopback = loopback;
            this.tracing = tracing;
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            this.videoMaxBitrate = videoMaxBitrate;
            this.videoCodec = videoCodec;
            this.videoFlexfecEnabled = videoFlexfecEnabled;
            this.videoCodecHwAcceleration = videoCodecHwAcceleration;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.aecDump = aecDump;
            this.saveInputAudioToFile = saveInputAudioToFile;
            this.useOpenSLES = useOpenSLES;
            this.disableBuiltInAEC = disableBuiltInAEC;
            this.disableBuiltInAGC = disableBuiltInAGC;
            this.disableBuiltInNS = disableBuiltInNS;
            this.disableWebRtcAGCAndHPF = disableWebRtcAGCAndHPF;
            this.enableRtcEventLog = enableRtcEventLog;
            this.useLegacyAudioDevice = useLegacyAudioDevice;
            this.dataChannelParameters = dataChannelParameters;
        }
    }

    public static class DataChannelParameters {
        public final boolean ordered;
        public final int maxRetransmitTimeMs;
        public final int maxRetransmits;
        public final String protocol;
        public final boolean negotiated;
        public final int id;

        public DataChannelParameters(boolean ordered, int maxRetransmitTimeMs, int maxRetransmits, String protocol, boolean negotiated, int id) {
            this.ordered = ordered;
            this.maxRetransmitTimeMs = maxRetransmitTimeMs;
            this.maxRetransmits = maxRetransmits;
            this.protocol = protocol;
            this.negotiated = negotiated;
            this.id = id;
        }
    }
}

