/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.video;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.netacom.base.chat.android_utils.AppUtils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.R;
import com.netacom.full.widget.video.IPlayerClickListener;
import com.netacom.full.widget.video.PlayerExoHelper;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001d\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u0004\u0018\u00010\"J\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001cJ\u0006\u0010(\u001a\u00020\u001cJ\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u001eJ\r\u0010+\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010,J\r\u0010-\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010,J;\u0010.\u001a\u00020\u001e2\b\u0010/\u001a\u0004\u0018\u00010\u00192\b\u00100\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u0004\u0018\u00010\u001e2\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00105J\u0006\u00106\u001a\u00020\u001eJ\u000e\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001cJ\u000e\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020\bJ\u0006\u0010;\u001a\u00020\u001eJ\u0006\u0010<\u001a\u00020\u001eJ\u001a\u0010=\u001a\u00020\u001e2\b\u0010>\u001a\u0004\u0018\u00010\u00002\b\u0010?\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/netacom/full/widget/video/ExoPlayerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DefaultHttpDataSource$Factory;", "exoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "loadControl", "Lcom/google/android/exoplayer2/LoadControl;", "playerView", "Lcom/google/android/exoplayer2/ui/PlayerView;", "trackSelector", "Lcom/google/android/exoplayer2/trackselection/DefaultTrackSelector;", "buildMediaResource", "Lcom/google/android/exoplayer2/source/MediaSource;", "linkStream", "Landroid/net/Uri;", "apphash", "", "token", "checkPlayer", "", "createExoPlayer", "", "playerExoHelper", "Lcom/netacom/full/widget/video/PlayerExoHelper;", "getPlayer", "Lcom/google/android/exoplayer2/Player;", "getTrackSelector", "hideController", "initializePlayer", "isBuffering", "isPlaying", "isShowController", "pauseExoPlayer", "releasePlayer", "replay", "()Lkotlin/Unit;", "retry", "runExoPlayer", "linkUrl", "subtitle", "position", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)V", "seekTo", "(J)Lkotlin/Unit;", "setMutePlayer", "setPlayWhenReady", "shouldAutoPlay", "setResizeModeRaw", "resizeMode", "setUnMutePlayer", "stopExoPlayer", "switchTargetView", "oldPlayerView", "newPlayerView", "netacom-sdk-full_NetAloProdRelease"})
public final class ExoPlayerView
extends FrameLayout {
    @org.jetbrains.annotations.Nullable
    private PlayerView playerView;
    @org.jetbrains.annotations.Nullable
    private SimpleExoPlayer exoPlayer;
    private DefaultHttpDataSource.Factory dataSourceFactory;
    private DefaultTrackSelector trackSelector;
    private LoadControl loadControl;

    public ExoPlayerView(@NonNull @NotNull Context context, @Nullable @org.jetbrains.annotations.Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    @JvmOverloads
    public ExoPlayerView(@NonNull @NotNull Context context, @Nullable @org.jetbrains.annotations.Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public /* synthetic */ ExoPlayerView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public final void initializePlayer() {
        if (this.playerView == null) {
            Context context = this.getContext().getApplicationContext();
            LayoutInflater.from((Context)context).inflate(R.layout.view_video_player, (ViewGroup)this);
            this.playerView = (PlayerView)this.findViewById(R.id.exoPlayer);
            DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(Util.getUserAgent((Context)context, (String)((Object)((Object)this)).getClass().getSimpleName()));
            Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"Factory().setUserAgent(Util.getUserAgent(context, this::class.java.simpleName))");
            this.dataSourceFactory = factory;
        }
    }

    public final void createExoPlayer(@NotNull PlayerExoHelper playerExoHelper) {
        Intrinsics.checkNotNullParameter((Object)playerExoHelper, (String)"playerExoHelper");
        if (this.exoPlayer == null) {
            boolean bl;
            boolean bl2;
            DefaultLoadControl defaultLoadControl;
            DefaultLoadControl defaultLoadControl2 = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 2500, 5000).build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultLoadControl2, (String)"Builder()\n                .setBufferDurationsMs(\n                    DefaultLoadControl.DEFAULT_MAX_BUFFER_MS,\n                    DefaultLoadControl.DEFAULT_MAX_BUFFER_MS,\n                    DefaultLoadControl.DEFAULT_BUFFER_FOR_PLAYBACK_MS,\n                    DefaultLoadControl.DEFAULT_BUFFER_FOR_PLAYBACK_AFTER_REBUFFER_MS\n                )\n                .build()");
            this.loadControl = (LoadControl)defaultLoadControl2;
            this.trackSelector = new DefaultTrackSelector(this.getContext(), (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
            defaultLoadControl2 = this.trackSelector;
            if (defaultLoadControl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"trackSelector");
                throw null;
            }
            SimpleExoPlayer.Builder builder = new SimpleExoPlayer.Builder(this.getContext()).setTrackSelector((TrackSelector)defaultLoadControl2);
            defaultLoadControl2 = this.loadControl;
            if (defaultLoadControl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadControl");
                throw null;
            }
            this.exoPlayer = builder.setLoadControl((LoadControl)defaultLoadControl2).build();
            defaultLoadControl2 = this.exoPlayer;
            if (defaultLoadControl2 != null) {
                defaultLoadControl = defaultLoadControl2;
                bl2 = false;
                bl = false;
                DefaultLoadControl $this$createExoPlayer_u24lambda_u2d0 = defaultLoadControl;
                boolean bl3 = false;
                $this$createExoPlayer_u24lambda_u2d0.addVideoListener((VideoListener)playerExoHelper);
                $this$createExoPlayer_u24lambda_u2d0.addListener((Player.EventListener)playerExoHelper);
            }
            defaultLoadControl2 = this.playerView;
            if (defaultLoadControl2 != null) {
                defaultLoadControl = defaultLoadControl2;
                bl2 = false;
                bl = false;
                DefaultLoadControl $this$createExoPlayer_u24lambda_u2d2 = defaultLoadControl;
                boolean bl4 = false;
                $this$createExoPlayer_u24lambda_u2d2.setPlayer((Player)this.exoPlayer);
                $this$createExoPlayer_u24lambda_u2d2.setControllerVisibilityListener(arg_0 -> ExoPlayerView.createExoPlayer$lambda-2$lambda-1(playerExoHelper, arg_0));
                Player player = $this$createExoPlayer_u24lambda_u2d2.getPlayer();
                if (player != null) {
                    player.prepare();
                }
            }
        }
    }

    public final boolean checkPlayer() {
        return this.exoPlayer != null;
    }

    @org.jetbrains.annotations.Nullable
    public final Player getPlayer() {
        return (Player)this.exoPlayer;
    }

    @NotNull
    public final DefaultTrackSelector getTrackSelector() {
        DefaultTrackSelector defaultTrackSelector = this.trackSelector;
        if (defaultTrackSelector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trackSelector");
            throw null;
        }
        return defaultTrackSelector;
    }

    public final void setMutePlayer() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setVolume(0.0f);
        }
    }

    public final void setUnMutePlayer() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setVolume(1.0f);
        }
    }

    public final void runExoPlayer(@org.jetbrains.annotations.Nullable String linkUrl, @org.jetbrains.annotations.Nullable String subtitle, @org.jetbrains.annotations.Nullable Long position, @NotNull String apphash, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)apphash, (String)"apphash");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        CharSequence charSequence = linkUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        Logger.INSTANCE.e("runExoPlayer = " + linkUrl + " subtitle = " + subtitle, new Object[0]);
        charSequence = this.exoPlayer;
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            bl2 = false;
            boolean bl3 = false;
            CharSequence player = charSequence2;
            boolean bl4 = false;
            String $this$toUri$iv = linkUrl;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.parse(this)");
            player.setMediaSource(this.buildMediaResource(uri, apphash, token));
            player.prepare();
            if (position != null) {
                long l = 0L;
                if (position != l) {
                    player.seekTo(position);
                }
            }
            player.setPlayWhenReady(true);
            DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
            if (factory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                throw null;
            }
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"check header = ", (Object)factory.getDefaultRequestProperties()), new Object[0]);
        }
    }

    public static /* synthetic */ void runExoPlayer$default(ExoPlayerView exoPlayerView, String string2, String string3, Long l, String string4, String string5, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        exoPlayerView.runExoPlayer(string2, string3, l, string4, string5);
    }

    private final MediaSource buildMediaResource(Uri linkStream, String apphash, String token) {
        MediaSource mediaSource;
        Map tokenRequestProperties;
        Map map = tokenRequestProperties = (Map)new HashMap();
        Object object = "TC-Token";
        boolean bl = false;
        map.put(object, token);
        Map keyRequestProperties = new HashMap();
        object = keyRequestProperties;
        String string2 = "app";
        String string3 = AppUtils.getAppPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAppPackageName()");
        boolean bl2 = false;
        object.put(string2, string3);
        object = keyRequestProperties;
        string2 = "apphash";
        boolean bl3 = false;
        object.put(string2, apphash);
        object = this.dataSourceFactory;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
            throw null;
        }
        object.setDefaultRequestProperties(tokenRequestProperties);
        int type = Util.inferContentType((Uri)linkStream);
        switch (type) {
            case 0: {
                DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                factory.setDefaultRequestProperties(keyRequestProperties);
                factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                string2 = new DashMediaSource.Factory((DataSource.Factory)factory).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                dataSourceFactory.setDefaultRequestProperties(keyRequestProperties)\n                DashMediaSource.Factory(dataSourceFactory).createMediaSource(MediaItem.fromUri(linkStream))\n            }");
                mediaSource = (MediaSource)string2;
                break;
            }
            case 1: {
                DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                factory.setDefaultRequestProperties(keyRequestProperties);
                factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                string2 = new SsMediaSource.Factory((DataSource.Factory)factory).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                dataSourceFactory.setDefaultRequestProperties(keyRequestProperties)\n                SsMediaSource.Factory(dataSourceFactory).createMediaSource(MediaItem.fromUri(linkStream))\n            }");
                mediaSource = (MediaSource)string2;
                break;
            }
            case 2: {
                DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                factory.setDefaultRequestProperties(keyRequestProperties);
                factory = this.dataSourceFactory;
                if (factory == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    throw null;
                }
                string2 = new HlsMediaSource.Factory((DataSource.Factory)factory).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                dataSourceFactory.setDefaultRequestProperties(keyRequestProperties)\n                HlsMediaSource.Factory(dataSourceFactory).createMediaSource(MediaItem.fromUri(linkStream))\n            }");
                mediaSource = (MediaSource)string2;
                break;
            }
            case 4: {
                ProgressiveMediaSource progressiveMediaSource;
                String string4 = linkStream.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"linkStream.toString()");
                if (ExtensionsUtilsKt.isLocalLink((String)string4)) {
                    DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.getContext(), Util.getUserAgent((Context)this.getContext(), (String)((Object)((Object)this)).getClass().getSimpleName()));
                    progressiveMediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                } else {
                    string4 = this.dataSourceFactory;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                        throw null;
                    }
                    string4.setDefaultRequestProperties(keyRequestProperties);
                    string4 = this.dataSourceFactory;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                        throw null;
                    }
                    progressiveMediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)string4).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                }
                string2 = progressiveMediaSource;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                if (linkStream.toString().isLocalLink()) {\n                    val dataSourceFactory = DefaultDataSourceFactory(context, Util.getUserAgent(context, this::class.java.simpleName))\n                    ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(MediaItem.fromUri(linkStream))\n                } else {\n                    dataSourceFactory.setDefaultRequestProperties(keyRequestProperties)\n                    ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(MediaItem.fromUri(linkStream))\n                }\n            }");
                mediaSource = (MediaSource)string2;
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unsupported type: ", (Object)type));
            }
        }
        return mediaSource;
    }

    public final void releasePlayer() {
        this.stopExoPlayer();
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.release();
        }
        this.exoPlayer = null;
    }

    public final boolean isPlaying() {
        SimpleExoPlayer simpleExoPlayer;
        return this.exoPlayer != null && Intrinsics.areEqual((Object)((simpleExoPlayer = this.exoPlayer) == null ? null : Boolean.valueOf(simpleExoPlayer.isPlaying())), (Object)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBuffering() {
        if (this.exoPlayer == null) return false;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            return false;
        }
        Integer n = simpleExoPlayer.getPlaybackState();
        int n2 = 2;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    public final boolean isShowController() {
        boolean bl;
        PlayerView playerView;
        return this.playerView != null && ((playerView = this.playerView) == null ? false : (bl = playerView.isControllerVisible()));
    }

    public final void setPlayWhenReady(boolean shouldAutoPlay) {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setPlayWhenReady(shouldAutoPlay);
        }
    }

    @org.jetbrains.annotations.Nullable
    public final Unit retry() {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            unit = null;
        } else {
            simpleExoPlayer.prepare();
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public final void pauseExoPlayer() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer $this$pauseExoPlayer_u24lambda_u2d4 = simpleExoPlayer2;
            boolean bl3 = false;
            $this$pauseExoPlayer_u24lambda_u2d4.pause();
        }
    }

    public final void stopExoPlayer() {
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer $this$stopExoPlayer_u24lambda_u2d5 = simpleExoPlayer2;
            boolean bl3 = false;
            $this$stopExoPlayer_u24lambda_u2d5.seekTo(0L);
            $this$stopExoPlayer_u24lambda_u2d5.stop();
        }
    }

    @org.jetbrains.annotations.Nullable
    public final Unit replay() {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            unit = null;
        } else {
            simpleExoPlayer.seekTo(0L);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @org.jetbrains.annotations.Nullable
    public final Unit seekTo(long position) {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) {
            unit = null;
        } else {
            simpleExoPlayer.seekTo(position);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public final void setResizeModeRaw(int resizeMode) {
        PlayerView playerView = this.playerView;
        if (playerView != null) {
            playerView.setResizeMode(resizeMode);
        }
    }

    public final void switchTargetView(@org.jetbrains.annotations.Nullable ExoPlayerView oldPlayerView, @org.jetbrains.annotations.Nullable ExoPlayerView newPlayerView) {
        if (oldPlayerView == newPlayerView) {
            return;
        }
        if (newPlayerView != null) {
            newPlayerView.exoPlayer = this.exoPlayer;
        }
        if (oldPlayerView != null) {
            oldPlayerView.exoPlayer = null;
        }
    }

    public final void hideController() {
        PlayerView playerView = this.playerView;
        if (playerView != null) {
            playerView.setUseController(false);
        }
    }

    @JvmOverloads
    public ExoPlayerView(@NonNull @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void createExoPlayer$lambda-2$lambda-1(PlayerExoHelper $playerExoHelper, int it) {
        Intrinsics.checkNotNullParameter((Object)$playerExoHelper, (String)"$playerExoHelper");
        IPlayerClickListener iPlayerClickListener = $playerExoHelper.getPlayerClickListener();
        if (iPlayerClickListener != null) {
            iPlayerClickListener.isShowController(it == 0);
        }
    }
}

